/***************************************************************************
                          netmap.h  -  A simple netconfig tool
                             -------------------
    begin                : Thu Oct 7 1999
    copyright            : (C) 1999 by F David Sacerdoti
    email                : fds@slinuxmachines.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef NETMAP_H
#define NETMAP_H

#include <qwidget.h>
#include "nodewidget.h"

/**Netmap is a widget that will animate the search and
	discovery of a gateway and nameserver. It sets up a network map
  using nodeWidget objects.

  *@author Federico David Sacerdoti
  */

class netmap : public QWidget
{
		Q_OBJECT
public:
	/** Creates network map of nodeWidgets **/
	netmap( QWidget *parent=0, const char *name=0 );
	~netmap();
	
public slots:
	/** Activate method not used [void activate();] **/
	/** Makes the 'me' node search for its Gateway **/
	void findGateway();
	/** Called when the 'me' node finds its Gateway **/
	void foundGateway();
	/** Called when the 'me' node looses its Gateway **/
	void lostGateway();
	/** Makes the 'me' node search for its Name server **/
	void findNs();
	/** Called when the 'me' node finds its Name server **/
	void foundNs();
	/** Called when the 'me' node looses its Name server **/
	void lostNs();
	/** Erases network links **/
	void resetMap();
	
signals:

protected:

private:
	nodeWidget *you;
	nodeWidget *gateway;
	nodeWidget *ns;
};

#endif



















