/***************************************************************************
                          ipinput.cpp  -  A simple netconfig tool
                             -------------------
    begin                : Wed Oct 20 1999
    copyright            : (C) 1999 by Federico David Sacerdoti
    email                : fds@slinuxmachines.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "ipinput.h"
#include "newwidget.h"

#include <qregexp.h>


IPinput::IPinput(QWidget *parent) :
	QLineEdit(parent)
{
  setFixedHeight(sizeHint().height());
  //Make maximum visible width 16
  setFixedWidth(fontMetrics().width('H') * 16);
  //Make maximum input 15 characters (length of 4-dot internet notation)
  setMaxLength(15);

 	QColor cRed(191,86,79);
 	QColorGroup gRed(white, cRed, cRed.light(), cRed.dark(),
	cRed.dark(120), white, cRed);
	red = * new QPalette( gRed, gRed, gRed );

}

IPinput::~IPinput(){
}

void IPinput::bad() {

  setPalette (red);	//Its not a good IP address. Make box red
  setFocus();

}


QString IPinput::getIP() {

	  QString s = text();
	  if (checkIP(s) == false) {
	  	bad();
	  	return "Bad address";
	  }
    //else
    	if (palette() == red) setPalette(parentWidget()->palette());
		  return s;
}


bool IPinput::checkIP (const QString & ip)
{
  QRegExp alpha = QRegExp("[a-z]", false, false);
  QRegExp dots = QRegExp("\\.", false, false);
  QRegExp octets = QRegExp ("[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+", false, false);
  QRegExp octet = QRegExp ("[0-9]+\\.", false, false);
  if (ip.length() < 7) return false;	//Must beat least 1.1.1.1
	if (ip.contains(alpha)) return false;
	if (ip.contains(dots) != 3)  return false; //Gotta have four dots
	if (ip.find(octets) == -1) return false;  //must have 4 sets of octets
	
	uint o1, o2, o3, o4; //No octet can be more than 255 decimal
	sscanf ((const char*)ip, "%u.%u.%u.%u", &o1, &o2, &o3, &o4);
	if (o1 > 255 || o2 > 255 || o3 > 255 || o4 > 255) return false;
	//if (o1 == 0 || o2 == 0 || o3 == 0 || o4 == 0) return false;  //None can be zero
	
	return true; //It's an ok IP address according to our tests.
}	
































