/***************************************************************************
                          kmasqdialer.h  -  description
                             -------------------
    begin                : Tue Aug 24 01:15:56 BST 1999
    copyright            : (C) 1999 by Darren Poulson
    email                : daz@flapper.demon.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMASQDIALER_H
#define KMASQDIALER_H

#include <clientconfig.h>
#include "kdockdialer.h"
#include "kconnectioninfo.h"
#include <references.h>
#include <mclient.h>

#include <kapp.h>
#include <kwm.h>
#include <kmsgbox.h>
#include <kstatusbar.h>
#include <kmenubar.h>
#include <ktopwidget.h>
#include <klined.h>
#include <kiconloader.h>


#include <qcombobox.h>
#include <qwidget.h>
#include <qmessagebox.h>
#include <qpopupmenu.h>

  /** Kmasqdialer main class
	 * @author Darren Poulson <daz@flapper.demon.co.uk>
   * @short Main class of kmasqdialer
   */

class Kmasqdialer : public KTopLevelWidget {
  Q_OBJECT
public:
  /** Construtor */
  Kmasqdialer(QWidget*parent=0,const char* name=0);

  /** Destructor */
  ~Kmasqdialer();

  /** Create Config object */
	KConfig *config;

public slots:
  /** Add a connection to the connections list box
	* @param cname Connection name
	* @return null
	*/
  void slotAddConnection(const char *);

	/** Sets the status message at the bottom of the window
	* @param msg Message to be shown
	* @return null
	*/
	void slotSetStatusMsg(const char *);


private slots:
	/** Show the default About Qt box */
	void slotAboutQt();

	/** Is one sure one wants to quit? */
	void slotFileQuit();

	/** Handles resize Events */
	void resizeEvent (QResizeEvent *);

  /** Menu option, Hangup */
  void slotConnectHangup();

  /** Menu Option, Dial */
  void slotConnectDial();

  /** Menu Option, Disconnect from server */
  void slotServerDisConnect();

  /** Menu Option, Connect to server */
  void slotServerConnect();

  /** Menu Option, Connection Information */
  void slotServerCInfo();



private:

	KMenuBar 			*menubar;
	QPopupMenu		*servermenu;
	QPopupMenu		*connectionmenu;
	QPopupMenu		*helpmenu;
	KStatusBar		*statusbar;
	KLined				*servername;
	KLined				*serverport;
  ClientConfig	*cconfig;
  MClient 			*server;
  QComboBox			*connections;

};
#endif








