// $Id: recvwindow.cpp,v 1.14 1998/12/08 16:29:28 denis Exp $
// $Log: recvwindow.cpp,v $
// Revision 1.14  1998/12/08 16:29:28  denis
// Cleaned up a little before releasing
//

#include <kapp.h>
#include <kiconloader.h>
#include <qpalette.h>
#include "recvwindow.h"
#include "mainwindow.h"

#include "recvwindow.moc"

RecvWindow::RecvWindow(QList<icqMessage> *l,int i,unsigned long u,int d) : QDialog()
{
  list = l ;
  start = idx = i ;
  msgUin = u ;
  delflag = d ;

  QPixmap infopix;

  KIconLoader *il = kapp->getIconLoader();
  frombox = new QGroupBox("From",this);
  handleline = new QLineEdit(this);
  handleline->setFocusPolicy(QWidget::NoFocus);
  handlelabel = new QLabel(handleline,"Handle:",this);
  uinline = new QLineEdit(this);
  uinline->setFocusPolicy(QWidget::NoFocus);
  uinlabel = new QLabel(uinline,"ICQ#:",this);
  emailline = new QLineEdit(this);
  emailline->setFocusPolicy(QWidget::NoFocus);
  emaillabel = new QLabel(emailline,"EMail:",this);
  dateline = new QLineEdit(this);
  dateline->setFocusPolicy(QWidget::NoFocus);
  datelabel = new QLabel(uinline,"Date:",this);
  timeline = new QLineEdit(this);
  timeline->setFocusPolicy(QWidget::NoFocus);
  timelabel = new QLabel(uinline,"Time:",this);
  infobutton = new QPushButton(this);
  infopix = il->loadIcon("info.xpm");
  infobutton->setPixmap(infopix);
  infobutton->resize(infopix.width()+6, infopix.height()+6);
  connect(infobutton, SIGNAL(clicked()), SLOT(infoRequest()));
  msgbox = new QGroupBox("Message",this);
  msgedit = new QMultiLineEdit(this);
  msgedit->setFocusPolicy(QWidget::NoFocus);
  descedit = new QMultiLineEdit(this);
  descedit->setFocusPolicy(QWidget::NoFocus);
  desclabel = new QLabel(descedit,"URL Description:",this);
  urlline = new QLineEdit(this);
  urlline->setText("http://");
  urlline->setFocusPolicy(QWidget::NoFocus);
  urllabel = new QLabel(urlline,"URL:",this);
  respbox = new QGroupBox("Response Action:",this);
  addbtn = new QPushButton("Add To Contact List",this);
  connect(addbtn, SIGNAL(clicked()), SLOT(addRequest()));
  replybtn = new QPushButton("Reply",this);
  connect(replybtn, SIGNAL(clicked()), SLOT(replyRequest()));
  closebtn = new QPushButton("Close",this);
  connect(closebtn, SIGNAL(clicked()), SLOT(closeBtn()));
  nextbtn = new QPushButton("Read Next",this);
  connect(nextbtn, SIGNAL(clicked()), SLOT(readNext())) ;

  readNext();

  if(((MainWindow*)kapp->topWidget())->listWidget()->isUINInContactList(msgUin))
    addbtn->setEnabled(FALSE);
  replybtn->setFocus();
  resize(430,330);
  setMinimumSize(430,330);
}

RecvWindow::~RecvWindow()
{
  if(replybtn)
    delete replybtn;
  if(closebtn)
    delete closebtn;
  if(nextbtn)
    delete nextbtn;
  if(addbtn)
    delete addbtn;
  if(frombox)
    delete frombox;
  if(msgbox)
    delete msgbox;
  if(respbox)
    delete respbox;
  if(uinlabel)
    delete uinlabel;
  if(handlelabel)
    delete handlelabel;
  if(emaillabel)
    delete emaillabel;
  if(datelabel)
    delete datelabel;
  if(timelabel)
    delete timelabel;
  if(uinline)
    delete uinline;
  if(handleline)
    delete handleline;
  if(emailline)
    delete emailline;
  if(dateline)
    delete dateline;
  if(timeline)
    delete timeline;
  if(infobutton)
    delete infobutton;
  if(msgedit)
    delete msgedit;
}

void RecvWindow::resizeEvent(QResizeEvent *re)
{
  QSize handlelblsize, handlelinesize, uinlblsize, uinlinesize,
    emaillblsize, emaillinesize, datelblsize, datelinesize,
    timelblsize, timelinesize, fromboxsize, closebtnsize, nextbtnsize,
    replybtnsize, addbtnsize;
  QDialog::resizeEvent(re);
  fromboxsize.setWidth(width()-6);
  handlelblsize = handlelabel->sizeHint();
  handlelinesize = handleline->sizeHint();
  uinlblsize = uinlabel->sizeHint();
  uinlinesize = uinline->sizeHint();
  emaillblsize = emaillabel->sizeHint();
  emaillinesize = emailline->sizeHint();
  datelblsize = datelabel->sizeHint();
  datelinesize = dateline->sizeHint();
  timelblsize = timelabel->sizeHint();
  timelinesize = timeline->sizeHint();
  int h = QMAX(QMAX(QMAX(QMAX(handlelblsize.height(),handlelinesize.height()),
                         QMAX(uinlblsize.height(),uinlinesize.height())),
                    QMAX(QMAX(emaillblsize.height(),emaillinesize.height()),
                         QMAX(datelblsize.height(),datelinesize.height()))),
               QMAX(timelblsize.height(),timelinesize.height()));
  int w1 = QMAX(handlelblsize.width(),uinlblsize.width());
  handlelabel->resize(w1,h);
  uinlabel->resize(w1,h);
  int w2 = QMAX(QMAX(emaillblsize.width(),datelblsize.width()),timelblsize.width());
  emaillabel->resize(w2,h);
  datelabel->resize(w2,h);
  timelabel->resize(w2,h);
  int w = (int)((fromboxsize.width()-70)/2.6);
  int we = fromboxsize.width()-70-w;
  handlelabel->move(12,15);
  uinlabel->move(12,handlelabel->y()+handlelabel->height()+5);
  handleline->setGeometry(handlelabel->x()+w1+5,handlelabel->y(),w-w1,h);
  uinline->setGeometry(handleline->x(),uinlabel->y(),w-w1,h);
  emaillabel->move(w+25,handlelabel->y());
  datelabel->move(w+25,uinlabel->y());
  emailline->setGeometry(emaillabel->x()+w2+5,emaillabel->y(),we-w2,h);
  int w4 = (int)((we-w2*2-10)/2.6);
  int w3 = we-w2*2-10-w4;
  dateline->setGeometry(emailline->x(),datelabel->y(),w3,h);
  timelabel->move(w+w3+datelabel->width()+40,datelabel->y());
  timeline->setGeometry(emailline->x()+emailline->width()-w4,timelabel->y(),w4,h);
  frombox->setGeometry(3,3,fromboxsize.width(),h*2+24);
  infobutton->move(frombox->x()+frombox->width()-infobutton->width()-12,
                   emailline->y()+(emailline->height()-infobutton->height())/2);
  closebtnsize = closebtn->sizeHint();
  nextbtnsize = nextbtn->sizeHint();
  h = QMAX(closebtnsize.height(),nextbtnsize.height());
  w = QMAX(closebtnsize.width(),nextbtnsize.width());
  closebtn->setGeometry(width()-w*2-20,height()-h-6,w,h);
  nextbtn->setGeometry(width()-w-10,height()-h-6,w,h);
  msgbox->setGeometry(3,frombox->height()+6,width()-6,height()-frombox->height()-h-19);
  replybtnsize = replybtn->sizeHint();
  addbtnsize = addbtn->sizeHint();
  h = QMAX(replybtnsize.height(),addbtnsize.height());
  w = QMAX(replybtnsize.width(),addbtnsize.width());
  respbox->setGeometry(9,msgbox->y()+msgbox->height()-h-36,width()-18,h+30);
  addbtn->setGeometry(respbox->x()+(respbox->width()-w*2-10)/2,respbox->y()+18,w,h);
  replybtn->setGeometry(addbtn->x()+addbtn->width()+10,respbox->y()+18,w,h);
  urlline->setGeometry(10,respbox->y()-urlline->sizeHint().height()-3,
                       width()-22,urlline->sizeHint().height());
  urllabel->setGeometry(10,urlline->y()-urllabel->sizeHint().height()-3,
                        width()-22,urllabel->sizeHint().height());
  desclabel->setGeometry(10,msgbox->y()+17,width()-22,desclabel->sizeHint().height());
  descedit->setGeometry(10,desclabel->y()+desclabel->height()+3,width()-22,
                        msgbox->height()-respbox->height()-urlline->height()-
                        urllabel->height()-desclabel->height()-35);
  msgedit->setGeometry(10,msgbox->y()+17,width()-22,msgbox->height()-respbox->height()-25);
}

void RecvWindow::setMessage(const char *message)
{
  msgedit->setText(message);
}

void RecvWindow::setURL(const char *url)
{
  urlline->setText(url);
}

void RecvWindow::setDescription(const char *description)
{
  descedit->setText(description);
}

void RecvWindow::setUIN(unsigned long u)
{
  QString text;
  text.setNum(u);
  uinline->setText(text);
}

unsigned long RecvWindow::UIN()
{
  return msgUin;
}

void RecvWindow::setName(const char *name)
{
  nick = name;
  handleline->setText(name);
}

void RecvWindow::setEMail(const char *pemail)
{
  email = pemail;
  emailline->setText(email);
}

void RecvWindow::setTime(TimeStr msgtime)
{
  QString date;
  QString time;
  date.sprintf("%02i/%02i/%04i", msgtime.day, msgtime.month, msgtime.year);
  dateline->setText(date);
  time.sprintf("%02i:%02i", msgtime.hour, msgtime.minute);
  timeline->setText(time);
}

void RecvWindow::closeBtn()
{
  hide();
  if(delflag)
    ((MainWindow*)(kapp->topWidget()))->delRecvWin(this);
}

void RecvWindow::closeEvent(QCloseEvent *ce)
{
  QDialog::closeEvent(ce);
  if(delflag)
    ((MainWindow*)(kapp->topWidget()))->delRecvWin(this);
}

void RecvWindow::infoRequest()
{
  ContactItem tmpitem, *item = ((MainWindow*)(kapp->topWidget()))->listWidget()->getInfoByUIN(msgUin);
  if(item)
    if(((MainWindow*)(kapp->topWidget()))->listWidget()->isUINNotInList(msgUin))
      ((MainWindow*)(kapp->topWidget()))->infoShow(*item, FALSE);
    else
      ((MainWindow*)(kapp->topWidget()))->infoWindow(msgUin);
  else
  {
    tmpitem.uin = msgUin;
    ((MainWindow*)(kapp->topWidget()))->infoShow(tmpitem, FALSE);
  }
}

void RecvWindow::addRequest()
{
  ContactItem *item = ((MainWindow*)(kapp->topWidget()))->listWidget()->getInfoByUIN(msgUin);

  if(item)
  {
    ((MainWindow*)(kapp->topWidget()))->saveUser(*item);
    ((MainWindow*)(kapp->topWidget()))->listWidget()->addToContactListByUIN(item->uin);
    if(((MainWindow*)(kapp->topWidget()))->isLogged())
      icq_SendNewUser(item->uin);
    ((MainWindow*)(kapp->topWidget()))->updateContact();
  }
}

void RecvWindow::replyRequest()
{
  icqMessage *msg = list->at(idx) ;
  if(msg->type() == MSG_RECV || msg->type() == MSG_SENT)
    ((MainWindow*)(kapp->topWidget()))->messageRequest(msgUin, msgedit->text());
  if(msg->type() == MSG_URL_RECV || msg->type() == MSG_URL_SENT)
    ((MainWindow*)(kapp->topWidget()))->messageRequest(msgUin, descedit->text());
  if(((MainWindow*)(kapp->topWidget()))->isCloseRecv())
  {
    hide();
    if(delflag)
      ((MainWindow*)(kapp->topWidget()))->delRecvWin(this);
  }
}

void RecvWindow::readNext()
{
  QString eventInfo, eventType, eventDirection ;

  if(start != idx && list->count() - 1 > (unsigned int)idx) 
    idx ++ ;
  if(start == idx)
    start = -1 ;
 
  icqMessage *msg = list->at(idx) ;

  setName(((MainWindow*)(kapp->topWidget()))->listWidget()->getNickByUIN(msg->uin()));
  setUIN(msg->uin());
  setEMail(((MainWindow*)(kapp->topWidget()))->listWidget()->getEMailByUIN(msg->uin()));
  setTime(msg->time());

  if(msg->type() == MSG_RECV || msg->type() == MSG_SENT)
  {
    urlline->hide();
    urllabel->hide();
    desclabel->hide();
    descedit->hide();
    msgedit->show();
    msgbox->setTitle("Message");
    setMessage(msg->body());
    eventType = "Message " ;
  }
  else if(msg->type() == MSG_URL_RECV || msg->type() == MSG_URL_SENT)
  {
    urlline->show();
    urllabel->show();
    desclabel->show();
    descedit->show();
    msgedit->hide();
    msgbox->setTitle("URL Message");
    setURL(msg->url());
    setDescription(msg->body());
    eventType = "URL " ;
  }

  msg->expire() ;

  if(list->count() - 1 > (unsigned int)idx) 
  {
    nextbtn->setEnabled(TRUE);
    eventInfo = "" ;
  }
  else
  {
    nextbtn->setEnabled(FALSE) ;
    if(delflag)
      ((MainWindow*)(kapp->topWidget()))->listWidget()->setBlinkingByUIN(msg->uin(),FALSE);
    eventInfo = " (No More Events)" ;
  }
  if(delflag)
    ((MainWindow*)(kapp->topWidget()))->updateBlinking();

  if(msg->type() == MSG_RECV || msg->type() == MSG_URL_RECV)
  {
    frombox->setTitle("From") ;
    eventDirection = "Incoming " ;
  }
  else if(msg->type() == MSG_SENT || msg->type() == MSG_URL_SENT)
  {
    eventDirection = "Outgoing " ;
    frombox->setTitle("To") ;
  }

  recvCaption = eventDirection + eventType ;
  setCaption((const char *)(recvCaption + eventInfo)) ;
}

void RecvWindow::updateNextAvailability()
{
  if(list->count() - 1 > (unsigned int)idx)
  {
    nextbtn->setEnabled(TRUE);
    setCaption(recvCaption) ;
  }
  else
    nextbtn->setEnabled(FALSE);
}
