#ifndef _MLINELISTBOX_H
#define _MLINELISTBOX_H

#include <kapp.h>
#include <kiconloader.h>
#include <qpixmap.h>
#include <qfont.h>
#include <qpainter.h>

#if(QT_VERSION >= 140)
#define USE_LISTVIEW
#include <qlistview.h>
#else
#undef USE_LISTVIEW
#define MAX_COLS 8
#include <qlistbox.h>
#endif

/* We will use QListView, if qt is 1.40+ and */
/* QListBox otherwise */

#ifdef USE_LISTVIEW

class WMlineListBoxItem : public QListViewItem
{
public:
  WMlineListBoxItem(QListView *,int n = 255) ;

  void setText(int, const char *) ;
  void setPixmap(int,const QPixmap &) ;
  const char *key(int,bool) const { return "" ; } ;
  void setup() ;
  void setOpen(bool) ;

protected:
  void paintCell(QPainter *,const QColorGroup &,int,int,int) ;
  int totalHeight() const ;
  virtual int width(const QFontMetrics &, const QListView *, int) const ;
  int lines(int) const ;
  const QString line(int,int) const ;
  
  int showlines ;
} ;

#else

class WMlineListBoxItem : public QListBoxItem
{
public:
  WMlineListBoxItem(int) ;

  void setColumnWidth(int,int) ;
  void setText(int, const char *) ;
  void setPixmap(int, const QPixmap &) ;
  const char *key(int,bool) const { return "" ; } ;

protected:
  void paint(QPainter *) ;
  int height(const QListBox *) const ;
  virtual int width(const QListBox *) const ;
  const QPixmap *pixmap(int) const ;
  const char *text(int) const ;
  int lines(int) const ;
  const QString line(int,int) const ;
  
  int showlines ;
  
  int colWidth[MAX_COLS] ;
  QString mtext[MAX_COLS] ;
  QPixmap pmap[MAX_COLS] ;
} ;

#endif

#endif /* _MLINELISTBOX_H */
