// $Id: mlinelistbox.cpp,v 1.4 1998/12/08 16:23:19 denis Exp $
// $Log: mlinelistbox.cpp,v $
// Revision 1.4  1998/12/08 16:23:19  denis
// Cleaned up a little before releasing
//

#include "mlinelistbox.h"

int WMlineListBoxItem::lines(int column) const
{
  int c = 0, cnt = 0  ;

  do
  {
    const QString s = text(column) ;
    c = s.find('\n',c) ;
    if(c != -1) 
    {
      c++ ;
      cnt ++ ;
    }
  }
  while(c != -1) ;

  return cnt ;
}

const QString WMlineListBoxItem::line(int column,int n) const
{
  if(n > lines(column)) return QString("") ;
  int c = 0, cnt = 0, p ;
  do
  {
    p = c ;
    const QString s  = text(column) ;
    c = s.find('\n',c) ;
    if(c != -1) 
    {
      c ++ ;
      cnt ++ ;
    }
  }
  while(cnt - 1 != n && c != -1) ;

  const QString t = text(column) ;
  QString cut = t.left(c-1) ;
  QString finalcut = cut.right(c-p) ;

  return finalcut ;
}



#ifdef USE_LISTVIEW /* Not mirabilis-like history */

WMlineListBoxItem::WMlineListBoxItem(QListView *parent,int n) : QListViewItem(parent)
{
  showlines = n ;
}

void WMlineListBoxItem::setText(int c, const char * t)
{
  QListViewItem::setText(c,t) ;
  QFontMetrics fm = listView()->fontMetrics() ;  
  setHeight(QMAX(showlines * fm.lineSpacing() + 2 ,
     pixmap(c) ? (pixmap(c)->height() + 2):0)) ;
  repaint() ;
}

void WMlineListBoxItem::setPixmap(int c, const QPixmap & pm)
{
  QListViewItem::setPixmap(c,pm) ;

  QFontMetrics fm = listView()->fontMetrics() ;
  setHeight(QMAX(showlines * fm.lineSpacing() + 2,
     pixmap(c) ? (pixmap(c)->height() + 2):0)) ;
  repaint() ;
}

void WMlineListBoxItem::paintCell(QPainter *p,const QColorGroup &cg,int column,
  int width, int)
{
  if(!p) return ;

  QListView *lv = listView() ;

  int r = lv ? lv->itemMargin() : 1;

  p->fillRect( 0, 0, width, height(), cg.base() );

  int marg = lv ? lv->itemMargin() : 1;

  if ( isSelected() &&
    (column==0 || listView()->allColumnsShowFocus()) ) 
  {
    p->fillRect( r - marg, 0, width - r + marg,
                         height(), cg.text() );
    p->setPen( cg.base() );
  } 
  else
    p->setPen( cg.text() );

  int x, y ;

  QFontMetrics fm = p->fontMetrics() ;

  if(pixmap(column)) 
  {
    const QPixmap *pmap ;
    pmap = pixmap(column) ;
    p->drawPixmap(3,0,*pmap) ;
  }

  for(int i = 0 ; i < QMIN(lines(column),showlines) ; i ++)
  {
    y = fm.ascent() + fm.leading()/2 + i * fm.lineSpacing() + 1 ;
    if(pixmap(column) && y < pixmap(column)->height())
      x = 6 + pixmap(column)->width() ;
    else
      x = 3 ;
    p->drawText(x,y,(const char *)line(column,i)) ;
  }
}

void WMlineListBoxItem::setup()
{
  widthChanged() ;
}

void WMlineListBoxItem::setOpen(bool)
{

}

int WMlineListBoxItem::totalHeight() const
{
  return height() ;
}

int WMlineListBoxItem::width(const QFontMetrics &fm,const QListView *,int column) const
{

  int w, y, max = 0 ;
  
  for(int i = 0 ; i < showlines ; i ++)
  {
    const QString s = line(column,i) ;
    w = fm.width(s) ;

    y = fm.ascent() + fm.leading()/2 + i * fm.lineSpacing() + 1 ;
    const QPixmap *p = pixmap(column) ;
    if(p && y < p->height())
      w += p->height() ;

    if(w > max) max = w ;
  }

  return max ;
  
}

#else /* mirabilis-like history */

WMlineListBoxItem::WMlineListBoxItem(int s) : QListBoxItem()
{
  int i ;

  showlines = s ;
  for(i = 0 ; i < MAX_COLS ; i ++)
  {
    colWidth[i] = 0 ;
    mtext[i].setStr("") ;
    pmap[i].resize(0,0) ;
  }
}

void WMlineListBoxItem::setColumnWidth(int c,int w)
{
  if(c >= MAX_COLS) return ;

  colWidth[c] = w ;

}

void WMlineListBoxItem::setText(int c,const char *t)
{
  if(c >= MAX_COLS) return ;

  mtext[c].setStr(t) ;
}

void WMlineListBoxItem::setPixmap(int c,const QPixmap &p)
{
  if(c >= MAX_COLS) return ;
 
  pmap[c] = p ;
}

void WMlineListBoxItem::paint(QPainter *p)
{
  int i, tx, x = 0, y = 1 ;

  QFontMetrics fm = p->fontMetrics() ;
  for(i = 0 ; i < MAX_COLS ; i ++)
  {
    if(pixmap(i) != 0)
    {
      const QPixmap *pmap ;
      pmap = pixmap(i) ;
      p->drawPixmap(x + 3,y,*pmap) ;
    }

    for(int j = 0 ; j < QMIN(lines(i),showlines) ; j ++)
    {
      y = fm.ascent() + fm.leading()/2 + j * fm.lineSpacing() + 2 ;
      if(pixmap(i) && y < pixmap(i)->height())
        tx = x + 3 + pixmap(i)->width() ;
      else
        tx = x + 3 ;
      p->drawText(tx,y,(const char *)line(i,j)) ;
    }
    x += colWidth[i] ;
  }
}

int WMlineListBoxItem::height(const QListBox *lb) const
{
  int h, max = 0 ;
  QFontMetrics fm = lb->fontMetrics() ;
  for(int i = 0 ; i < MAX_COLS ; i ++)
  {
    h = QMAX(showlines * fm.lineSpacing() + 2,
          pixmap(i) ? (pixmap(i)->height() + 2):0) ;
    if(h > max) max = h ;
  }

  return max ;
}

int WMlineListBoxItem::width(const QListBox *) const
{
  int w = 0 ;
  for(int i = 0 ; i < MAX_COLS ; i ++)
    w += colWidth[i] ;

  return w ;
}

const QPixmap *WMlineListBoxItem::pixmap(int c) const
{
  return( pmap[c].isNull() ? (const QPixmap *)NULL : &pmap[c]) ;
}

const char *WMlineListBoxItem::text(int c) const
{
  return( mtext[c].length() ? (const char *)(mtext[c]) : (const char *)NULL ) ;
}

#endif
