// $Id: infomore.cpp,v 1.4 1998/12/08 16:18:01 denis Exp $
// $Log: infomore.cpp,v $
// Revision 1.4  1998/12/08 16:18:01  denis
// Cleaned up a little before releasing
//

#include "infomore.h"

#include "infomore.moc"

MoreWidget::MoreWidget(QWidget *parent) : QWidget(parent)
{
  hpline = new QLineEdit(this);
  hpline->setFocusPolicy(QWidget::NoFocus);
  ageline = new QLineEdit(this);
  ageline->setFocusPolicy(QWidget::NoFocus);
  phoneline = new QLineEdit(this);
  phoneline->setFocusPolicy(QWidget::NoFocus);
  genderline = new QLineEdit(this);
  genderline->setFocusPolicy(QWidget::NoFocus);
  hplabel = new QLabel(hpline, "HomePage",this);
  agelabel = new QLabel(ageline, "Age",this);
  phonelabel = new QLabel(phoneline, "Telephone Number",this);
  genderlabel = new QLabel(genderline, "Gender",this);
}

MoreWidget::~MoreWidget()
{
  if(hplabel)
    delete hplabel;
  if(agelabel)
    delete agelabel;
  if(phonelabel)
    delete phonelabel;
  if(genderlabel)
    delete genderlabel;
  if(hpline)
    delete hpline;
  if(ageline)
    delete ageline;
  if(phoneline)
    delete phoneline;
  if(genderline)
    delete genderline;
}

void MoreWidget::resizeEvent(QResizeEvent *re)
{
  QWidget::resizeEvent(re);
  int hlbl = QMAX(QMAX(hplabel->sizeHint().height(),agelabel->sizeHint().height()),
                  QMAX(phonelabel->sizeHint().height(),genderlabel->sizeHint().height()));
  int hline = QMAX(QMAX(hpline->sizeHint().height(),ageline->sizeHint().height()),
                   QMAX(phoneline->sizeHint().height(),genderline->sizeHint().height()));
  int w = (width()-20)/4;
  int h = height()/2;
  hplabel->setGeometry(6,15,w*3,hlbl);
  hpline->setGeometry(6,15+hlbl,w*3,hline);
  agelabel->setGeometry(w*3+15,15,w,hlbl);
  ageline->setGeometry(w*3+15,15+hlbl,w,hline);
  phonelabel->setGeometry(6,10+h,w*3,hlbl);
  phoneline->setGeometry(6,10+h+hlbl,w*3,hline);
  genderlabel->setGeometry(w*3+15,10+h,w,hlbl);
  genderline->setGeometry(w*3+15,10+h+hlbl,w,hline);
}

void MoreWidget::setInfo(const char *php, unsigned int page, const char *pphone, const char *pgender)
{
  hpline->setText(php);
  QString pstr;
  page==0?pstr="Not Entered":pstr.setNum(page);
  ageline->setText((const char*)pstr);
  phoneline->setText(strlen(pphone)==0?"Not Entered":pphone);
  genderline->setText(strlen(pgender)==0?"Not Entered":pgender);
}
