// $Id: findwindow.cpp,v 1.7 1998/12/08 16:15:49 denis Exp $
// $Log: findwindow.cpp,v $
// Revision 1.7  1998/12/08 16:15:49  denis
// Cleaned up a little before releasing
//

#include <kapp.h>
#include <qmovie.h>
#include <qmsgbox.h>
#include <icq.h>
#include "findwindow.h"
#include "mainwindow.h"

#include "findwindow.moc"

FindWindow::FindWindow() : QDialog()
{
  setCaption("Search Engine");
  tabctl = new KTabCtl(this);
  emailwidget = new EMailWidget(tabctl);
  detailswidget = new DetailsWidget(tabctl);
  uinwidget = new UINWidget(tabctl);
  tabctl->addTab(emailwidget,"EMail");
  tabctl->addTab(detailswidget,"Details");
  tabctl->addTab(uinwidget,"ICQ #");
  connect(tabctl, SIGNAL(tabSelected(int)), SLOT(changeTab(int)));
  btnbox = new QGroupBox(this);
  searchbtn = new QPushButton("Search",this);
  connect(searchbtn, SIGNAL(clicked()), SLOT(searchCommand()));
  stopbtn = new QPushButton("Stop",this);
  stopbtn->setEnabled(FALSE);
  connect(stopbtn, SIGNAL(clicked()), SLOT(stopCommand()));
  newbtn = new QPushButton("New Search",this);
  connect(newbtn, SIGNAL(clicked()), SLOT(clearCommand()));
  searchanim = new QLabel(this);
  QString filename = kapp->kde_datadir()+"/"+kapp->appName()+"/pics/search.gif";
  searchanim->setMovie(QMovie((const char*)filename));
  searchanim->movie()->pause();
  foundlist = new KTabListBox(this,0,6);
  foundlist->setColumn(0,"ICQ#");
  foundlist->setColumn(1,"Handle");
  foundlist->setColumn(2,"First Name");
  foundlist->setColumn(3,"Last Name");
  foundlist->setColumn(4,"EMail");
  foundlist->setColumn(5,"A");
  connect(foundlist, SIGNAL(popupMenu(int, int)), SLOT(popupRequest(int, int)));
  QPalette pal = foundlist->palette();
  QColorGroup colgrp = pal.normal();
  pal.setNormal(QColorGroup(colgrp.foreground(),colgrp.background(),colgrp.light(),colgrp.dark(),colgrp.mid(),colgrp.text(),colgrp.base()));
  foundlist->setPalette(pal);

  KIconLoader *il = kapp->getIconLoader();
  popup = new QPopupMenu();
  popup->insertItem(il->loadIcon("add.xpm"),"Add to contact list", this, SLOT(addRequest()));
  popup->insertItem(il->loadIcon("info.xpm"),"Info", this, SLOT(infoRequest()));

  resize(400,300);
  setMinimumSize(400,300);
}

FindWindow::~FindWindow()
{
  if(btnbox)
    delete btnbox;
  if(searchbtn)
    delete searchbtn;
  if(stopbtn)
    delete stopbtn;
  if(newbtn)
    delete newbtn;
  if(searchanim)
    delete searchanim;
  if(foundlist)
    delete foundlist;
  if(emailwidget)
    delete emailwidget;
  if(detailswidget)
    delete detailswidget;
  if(uinwidget)
    delete uinwidget;
  if(tabctl)
    delete tabctl;
  if(popup)
    delete popup;
}

void FindWindow::resizeEvent(QResizeEvent *re)
{
  QDialog::resizeEvent(re);
  int mh = (height()-6)/3;
  tabctl->setGeometry(3,3,width()-110,height()-mh-7);
  btnbox->setGeometry(width()-100,5,width()-tabctl->width()-15,height()-mh-11);
  int h = btnbox->height()/5;
  searchbtn->setGeometry(btnbox->x()+7,12,btnbox->width()-14,25);
  stopbtn->setGeometry(btnbox->x()+7,12+h,btnbox->width()-14,25);
  newbtn->setGeometry(btnbox->x()+7,12+h*2,btnbox->width()-14,25);
  searchanim->setGeometry(btnbox->x()+(btnbox->width()-32)/2,height()-mh-50,32,32);
  searchanim->movie()->restart();
  int w = width()-12;
  foundlist->setGeometry(3,height()-mh,width()-7,mh-3);
  foundlist->setColumnWidth(0,(int)(w*0.15));
  foundlist->setColumnWidth(1,(int)(w*0.15));
  foundlist->setColumnWidth(2,(int)(w*0.18));
  foundlist->setColumnWidth(3,(int)(w*0.21));
  foundlist->setColumnWidth(4,(int)(w*0.23));
  foundlist->setColumnWidth(5,foundlist->width()-foundlist->columnWidth(0)-
                            foundlist->columnWidth(1)-foundlist->columnWidth(2)-
                            foundlist->columnWidth(3)-foundlist->columnWidth(4)-15);
  foundlist->repaint();
}

void FindWindow::searchCommand()
{
  if(((MainWindow*)(kapp->topWidget()))->isLogged())
  {
    if(curtab==0 && !strlen(emailwidget->email()))
    {
      QMessageBox::warning(this, "Error", "Empty E-Mail query");
      return;
    }
    if(curtab==1 && !strlen(detailswidget->nick()) && !strlen(detailswidget->first()) && !strlen(detailswidget->last()))
    {
      QMessageBox::warning(this, "Error", "Empty Details query");
      return;
    }
    if(curtab==2 && uinwidget->isEmpty())
    {
      QMessageBox::warning(this, "Error", "Empty ICQ# query");
      return;
    }
    searchanim->movie()->unpause();
    searchbtn->setEnabled(FALSE);
    stopbtn->setEnabled(TRUE);
    newbtn->setEnabled(FALSE);
    icq_UserFound = userFound;
    icq_SearchDone = searchDone;
    if(curtab==0)
      icq_SendSearchReq(emailwidget->email(),"","","");
    else if(curtab==1)
      icq_SendSearchReq("",detailswidget->nick(),detailswidget->first(),detailswidget->last());
    else if(curtab==2)
      icq_SendSearchUINReq(uinwidget->uin());
  }
  else
    QMessageBox::warning(this, "Error", "You are not connected to the icq network!");
}

void FindWindow::stopCommand()
{
  searchanim->movie()->pause();
  searchbtn->setEnabled(TRUE);
  stopbtn->setEnabled(FALSE);
  newbtn->setEnabled(TRUE);
}

void FindWindow::clearCommand()
{
  emailwidget->clear();
  detailswidget->clear();
  uinwidget->clear();
  foundlist->clear();
  foundlist->repaint();
}

void FindWindow::addUserLine(unsigned long uin, const char *nick, const char *first, const char *last, const char *email, char auth)
{
  QString iuin;
  iuin.setNum(uin);
  foundlist->insertItem((const char*)iuin);
  foundlist->changeItemPart(nick, foundlist->count()-1, 1);
  foundlist->changeItemPart(first, foundlist->count()-1, 2);
  foundlist->changeItemPart(last, foundlist->count()-1, 3);
  foundlist->changeItemPart(email, foundlist->count()-1, 4);
  foundlist->changeItemPart(auth==1?"n":"y", foundlist->count()-1, 5);
}

void FindWindow::userFound(unsigned long uin, const char *nick, const char *first, const char *last, const char *email, char auth)
{
  ((MainWindow*)(kapp->topWidget()))->findWindow()->addUserLine(uin,nick,first,last,email,auth);
}

void FindWindow::searchDone()
{
  ((MainWindow*)(kapp->topWidget()))->findWindow()->stopCommand();
}

void FindWindow::addRequest()
{
  unsigned i;

  int addFlag = FALSE;
  unsigned long uin;
  ContactItem item;
  for(i=0; i<foundlist->count(); i++)
    if(foundlist->isMarked(i))
    {
      uin = foundlist->text(i, 0).toULong();
      if(!((MainWindow*)(kapp->topWidget()))->listWidget()->isUINInContactList(uin))
      {
        item.uin = uin;
        item.nick = foundlist->text(i, 1);
        item.firstName = foundlist->text(i, 2);
        item.lastName = foundlist->text(i, 3);
        item.email = foundlist->text(i, 4);
        item.auth = foundlist->text(i, 5)=="n"?1:0;
        ((MainWindow*)(kapp->topWidget()))->saveUser(item);
        addFlag = TRUE;
      }
    }
  if(addFlag)
    ((MainWindow*)(kapp->topWidget()))->updateContact();
}

void FindWindow::infoRequest()
{
  ContactItem item;
  unsigned i;
  for(i=0; i<foundlist->count(); i++)
    if(foundlist->isMarked(i))
    {
      item.uin = foundlist->text(i, 0).toULong();
      item.nick = foundlist->text(i, 1);
      item.firstName = foundlist->text(i, 2);
      item.lastName = foundlist->text(i, 3);
      item.email = foundlist->text(i, 4);
      ((MainWindow*)(kapp->topWidget()))->infoShow(item, FALSE);
    }
}

void FindWindow::popupRequest(int idx, int)
{
  if(!foundlist->isMarked(idx))
  {
    foundlist->unmarkAll();
    foundlist->markItem(idx);
  }
  popup->popup(QCursor::pos());
}

void FindWindow::changeTab(int tab)
{
  curtab = tab;
}
