/* $Id: kmytablistbox.cpp,v 1.2 1999/02/19 15:42:03 koss Exp $
   $Log: kmytablistbox.cpp,v $
   Revision 1.2  1999/02/19 15:42:03  koss
   Adjusted sizes for columns

   Revision 1.1.1.1  1999/02/10 18:16:34  koss
   Imported sources

   Revision 1.5  1999/02/07 20:03:44  matt
   renamed timed to scheduled

   Revision 1.4  1999/02/07 17:14:12  matt
   added some new icons

   Revision 1.3  1998/12/19 19:39:19  matt
   Added new icons

   Revision 1.1.1.1  1998/05/06 19:13:32  matt
   Imported sources


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   */
#include <kmsgbox.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kstring.h>
#include <kapp.h>

#include "kmytablistbox.h"

#define SIZE_PIXMAP           26
#define SIZE_LOCAL_FILENAME   160
#define SIZE_RESUME           40
#define SIZE_COUNT            60
#define SIZE_PROGRESS         30
#define SIZE_TOTAL            65
#define SIZE_SPEED            70
#define SIZE_REMAINING_TIME   70
#define SIZE_ADDRESS          450

QList<QPixmap> *KMyTabListBox::animConn;
QList<QPixmap> *KMyTabListBox::animTry;
QPixmap *KMyTabListBox::pixQueued;
QPixmap *KMyTabListBox::pixScheduled;
QPixmap *KMyTabListBox::pixDelayed;
QPixmap *KMyTabListBox::pixFinished;
QPixmap *KMyTabListBox::pixRetrying;


KMyTabListBox::KMyTabListBox (QWidget *parent, const char *name, 
			      int columns, WFlags f)
  : KTabListBox (parent, name, columns, f)
{
  setColumn(TB_PIXMAP, "S", SIZE_PIXMAP, PixmapColumn);
  setColumn(TB_RESUME, i18n("Res."), SIZE_RESUME);
  setColumn(TB_COUNT, i18n("Count"), SIZE_COUNT);
  setColumn(TB_PROGRESS, i18n("%"), SIZE_PROGRESS);
  setColumn(TB_TOTAL, i18n("Total"), SIZE_TOTAL);
  setColumn(TB_REMAINING_TIME, i18n("Rem. Time"), SIZE_REMAINING_TIME);
  setColumn(TB_SPEED, i18n("Speed"), SIZE_SPEED);
  setColumn(TB_LOCAL_FILENAME, i18n("Local Filename"), SIZE_LOCAL_FILENAME);
  setColumn(TB_URL, i18n("Address ( URL )"), SIZE_ADDRESS);

  readConfig();

   if ( columnWidth(0) == 60 ) {
    setColumnWidth( TB_PIXMAP, SIZE_PIXMAP );
    setColumnWidth( TB_RESUME, SIZE_RESUME );
    setColumnWidth( TB_COUNT, SIZE_COUNT );
    setColumnWidth( TB_PROGRESS, SIZE_PROGRESS );
    setColumnWidth( TB_TOTAL, SIZE_TOTAL );
    setColumnWidth( TB_REMAINING_TIME, SIZE_REMAINING_TIME );
    setColumnWidth( TB_SPEED, SIZE_SPEED );
    setColumnWidth( TB_LOCAL_FILENAME, SIZE_LOCAL_FILENAME );
    setColumnWidth( TB_URL, SIZE_ADDRESS );
  }

  QString path = KApplication::getKApplication()->kde_datadir() + "/kget/pics/";

  // Load animations
  if ( animConn->count() == 0 )
    {
      animConn->setAutoDelete( true );
      animTry->setAutoDelete( true );
      for ( int i = 0; i < 7; i++ )
	{
	  QString n1;

	  QPixmap *p1 = new QPixmap();
	  n1.sprintf( "/connect%i.xpm", i );
	  p1->load( path + n1 );
	  if ( p1->isNull() ) {
	    QString e;
	    e << i18n( "Could not load icon\n" ) << n1.data();
	    KMsgBox::message( this, i18n( "KGet Error" ), e.data(),
			      KMsgBox::EXCLAMATION );
	  }
	  animConn->append( p1 );
	  n1.sprintf( "connect%i", i );
	  dict().insert( n1, p1);

	  p1 = new QPixmap();
	  n1.sprintf( "/try%i.xpm", i );
	  p1->load( path + n1 );
	  if ( p1->isNull() ) {
	    QString e;
	    e << i18n( "Could not load icon\n" ) << n1.data();
	    KMsgBox::message( this, i18n( "KGet Error" ), e.data(),
			      KMsgBox::EXCLAMATION);
	  }
	  animTry->append( p1 );
	  n1.sprintf( "try%i", i );
	  dict().insert( n1, p1);
	}
    }

  pixQueued = new QPixmap();
  pixQueued->load(path + "md_queued.xpm");
  dict().insert("queued", pixQueued);

  pixScheduled = new QPixmap();
  pixScheduled->load(path + "md_scheduled.xpm");
  dict().insert("scheduled", pixScheduled);

  pixDelayed = new QPixmap();
  pixDelayed->load(path + "md_delayed.xpm");
  dict().insert("delayed", pixDelayed);

  pixFinished = new QPixmap();
  pixFinished->load(path + "md_finished.xpm");
  dict().insert("finished", pixFinished);

  pixRetrying = new QPixmap();
  pixRetrying->load(path + "retrying.xpm");
  dict().insert("retrying", pixRetrying);

  phasesNum = animConn->count();
}



KMyTabListBox::~KMyTabListBox()
{
  writeConfig();
}
