/* $Id: kgetoptdlg.h,v 1.1.1.1 1999/02/10 18:16:34 koss Exp $
   $Log: kgetoptdlg.h,v $
   Revision 1.1.1.1  1999/02/10 18:16:34  koss
   Imported sources

   Revision 1.3  1999/02/07 17:14:40  matt
   updated for new setting dialogs


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef _KGETOPTDLG_H
#define _KGETOPTDLG_H

#include <qdialog.h>
#include <qtabdialog.h>
#include <qpushbutton.h>

#include <ktabctl.h>

class DlgConnection;
class DlgProxy;
class DlgAutomation;
class DlgLimits;
class DlgAdvanced;
class DlgSystem;


class KGETOptDlg : public QDialog
{
  Q_OBJECT

public:

  KGETOptDlg(QWidget *parent=0, const char *name=0, WFlags f=0);
  ~KGETOptDlg();

  // methods to access data
  void setConnectionData(QStrList *strList);
  QStrList dataConnection() const;

  void setProxyData();
  void dataProxy();

  void setAutomationData(QStrList *strList);
  QStrList dataAutomation() const;

  void setLimitsData(QStrList *strList);
  QStrList dataLimits() const;
  
  void setSystemData(QStrList *strList);
  QStrList dataSystem() const;

  void setFontData(QFont font);
  QFont dataFont() const;

  void setAdvancedData(QStrList *strList);
  QStrList dataAdvanced() const;

private:

  QPushButton *help;
  QPushButton *ok;
  QPushButton *cancel;

  KTabCtl     *tabDlg;

  DlgConnection *conDlg;
  DlgProxy      *prxDlg;
  DlgAutomation *autDlg;
  DlgLimits     *limDlg;
  DlgAdvanced   *advDlg;
  DlgSystem     *sysDlg;

public slots:

  void helpShow();

};

#endif // _KGETOPTDLG_H
