/* $Id: dlgAutomation.cpp,v 1.1.1.1 1999/02/10 18:16:34 koss Exp $
   $Log: dlgAutomation.cpp,v $
   Revision 1.1.1.1  1999/02/10 18:16:34  koss
   Imported sources

   Revision 1.1  1999/02/07 17:11:28  matt
   source entered


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <qlayout.h>

#include <kapp.h>

#include "dlgAutomation.h"

extern QString getStringFromBool( bool x );
extern QString getStringFromInt( int x );
extern bool getBoolFromString( QString s );
extern int getIntFromString( QString s );

DlgAutomation::DlgAutomation(QWidget *parent, const char *name, WFlags f)
  : QWidget(parent, name, f)
{

  QGridLayout *topGridLayout = new QGridLayout(this, 8, 7, 5);

  topGridLayout->addRowSpacing(0,10);
  topGridLayout->addRowSpacing(5,10);
  topGridLayout->addRowSpacing(7,10);

  topGridLayout->addColSpacing(0,5);
  topGridLayout->addColSpacing(6,5);

  topGridLayout->setRowStretch(0,5);
  topGridLayout->setRowStretch(1,10);
  topGridLayout->setRowStretch(2,10);
  topGridLayout->setRowStretch(3,10);
  topGridLayout->setRowStretch(4,10);
  topGridLayout->setRowStretch(5,10);
  topGridLayout->setRowStretch(6,20);
  topGridLayout->setRowStretch(7,5);
    
  topGridLayout->setColStretch(0,2);
  topGridLayout->setColStretch(1,10);
  topGridLayout->setColStretch(2,10);
  topGridLayout->setColStretch(3,2);
  topGridLayout->setColStretch(4,5);
  topGridLayout->setColStretch(5,5);
  topGridLayout->setColStretch(6,2);

  // auto save
  cb_autoSave = new QCheckBox( i18n("Auto save file list every"), this );
  cb_autoSave->setMinimumSize( cb_autoSave->sizeHint() );
  topGridLayout->addMultiCellWidget( cb_autoSave, 1, 1, 1, 2 );

  le_autoSave = new KIntegerLine( this );
  le_autoSave->setFixedHeight( le_autoSave->sizeHint().height() );
  topGridLayout->addMultiCellWidget( le_autoSave, 1, 1, 3, 4 );

  lb_autoSave = new QLabel( i18n("minutes"), this );
  topGridLayout->addWidget( lb_autoSave, 1, 5 );

  connect( cb_autoSave, SIGNAL(toggled(bool)),le_autoSave, SLOT(setEnabled(bool)) );

  // auto disconnect
  cb_autoDisconnect = new QCheckBox( i18n("Auto disconnect after done downloading"),
				     this );
  cb_autoDisconnect->setMinimumSize( cb_autoDisconnect->sizeHint() );
  topGridLayout->addMultiCellWidget( cb_autoDisconnect, 2, 2, 1, 3 );

  lb_autoDisconnect = new QLabel(i18n("Disconnect command :"), this);
  topGridLayout->addMultiCellWidget( lb_autoDisconnect, 3, 3, 2, 3 );

  le_autoDisconnect = new QLineEdit(this);
  le_autoDisconnect->setFixedHeight( le_autoDisconnect->sizeHint().height() );
  topGridLayout->addMultiCellWidget( le_autoDisconnect, 3, 3, 4, 5 );

  connect( cb_autoDisconnect, SIGNAL(toggled(bool)),le_autoDisconnect, SLOT(setEnabled(bool)) );
  
  // auto shutdown
  cb_autoShutdown = new QCheckBox( i18n("Auto shutdown after done downloading"),
				   this );
  cb_autoShutdown->setMinimumSize( cb_autoShutdown->sizeHint() );
  topGridLayout->addMultiCellWidget( cb_autoShutdown, 4, 4, 1, 3 );
  
//   // netscape integration
//   gb_netscape = new QGroupBox( this, "gb_netscape" );
//   gb_netscape->setTitle( i18n("Netscape integration") );
//   topGridLayout->addMultiCellWidget( gb_netscape, 6, 6, 1, 5 );

//   QGridLayout *gLayout = new QGridLayout( gb_netscape, 3, 4 );

//   gLayout->addRowSpacing(0,10);
//   gLayout->addRowSpacing(2,10);

//   gLayout->addColSpacing(0,5);
//   gLayout->addColSpacing(3,5);

//   gLayout->setRowStretch(0,5);
//   gLayout->setRowStretch(1,10);
//   gLayout->setRowStretch(2,5);

//   gLayout->setColStretch(0,1);
//   gLayout->setColStretch(1,5);
//   gLayout->setColStretch(2,5);
//   gLayout->setColStretch(3,1);

//   cb_netscape = new QCheckBox( i18n("Integrate with Netscape clicks"), gb_netscape );
//   gLayout->addMultiCellWidget( cb_netscape, 1, 1, 1, 2 );

//   gLayout->activate();

  topGridLayout->activate();

}


DlgAutomation::~DlgAutomation()
{
}


void DlgAutomation::setData(QStrList *strList)
{
  // auto save
  bool autoSave = getBoolFromString( strList->first() );
  le_autoSave->setEnabled( autoSave );
  cb_autoSave->setChecked( autoSave );
  
  le_autoSave->setValue( getIntFromString( strList->next() ) );

  // auto disconnect
  bool autoDisconnect = getBoolFromString( strList->next() );
  le_autoDisconnect->setEnabled( autoDisconnect );
  cb_autoDisconnect->setChecked( autoDisconnect );

  le_autoDisconnect->setText( strList->next() );

  // auto shutdown
  cb_autoShutdown->setChecked( getBoolFromString( strList->next() ) );

//   // netscape integration
//     bool netscapeIntegrate = getBoolFromString( strList->next() );
//   cb_netscape->setChecked( netscapeIntegrate );

}


static QStrList strList(true);


QStrList DlgAutomation::getData() const
{
  strList.clear();
  QString tmp;
  
  // auto save
  strList.append( getStringFromBool( cb_autoSave->isChecked() ) );
  strList.append( getStringFromInt( le_autoSave->value() ) );
  strList.append( getStringFromBool( cb_autoDisconnect->isChecked() ) );
  strList.append( le_autoDisconnect->text() );
  strList.append( getStringFromBool( cb_autoShutdown->isChecked() ) );

//   // netscape integration
//   strList.append( getStringFromBool( cb_netscape->isChecked() ) );

  return strList;
}
