#include <stdlib.h>
#include <iostream.h>
#include <qlined.h>
#include <qfiledlg.h> 
#include <qfileinf.h> 
#include <qtooltip.h> 
#include "fileReader.h"
#include <qpushbt.h>
#include <qlabel.h>
#include <qframe.h>
#include <qlayout.h>
#include "ircDefine.h"
#include "tclSwitchPage.h"
#include "tclSwitchPage.moc"
#include "ircApp.h"

void TclSwitchPage::Init()
{
  checkBox.setAutoDelete(false);
  checkText.setAutoDelete(true);
}

TclSwitchPage::TclSwitchPage(IrcClient* client, QWidget *parent, const char *name ) : 
  QWidget( parent, name )
{
  Init();
  this->client=client;
  
  horLayout = new QHBoxLayout(this, 10);
  createCheckBox();
  createPushButton();
  horLayout->activate();
  readConfig();
  show();
}

TclSwitchPage::~TclSwitchPage()
{
#ifdef EDEBUG
  cout << "Destruktor TclSwitchPage" << endl;
#endif
}


void TclSwitchPage::createCheckBox()
{
  QString entry;
  QVBoxLayout*  verLayout = new QVBoxLayout(10);
  horLayout->addLayout(verLayout);
  QButtonGroup* bg = new QButtonGroup("Tcl Bind Switcher", this);

  verLayout->addWidget(bg);

  QVBoxLayout* vbox = new QVBoxLayout(bg, 10);
  vbox->addSpacing(bg->fontMetrics().height());
  QHBoxLayout* hbox = new QHBoxLayout(10);
  vbox->addLayout(hbox);

  QCheckBox* cb;
  checkText.append(entry=qstrdup("BIND_MSG"));
  checkBox.insert(entry, cb = new QCheckBox("Bind MSG", bg));
  cb->setFixedHeight(cb->sizeHint().height());
  hbox->addWidget(cb);

  checkText.append(entry=qstrdup("BIND_CHANMSG"));
  checkBox.insert(entry, cb = new QCheckBox("Bind CHANMSG", bg));
  cb->setFixedHeight(cb->sizeHint().height());
  hbox->addWidget(cb);


  hbox = new QHBoxLayout(10);
  vbox->addLayout(hbox);
  checkText.append(entry=qstrdup("BIND_PRIVMSG"));
  checkBox.insert(entry, cb = new QCheckBox("Bind PRIVMSG", bg));
  cb->setFixedHeight(cb->sizeHint().height());
  hbox->addWidget(cb);

  checkText.append(entry=qstrdup("BIND_DCC"));
  checkBox.insert(entry, cb = new QCheckBox("Bind DCC", bg));
  cb->setFixedHeight(cb->sizeHint().height());
  hbox->addWidget(cb);


  hbox = new QHBoxLayout(10);
  vbox->addLayout(hbox);
  checkText.append(entry=qstrdup("BIND_JOIN"));
  checkBox.insert(entry, cb = new QCheckBox("Bind JOIN", bg));
  cb->setFixedHeight(cb->sizeHint().height());
  hbox->addWidget(cb);

  checkText.append(entry=qstrdup("BIND_PART"));
  checkBox.insert(entry, cb = new QCheckBox("Bind PART", bg));
  cb->setFixedHeight(cb->sizeHint().height());
  hbox->addWidget(cb);


  hbox = new QHBoxLayout(10);
  vbox->addLayout(hbox);
  checkText.append(entry=qstrdup("BIND_TOPIC"));
  checkBox.insert(entry, cb = new QCheckBox("Bind TOPIC", bg));
  cb->setFixedHeight(cb->sizeHint().height());
  hbox->addWidget(cb);

  checkText.append(entry=qstrdup("BIND_KICK"));
  checkBox.insert(entry, cb = new QCheckBox("Bind KICK", bg));
  cb->setFixedHeight(cb->sizeHint().height());
  hbox->addWidget(cb);

  hbox = new QHBoxLayout(10);
  vbox->addLayout(hbox);
  checkText.append(entry=qstrdup("BIND_NICK"));
  checkBox.insert(entry, cb = new QCheckBox("Bind NICK", bg));
  cb->setFixedHeight(cb->sizeHint().height());
  hbox->addWidget(cb);

  checkText.append(entry=qstrdup("BIND_MODE"));
  checkBox.insert(entry, cb = new QCheckBox("Bind MODE", bg));
  cb->setFixedHeight(cb->sizeHint().height());
  hbox->addWidget(cb);


  hbox = new QHBoxLayout(10);
  vbox->addLayout(hbox);
  checkText.append(entry=qstrdup("BIND_CTCP"));
  checkBox.insert(entry, cb = new QCheckBox("Bind CTCP", bg));
  cb->setFixedHeight(cb->sizeHint().height());
  hbox->addWidget(cb);

  checkText.append(entry=qstrdup("BIND_CTCR"));
  checkBox.insert(entry, cb = new QCheckBox("Bind CTCR", bg));
  cb->setFixedHeight(cb->sizeHint().height());
  hbox->addWidget(cb);

  hbox = new QHBoxLayout(10);
  vbox->addLayout(hbox);
  checkText.append(entry=qstrdup("BIND_FLOOD"));
  checkBox.insert(entry, cb = new QCheckBox("Bind FLOOD", bg));
  cb->setFixedHeight(cb->sizeHint().height());
  hbox->addWidget(cb);

  vbox->addSpacing(10);
  vbox->activate();

  checkText.append(entry=qstrdup("CMD_TIMER"));
  checkBox.insert(entry, cb = new QCheckBox("TIMER activate", this));
  cb->setFixedHeight(cb->sizeHint().height());
  verLayout->addWidget(cb);
  verLayout->addStretch(10);
}

void TclSwitchPage::createPushButton()
{
  horLayout->addSpacing(10);
  QPushButton* btn;
  btn = new QPushButton(" Apply ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotApply()));
  horLayout->addWidget(btn, 0, AlignLeft|AlignTop);
  btn->setFixedSize(80, 30);
}

void TclSwitchPage::readConfig()
{
  QString check;
  QString entry;
  QString value;
  for (entry=checkText.first();entry;entry=checkText.next()){
      value = ircapp->readEntry(entry, "Yes");
      if (value=="Yes")
	 checkBox[entry]->setChecked(1);
      ircapp->writeEntry(entry, value);
  }
}

void TclSwitchPage::slotApply()
{
#ifdef EDEBUG
  cout << "TclSwitchPage::slotApply:"<<endl;
#endif
  QString entry;
  QString value;
  QCheckBox* cb;

  for (entry=checkText.first();entry;entry=checkText.next()){
      cb=checkBox[entry];
      if (!cb)
	 continue;
      if (cb->isChecked())
	 value="Yes";
      else
	 value="No";
      ircapp->writeEntry(entry, value);
  }
}

