#ifndef __TCLCMD_H__
#define __TCLCMD_H__

#define STR_CONVERT(str) ((const char*)str)

#define STATUS_ACTIVE    1
#define STATUS_DEACTIVE  0

#include <tcl.h>
#include <qobject.h>
#include <qstring.h>
#include <qstrlist.h>
#include "kprocess.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
  int     status;
  long    numFlag;
  QString strFlag;
  QString funcName;
} TCL_FUNC_ITEM;

typedef struct {
  int     status;
  QString flag;   // out:in:err
  QString funcName;
  KProcess process;
} TCL_PROCESS_ITEM;

#ifdef __cplusplus
}
#endif

#define CMD_ITEM      QList<TCL_FUNC_ITEM>
#define IT_CMD_ITEM   QDictIterator<TCL_FUNC_ITEM >
#define BIND_ITEM     QDict<CMD_ITEM >
#define IT_BIND_ITEM  QDictIterator<CMD_ITEM >

class IrcClient;

class TclCmd : public QObject
{
  Q_OBJECT
protected:
  IrcClient*  client;
  Tcl_Interp* interp;
  QDict<BIND_ITEM >*  bindTable; 
  QDict<CMD_ITEM >*   timerTable;
  long timerHandle;
  QList<TCL_PROCESS_ITEM>* processTable;
public:
  // Konstructor
  TclCmd(IrcClient* Client, const char* Name=0);
  ~TclCmd();
protected:
  void initTclBindTable();
  void initTclCmd();
protected slots:
  void slotProcessExit (KProcess *);
  void slotProcessError(KProcess *, char *, int);
  void slotProcessInput(KProcess *);
  void slotProcessOutput(KProcess *, char *, int);
public:
  int  cmdBind  (char* typ, char* cmd, char* proc);
  int  cmdUnbind(char* typ, char* cmd, char* proc);
  long cmdAddTimer(char* flag, char* second, char* proc);
  int  cmdDelTimer(char* handle);
  int  cmdDelTimer(char* flag, char* second, char* proc);
  long cmdAddExec(char* prog, char* flag, char* proc);
  int  cmdDelExec(char* handle);
  int  cmdSetOpt(char* var, char* val,   char* defVal=0L);
  int  cmdGetOpt(char* var, char* defVal="");
  Tcl_Interp* getInterp(){return interp;}
  QDict<BIND_ITEM>* getBindTable(){
    return bindTable;
  }
  inline BIND_ITEM* getBindItem(const char* s){
    return getBindTable()->find(s);
  }
  int getBindProc(const char* typ, const char* cmd, QStrList& funcName);
  int evalCmd   (QStrList&   funcName, const char* argv);
  int evalCmd   (const char* funcName, const char* argv);
  int evalCmd   (QStrList&   funcName, const char* argv, QString& Result);
  int evalCmd   (const char* funcName, const char* argv, QString& Result);
  int evalFile  (const char* file);
  void checkTimerTable();

  // variable fuer Einstellung initialisieren
  void setStartConfig();
  void setOnPrivMsg();
  void setOnInvite();
  void setOnKick();
  void setOnDCCChat();
  void setOnDCCFile();
  void setOnCTCPSound();
};

#endif








