#include <iostream.h>
#include <qregexp.h>
#include <qfile.h>
#include "kprocess.h"
#include <qmsgbox.h> 
#include "kmsgbox.h"
#include "ircClient.h"
#include "tclCmd.h"
#include "tclCmd.moc"
#include "cmd.h"
#include "StringToken.h"
#include "ircApp.h"

TclCmd::TclCmd(IrcClient* Client, const char*)
{
  client = Client;
  interp = Tcl_CreateInterp();
  Tcl_Init(interp);
  initTclCmd();
  initTclBindTable();

  timerHandle = 0;
  timerTable = new QDict<CMD_ITEM >(20, FALSE, TRUE);
  timerTable->setAutoDelete(true);

  processTable = new QList<TCL_PROCESS_ITEM>;
  processTable->setAutoDelete(true);
}

TclCmd::~TclCmd()
{
#ifdef EDEBUG
  cout << "TclCmd Destruktor"<<endl;
#endif
  delete bindTable;
  delete timerTable;
  delete processTable;
  Tcl_DeleteInterp(interp);
#ifdef EDEBUG
  cout << "TclCmd Destruktor...Ok"<<endl;
#endif
}

void TclCmd::initTclCmd()
{
#ifdef EDEBUG
  cout << "TclCmd::initTclCmd()"<<endl;
#endif
  Tcl_CreateCommand(interp, "sleep",     tcl_sleep,   (ClientData)client, 0L);

  Tcl_CreateCommand(interp, "nick",      tcl_nick,  (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "server",    tcl_server,(ClientData)client, 0L);
  Tcl_CreateCommand(interp, "userinfo",  tcl_userinfo,  (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "userhost",  tcl_userhost,  (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "userserver",tcl_userserver,(ClientData)client, 0L);

  Tcl_CreateCommand(interp, "userlist",  tcl_userlist,  (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "chanlist",  tcl_chanlist,  (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "haveop",    tcl_haveop,    (ClientData)client, 0L);

  Tcl_CreateCommand(interp, "sendraw",    tcl_sendraw,    (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "sendserver", tcl_sendserver, (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "sendchannel",tcl_sendchannel,(ClientData)client, 0L);
  Tcl_CreateCommand(interp, "sendmsg",    tcl_sendmsg,    (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "sendnotice", tcl_sendnotice, (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "sendctcp",   tcl_sendctcp,   (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "sendctcpreply", tcl_sendctcpreply, (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "sendmode",   tcl_sendmode,   (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "sendcmd",    tcl_sendcmd ,   (ClientData)client, 0L);

  Tcl_CreateCommand(interp, "addchanban", tcl_addchanban ,(ClientData)client, 0L);

  Tcl_CreateCommand(interp, "writewnd",   tcl_writewnd,   (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "writeactive",tcl_writeactive,(ClientData)client, 0L);
  Tcl_CreateCommand(interp, "writepage",  tcl_writepage,  (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "addpage",    tcl_addpage,    (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "delpage",    tcl_delpage,    (ClientData)client, 0L);
  
  Tcl_CreateCommand(interp, "addban",     tcl_addban,     (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "delban",     tcl_delban,     (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "addfriend",  tcl_addfriend,  (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "delfriend",  tcl_delfriend,  (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "addignore",  tcl_addignore,  (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "delignore",  tcl_delignore,  (ClientData)client, 0L);

  // Proxy list
  Tcl_CreateCommand(interp, "addproxy",   tcl_addproxy,   (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "delproxy",   tcl_delproxy,   (ClientData)client, 0L);

  Tcl_CreateCommand(interp, "friendlevel",   tcl_friendlevel,  (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "banlevel",      tcl_banlevel,     (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "isignore",      tcl_isignore,     (ClientData)client, 0L);

  Tcl_CreateCommand(interp, "bind",     tcl_bind,     (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "unbind",   tcl_unbind,   (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "setopt",   tcl_setopt,   (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "getopt",   tcl_getopt,   (ClientData)client, 0L);

  Tcl_CreateCommand(interp, "addtimer", tcl_addtimer,   (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "deltimer", tcl_deltimer,   (ClientData)client, 0L);

  Tcl_CreateCommand(interp, "kexec",    tcl_kexec,      (ClientData)client, 0L);
  Tcl_CreateCommand(interp, "kkill",    tcl_kkill,      (ClientData)client, 0L);
}

void  TclCmd::initTclBindTable()
{
  bindTable = new QDict<BIND_ITEM>(20, FALSE, TRUE);
  bindTable->setAutoDelete(TRUE);

  BIND_ITEM* bindItem;

  bindTable->insert("MSG",       bindItem=new BIND_ITEM(20, FALSE, TRUE));
  bindItem->setAutoDelete(TRUE);

  bindTable->insert("MSG",       bindItem=new BIND_ITEM(20, FALSE, TRUE));
  bindItem->setAutoDelete(TRUE);
  bindTable->insert("CHANMSG",   bindItem=new BIND_ITEM(20, FALSE, TRUE));
  bindItem->setAutoDelete(TRUE);
  bindTable->insert("PRIVMSG",   bindItem=new BIND_ITEM(20, FALSE, TRUE));
  bindItem->setAutoDelete(TRUE); 

  bindTable->insert("JOIN",  bindItem=new BIND_ITEM(20, FALSE, TRUE));
  bindItem->setAutoDelete(TRUE);
  bindTable->insert("PART",  bindItem=new BIND_ITEM(20, FALSE, TRUE));
  bindItem->setAutoDelete(TRUE);
  bindTable->insert("TOPIC", bindItem=new BIND_ITEM(20, FALSE, TRUE));
  bindItem->setAutoDelete(TRUE);
  bindTable->insert("KICK",  bindItem=new BIND_ITEM(20, FALSE, TRUE));
  bindItem->setAutoDelete(TRUE);

  bindTable->insert("MODE",  bindItem=new BIND_ITEM(20, FALSE, TRUE));
  bindItem->setAutoDelete(TRUE);
  bindTable->insert("NICK",  bindItem=new BIND_ITEM(20, FALSE, TRUE));
  bindItem->setAutoDelete(TRUE);

  bindTable->insert("CTCP",  bindItem=new BIND_ITEM(20, FALSE, TRUE));
  bindItem->setAutoDelete(TRUE);
  bindTable->insert("CTCR",  bindItem=new BIND_ITEM(20, FALSE, TRUE));
  bindItem->setAutoDelete(TRUE);
  bindTable->insert("DCC",   bindItem=new BIND_ITEM(20, FALSE, TRUE));
  bindItem->setAutoDelete(TRUE);

  bindTable->insert("FLOOD", bindItem=new BIND_ITEM(20, FALSE, TRUE));
  bindItem->setAutoDelete(TRUE);
}

int TclCmd::getBindProc (const char* typ, 
			 const char* cmd, 
			 QStrList& funcName)
{
#ifdef EDEBUG
  cout << "TclCmd::getBindProc():"<<typ<<":"<<cmd<<endl;
#endif
  int count=0;
  if (!typ || !cmd || strlen(cmd)<1)
     return count;

  BIND_ITEM* bindItem = bindTable->find(typ);
  if (bindItem==0L)
     return count;
  funcName.clear();
  IT_BIND_ITEM  bindIt(*bindItem);
  CMD_ITEM* cmdItem;
  for (cmdItem=bindIt.current();(cmdItem=bindIt.current())!=0L;++bindIt){
     int idx, len;
     QString key = bindIt.currentKey();
     QRegExp re(key, FALSE, TRUE);
     idx=re.match(cmd, 0, &len);
     if (len==(int)strlen(cmd)){
        TCL_FUNC_ITEM* funcItem;
	for (funcItem=cmdItem->first();(funcItem=cmdItem->current())!=0L;funcItem=cmdItem->next()){
	  if (funcItem->status==STATUS_ACTIVE){
	     funcName.append(funcItem->funcName);
	     count++;
	  }
	}
     }
  }
  return count;
}

int TclCmd::evalCmd(QStrList& funcName, const char* argv, QString& Result)
{
#ifdef EDEBUG
  cout << "TclCmd::evalCmd:"<<endl;
#endif
  QString cmd;
  for (cmd=funcName.first();cmd=funcName.current();cmd=funcName.next()){
      QString s = cmd+" "+QString(argv); 
      Tcl_Eval(getInterp(), s.data());
      Result = getInterp()->result;
  }
  return 1;
}

int TclCmd::evalCmd(const char* funcName, const char* argv, QString& Result)
{
#ifdef EDEBUG
  cout << "TclCmd::evalCmd():"<<funcName<<endl;
#endif
  QString s = QString(funcName)+" "+QString(argv); 
  Tcl_Eval(getInterp(), s.data());
  Result = getInterp()->result;
  return 1;
}

int TclCmd::evalCmd(QStrList& funcName, const char* argv)
{
  QString s;
  return evalCmd(funcName, argv, s);
}

int TclCmd::evalCmd(const char* funcName, const char* argv)
{
  QString s;
  return evalCmd(funcName, argv, s);
}

int TclCmd::evalFile(const char* file)
{
#ifdef EDEBUG
  cout << "TclCmd::evalFile:"<<file<<endl;
#endif
  if (QFile::exists(file)==false){
     KMsgBox::message(0L, "TCL EvalFile Dialog", "File "+QString(file)+" not exist" , 
		      KMsgBox::INFORMATION, "OK");
     
     return -1;
  }

  int eval=Tcl_EvalFile(getInterp(), (char*)file);
  if (eval!=0){
     KMsgBox::message(0L, "TCL EvalFile Dialog", "Error on loading "+QString(file) , 
		      KMsgBox::INFORMATION, "OK");
     return -1;
  }

  QMessageBox msg("TCL Load Dialog", "Succeed on loading "+QString(file), QMessageBox::Information, 
		  QMessageBox::Ok | QMessageBox::Default, 0, 0,
		  0L, 0L, false); 

  msg.show();
  client->Sleep(2);
  return 1;
}

// add command 
int TclCmd::cmdBind(char* typ, char* cmd, char* proc)
{
#ifdef EDEBUG
  cout << "TclCmd::cmdBind():"<<typ<<":"<<":"<<cmd<<":"<<proc<<endl;
#endif
  QString qtyp   = typ;
  QString qcmd   = cmd;
  qcmd = qcmd.stripWhiteSpace();
  QString qproc  = proc;

  BIND_ITEM* bindItem = bindTable->find(qtyp);
  CMD_ITEM*  cmdItem;
  if (bindItem==0L)
     return -1;
  cmdItem = bindItem->find(qcmd);

  TCL_FUNC_ITEM* funcItem;
  if (cmdItem==0L){
     bindItem->insert(qcmd, cmdItem = new CMD_ITEM);
     cmdItem->setAutoDelete(true);
  }

  for (funcItem=cmdItem->first();funcItem!=0L;funcItem=cmdItem->next()){
    if (strcmp(funcItem->funcName, qproc)==0)
       return 1;
  }

  funcItem = new TCL_FUNC_ITEM;
  cmdItem->append(funcItem);
  funcItem->funcName = qproc;
  funcItem->status   = STATUS_ACTIVE;

  return 1;
}
 

// remove command 
int TclCmd::cmdUnbind(char* typ, char* cmd, char* proc)
{
#ifdef EDEBUG
  cout << "TclCmd::cmdUnbind():"<<typ<<":"<<cmd<<":"<<proc<<endl;
#endif
  QString qtyp   = typ;
  QString qcmd   = cmd;
  QString qproc  = proc;

  BIND_ITEM* bindItem = bindTable->find(qtyp);
  if (bindItem==0L)
     return -1;
  IT_BIND_ITEM bindIt(*bindItem);
  CMD_ITEM* cmdItem;
  for (cmdItem=bindIt.current();(cmdItem=bindIt.current())!=0L;++bindIt){
     int idx, len;
     QString key = bindIt.currentKey();
     QRegExp re(qcmd, FALSE, TRUE);
     idx=re.match(key, 0, &len);
     if (len==(int)key.length()){
        TCL_FUNC_ITEM* funcItem;
	for (funcItem=cmdItem->first();(funcItem=cmdItem->current())!=0L;){
	    int idx, len;
	    QRegExp re(qproc, TRUE, TRUE);
	    idx=re.match(funcItem->funcName, 0, &len);
	    if (len==(int)strlen(funcItem->funcName))
	       cmdItem->remove();
	    else
	       funcItem=cmdItem->next();
	}
	// cmdItem will not be deleted
     }
  }
#ifdef EDEBUG
  cout << "TclCmd::cmdUnbind()...Ok"<<endl;
#endif
  return 1;
}

long TclCmd::cmdAddTimer(char* flag, char* second, char* proc)
{
#ifdef EDEBUG
  cout << "TclCmd::cmdAddTimer():"<<flag<<":"<<second<<":"<<proc<<endl;
#endif
  QString entry="CMD_TIMER";
  QString value=ircapp->readEntry(entry, "Yes");
  if (value=="Yes")
     ircapp->writeEntry(entry, "No");

  QString qflag   = flag;
  QString qsecond = second;
  QString qproc   = proc;

  bool ok;
  long tmp = qsecond.toLong(&ok);
  if (tmp<1 || ok==false){
    if (value=="Yes")
       ircapp->writeEntry(entry, "No");
    return -1;
  }
  

  CMD_ITEM*  cmdItem;
  cmdItem = timerTable->find(qsecond);

  TCL_FUNC_ITEM* funcItem;
  if (cmdItem==0L){
     timerTable->insert(qsecond, cmdItem = new CMD_ITEM);
     cmdItem->setAutoDelete(true);
  }

  for (funcItem=cmdItem->first();funcItem!=0L;funcItem=cmdItem->next()){
    if (strcmp (funcItem->funcName, qproc)==0 && 
	stricmp(funcItem->strFlag,  qflag)==0 )
      {
	if (value=="Yes")
	   ircapp->writeEntry(entry, "No");
	return funcItem->numFlag;
      }
  }

  funcItem = new TCL_FUNC_ITEM;
  cmdItem->append(funcItem);
  funcItem->funcName = qproc;
  funcItem->numFlag  = ++timerHandle;
  funcItem->strFlag  = qflag;
  funcItem->status   = STATUS_ACTIVE;
  if (value=="Yes")
     ircapp->writeEntry(entry, "Yes");
  return timerHandle;
}

int TclCmd::cmdDelTimer(char* handle)
{
  CMD_ITEM*  cmdItem;
  TCL_FUNC_ITEM* funcItem;
  long l=atol(handle);
  QDictIterator<CMD_ITEM > it(*timerTable);
  for (cmdItem=it.current();(cmdItem=it.current())!=0L;++it){
      for (funcItem=cmdItem->first();funcItem!=0L;funcItem=cmdItem->next()){
	  if (funcItem->numFlag==l){
	      cmdItem->remove();
	      return 1;
	  }
      }
  }
  return -1;
}

int TclCmd::cmdDelTimer(char* flag, char* second, char* proc)
{
  CMD_ITEM*  cmdItem;
  
  QString qflag  = flag;
  QString qcmd   = second;
  QString qproc  = proc;

  QDictIterator<CMD_ITEM > it(*timerTable);
  for (cmdItem=it.current();(cmdItem=it.current())!=0L;++it){
     int idx, len;
     QString key = it.currentKey();
     QRegExp re(qcmd, FALSE, TRUE);
     idx=re.match(key, 0, &len);
     if (len==(int)key.length()){
        TCL_FUNC_ITEM* funcItem;
	for (funcItem=cmdItem->first();(funcItem=cmdItem->current())!=0L;){
	    if (stricmp(funcItem->strFlag, qflag)){
	       funcItem=cmdItem->next();
	       continue;
	    }
	    int idx, len;
	    QRegExp re(qproc, TRUE, TRUE);
	    idx=re.match(funcItem->funcName, 0, &len);
	    if (len==(int)strlen(funcItem->funcName))
	       cmdItem->remove();
	    else
	       funcItem=cmdItem->next();
	}
	// cmdItem will not be deleted
     }
  }
  
  return 1;
}

long TclCmd::cmdAddExec(char* prog, char* flag, char* proc)
{
  StringToken st(prog);
#ifdef EDEBUG
  cout << "TclCmd::cmdAddExec():"<<prog<<":"<<flag<<":"<<proc<<endl;
#endif
  QString qflag   = flag;
  QString qproc   = proc;

  TCL_PROCESS_ITEM*  procItem;
  processTable->append(procItem = new TCL_PROCESS_ITEM);
  procItem->status   = STATUS_ACTIVE;
  procItem->funcName = qproc;
  procItem->flag     = qflag;

  while (st.hasMoreTokens())
     procItem->process << st.nextToken();

  QObject::connect(&procItem->process, SIGNAL(processExited(KProcess *)),
		   this,               SLOT  (slotProcessExit(KProcess *)));

  if (!qflag.isEmpty() && !qproc.isEmpty()){
     if (qflag.contains("out", false)>0)
        QObject::connect(&procItem->process, SIGNAL(receivedStdout(KProcess *, char *, int)),
			 this,               SLOT  (slotProcessOutput(KProcess *, char *, int)));
     if (qflag.contains("err", false)>0)
        QObject::connect(&procItem->process, SIGNAL(receivedStderr(KProcess *, char *, int)),
			 this,               SLOT  (slotProcessError(KProcess *, char *, int)));
     if (qflag.contains("in", false)>0)
        QObject::connect(&procItem->process, SIGNAL(wroteStdin(KProcess *)),
			 this,               SLOT  (slotProcessInput(KProcess *)));
  }

  procItem->process.start(KProcess::NotifyOnExit, KProcess::All);
  return (long)procItem->process.getPid();
}

int TclCmd::cmdDelExec(char* handle)
{
  TCL_PROCESS_ITEM* procItem;
  long l=atol(handle);
  if (l<1)
     return 1;
  for (procItem=processTable->first();procItem!=0L;procItem=processTable->next()){
    if (procItem->process.isRunning() && (long)procItem->process.getPid()==l){
       procItem->process.kill();
       processTable->remove();
       procItem=0L;
    }
  }
  return 1;
}

// change option
int TclCmd::cmdSetOpt(char* var, char* val, char* defValue)
{
#ifdef EDEBUG
  cout << "TclCmd::cmdSetOpt():"<<var<<":"<<val<<endl;
#endif
  QString entry=var;
  QString value;
  if (defValue)
     value=ircapp->readEntry(entry, QString(defValue));
  else
     value=val;
  ircapp->writeEntry(entry, value);
  Tcl_SetVar(interp, entry.data(), value.data(), TCL_GLOBAL_ONLY);
#ifdef EDEBUG
  cout << "TclCmd::cmdSetOpt()...Ok"<<endl;
#endif
  return 1;
}
 
// get option
int TclCmd::cmdGetOpt(char* var, char* defValue)
{
#ifdef EDEBUG
  cout << "TclCmd::cmdGetOpt():"<<var<<":"<<defValue<<endl;
#endif
  QString entry=var;
  QString value;
  value=ircapp->readEntry(entry, QString(defValue));

  Tcl_SetResult(interp, value.data(), TCL_VOLATILE);
  return 1;
}

void TclCmd::setStartConfig()
{
  QString entry;
  
  entry = "AutoConnect";
  cmdSetOpt(entry.data(), 0L, "No");

  entry = "AutoChangeNick";
  cmdSetOpt(entry.data(), 0L, "No");

  entry = "AutoReconnect";
  cmdSetOpt(entry.data(), 0L, "No");

  entry = "StartActionDelay";
  cmdSetOpt(entry.data(), 0L, "1");
  entry = "ReconnectionDelay";
  cmdSetOpt(entry.data(), 0L, "1");
  entry = "IsonDelay";
  cmdSetOpt(entry.data(), 0L, "1");
}


void TclCmd::setOnPrivMsg()
{
  QString entry;
  
  entry = "OnPrivMsg";
  cmdSetOpt(entry.data(), 0L, "AutoAccept");

  entry = "PrivMsgClientMax";
  cmdSetOpt(entry.data(), 0L, "5");

  // max window
  entry = "PrivMsgDlgMax";
  cmdSetOpt(entry.data(), 0L, "5");

  // timeout
  entry = "PrivMsgDlgTimeout";
  cmdSetOpt(entry.data(), 0L, "30");
}

void TclCmd::setOnInvite()
{
  QString entry;
  
  entry = "OnChannelInvite";
  cmdSetOpt(entry.data(), 0L, "Dialog");

  // max window
  entry = "InvDlgMax";
  cmdSetOpt(entry.data(), 0L, "5");

  // timeout
  entry = "InvDlgTimeout";
  cmdSetOpt(entry.data(), 0L, "30");
}

void TclCmd::setOnKick()
{
  QString entry;
  
  entry = "OnChannelKick";
  cmdSetOpt(entry.data(), 0L, "Quiet");

  // timeout
  entry = "KickDlgTimeout";
  cmdSetOpt(entry.data(), 0L, "30");
}

void TclCmd::setOnDCCChat()
{
  QString entry;
  
  entry = "OnDCCChat";
  cmdSetOpt(entry.data(), 0L, "AutoAccept");

  entry = "DCCChatClientMax";
  cmdSetOpt(entry.data(), 0L, "5");

  // max window
  entry = "DCCChatDlgMax";
  cmdSetOpt(entry.data(), 0L, "5");

  // timeout
  entry = "DCCChatDlgTimeout";
  cmdSetOpt(entry.data(), 0L, "30");
  entry = "DCCChatTimeout";
  cmdSetOpt(entry.data(), 0L, "120");
}

void TclCmd::setOnDCCFile()
{
  QString entry;
  
  entry = "OnDCCFile";
  cmdSetOpt(entry.data(), 0L, "AutoAccept");

  entry = "DCCFileClientMax";
  cmdSetOpt(entry.data(), 0L, "5");

  // max window
  entry = "DCCFileDlgMax";
  cmdSetOpt(entry.data(), 0L, "5");

  // timeout
  entry = "DCCFileDlgTimeout";
  cmdSetOpt(entry.data(), 0L, "30");
  entry = "DCCSendTimeout";
  cmdSetOpt(entry.data(), 0L, "120");

  // On Finished
  entry = "OnFinishedBeep";
  cmdSetOpt(entry.data(), 0L, "No");
  entry = "OnFinishedCloseWindow";
  cmdSetOpt(entry.data(), 0L, "No");

  entry = "DCCSendBlock";
  cmdSetOpt(entry.data(), 0L, "1024");
  entry = "DCCFileDir";
  cmdSetOpt(entry.data(), 0L, ircapp->home.data());
}

void TclCmd::setOnCTCPSound()
{
  QString entry;
  
  entry = "OnCTCPSound";
  cmdSetOpt(entry.data(), 0L, "AutoAccept");

  entry = "OnCTCPSoundOnPlay";
  cmdSetOpt(entry.data(), 0L, "Dontplay");

  entry = "CTCPSoundDir";
  cmdSetOpt(entry.data(), 0L, ircapp->home.data());
}

void TclCmd::checkTimerTable()
{
  CMD_ITEM*  cmdItem;
  TCL_FUNC_ITEM* funcItem;
  QDictIterator<CMD_ITEM > it(*timerTable);
  for (cmdItem=it.current();(cmdItem=it.current())!=0L;++it){
      for (funcItem=cmdItem->first();funcItem!=0L;){
	  if (funcItem->status!=STATUS_ACTIVE){
	     funcItem=cmdItem->next();
	     continue;
	  }
	  if (funcItem->numFlag>1){
	     funcItem->numFlag--;
	     funcItem=cmdItem->next();
	     continue;
	  }
	  else{
	     if (funcItem->strFlag=="-"){
	        evalCmd(funcItem->funcName, "");
		cmdItem->remove();
	     }
	     else{
	        evalCmd(funcItem->funcName, "");
		funcItem->numFlag=atol(it.currentKey());
		funcItem=cmdItem->next();
	     }
	  }
      }
  }
}

void TclCmd::slotProcessExit(KProcess* p)
{
#ifdef EDEBUG
  cout << "TclCmd::slotProcessExit()"<<endl;
#endif
  long handle = p->getPid();
  TCL_PROCESS_ITEM* procItem;
  QString funcName;
  QString flag="";
  for (procItem=processTable->first();procItem!=0L;procItem=processTable->next()){
    if ((long)procItem->process.getPid()==handle){
       funcName = procItem->funcName;
       flag     = procItem->flag;
       processTable->remove();
       procItem=0L;
    }
  }
  if (!funcName.isEmpty() && flag.contains("exit", false)>0){
     // proc flag 
     QString argv = "exit";
     evalCmd(funcName, argv);
  }
}

void TclCmd::slotProcessOutput(KProcess* p, char* buf, int len)
{
#ifdef EDEBUG
  cout << "TclCmd::slotProcessOutput()"<<endl;
#endif

  QString qbuf(buf, len+1);
  long handle = (long)p->getPid();
  TCL_PROCESS_ITEM* procItem;
  for (procItem=processTable->first();procItem!=0L;procItem=processTable->next()){
    if ((long)procItem->process.getPid()==handle){
       // proc flag text 
       QString argv = "out {"+qbuf+"}";
       evalCmd(procItem->funcName, argv);
       procItem=0L;
    }
  }
}

void TclCmd::slotProcessError(KProcess* p, char* buf, int len)
{
#ifdef EDEBUG
  cout << "TclCmd::slotProcessError()"<<endl;
#endif

  QString qbuf(buf, len+1);
  long handle = (long)p->getPid();
  TCL_PROCESS_ITEM* procItem;
  for (procItem=processTable->first();procItem!=0L;procItem=processTable->next()){
    if (procItem->process.isRunning() && (long)procItem->process.getPid()==handle){
       // proc flag text 
       QString argv = "err {"+qbuf+"}";
       evalCmd(procItem->funcName, argv);
       procItem=0L;
    }
  }
}

void TclCmd::slotProcessInput(KProcess* p)
{
  long handle = (long)p->getPid();
  TCL_PROCESS_ITEM* procItem;
  for (procItem=processTable->first();procItem!=0L;procItem=processTable->next()){
    if (procItem->process.isRunning() && (long)procItem->process.getPid()==handle){
       // proc flag text 
       QString argv = "in";
       evalCmd(procItem->funcName, argv);
       procItem=0L;
    }
  }
}




