#ifndef __ONTCLPAGE_H__
#define __ONTCLPAGE_H__

#include <qwidget.h>
#include <qbttngrp.h> 
#include <qgrpbox.h>
#include <qmlined.h>
#include <qlined.h>
#include <qlayout.h> 
#include <qchkbox.h> 
#include <qdict.h>
#include <qstrlist.h>
#include <qlabel.h>
#include <qradiobt.h> 
#include "kintegerline.h"
#include "ktablistbox.h"
#include "fileListBox.h"

#include "ircClient.h"
#include <kconfig.h>

class OnTclPage : public QWidget
{
  Q_OBJECT
protected:
  IrcClient*   client;
  KTabListBox* listBox;

  QHBoxLayout* horLayout;
  QVBoxLayout* lVerLayout;
  QVBoxLayout* rVerLayout;

  QString dir;
  FileDirBox* dirBox;
  QLineEdit*  editBox;
public:
  OnTclPage(IrcClient* Client, QWidget *parent = NULL, const char *name = NULL );
  ~OnTclPage();
  void loadTcl(const char* file);
protected:
  void    edit(const char* file);
  void    readConfig();
  void    createButton();
  void    createListBox();
  int     checkItem(QString s, int*);
protected slots:
  void slotLoadNew();
  void slotLoadIt();
  void slotEditNew();
  void slotEditIt();
  void slotDelete();
  void slotApply();
};

#endif




