#include "userMode.h"

UserMode::UserMode():
  IrcMode()
{
  codeMode.setAutoDelete(true);
}

UserMode::~UserMode()
{
}

QString UserMode::addMode(const char* Mode)
{
  QString nm=IrcMode::addMode(Mode);
  if (nm.contains('o', false))
     codeMode.inSort("@");
  if (nm.contains('v', false))
     codeMode.inSort("+");
  return nm;
}

QString UserMode::delMode(const char* Mode)
{
  QString nm=IrcMode::delMode(Mode);
  if (nm.contains('o', false))
     codeMode.remove("@");
  if (nm.contains('v', false))
     codeMode.remove("+");
  return nm;
}

QString UserMode::code()
{
  QString cs="";
  for (codeMode.first();codeMode.current();codeMode.next())
      cs += codeMode.current();
  return cs;
}

bool UserMode::haveOp()
{
   return mMode.contains('o', false)?true:false;
}

bool UserMode::haveVoice()
{
  return mMode.contains('v', false)?true:false;
}




