#include <stdlib.h>
#include <iostream.h>
#include <qlined.h>
#include <qfiledlg.h> 
#include <qfileinf.h> 
#include <qtooltip.h> 
#include "fileReader.h"
#include <qpushbt.h>
#include <qlabel.h>
#include <qframe.h>
#include <qlayout.h>
#include "ircDefine.h"
#include "startConfigPage.h"
#include "startConfigPage.moc"
#include "ircApp.h"

void StartConfigPage::Init()
{
  btnGroup.setAutoDelete(false);
  groupBox.setAutoDelete(false);
  checkBox.setAutoDelete(false);
  intLine.setAutoDelete (false);

  autoCheckText.setAutoDelete(true);
  delayText.setAutoDelete    (true);
}

StartConfigPage::StartConfigPage(IrcClient* client, QWidget *parent, const char *name ) : 
  QWidget( parent, name )
{
  Init();
  this->client=client;
  
  topLayout = new QVBoxLayout(this, 10);
  grid      = new QGridLayout(2, 2, 10);
  topLayout->addLayout(grid);

  createAutoCheckBox();
  createDelayBox();
  createRawBox();
  createPushButton();
  topLayout->activate();
  readConfig();
  show();
}

StartConfigPage::~StartConfigPage()
{
#ifdef EDEBUG
  cout << "Destruktor StartConfigPage" << endl;
#endif
}


void StartConfigPage::createAutoCheckBox()
{
  QString entry;
  QButtonGroup* bg;

  btnGroup.insert("AutoConfig", bg=new QButtonGroup("Auto Config", this));
  grid->addWidget(bg, 0, 0 );
  grid->setColStretch(0,5); 

  QVBoxLayout* vbox;
  
  vbox = new QVBoxLayout(bg, 10);
  vbox->addSpacing(bg->fontMetrics().height());

  QCheckBox* cb;
  autoCheckText.append(entry=qstrdup("AutoConnect"));
  checkBox.insert(entry, cb = new QCheckBox("Auto Connect", bg));
  cb->setFixedHeight(cb->sizeHint().height());
  vbox->addWidget(cb);

  autoCheckText.append(entry=qstrdup("AutoChangeNick"));
  checkBox.insert(entry, cb = new QCheckBox("Auto Change Nick", bg));
  cb->setFixedHeight(cb->sizeHint().height());
  vbox->addWidget(cb);

  autoCheckText.append(entry=qstrdup("AutoReconnect"));
  checkBox.insert(entry, cb = new QCheckBox("Auto Reconnect", bg));
  cb->setFixedHeight(cb->sizeHint().height());
  vbox->addWidget(cb);
  vbox->addSpacing(bg->fontMetrics().height());
  vbox->activate();
}

void StartConfigPage::createDelayBox()
{
  QString entry;
  QGroupBox* gb;

  groupBox.insert("Delay", gb=new QGroupBox("Delay Config", this));
  grid->addWidget(gb, 0, 1);
  grid->setColStretch(1,10);

  QVBoxLayout* vbox;
  QHBoxLayout* hbox;
  
  vbox = new QVBoxLayout(gb, 10);
  vbox->addSpacing(gb->fontMetrics().height());
  hbox = new QHBoxLayout(10);
  vbox->addLayout(hbox);

  QLabel* label;
  KIntegerLine* il;

  label = new QLabel("StartAction Delay [second]", gb);
  hbox->addWidget(label,5);
  delayText.append(entry="StartActionDelay");
  intLine.insert(entry, il = new KIntegerLine(gb, "line", KEditTypeDec));
  il->setFixedHeight(il->sizeHint().height());
  hbox->addWidget(il,1);

  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);
  label = new QLabel("Reconnect Delay [second]", gb);
  hbox->addWidget(label,5);
  delayText.append(entry="ReconnectionDelay");
  intLine.insert(entry, il = new KIntegerLine(gb, "line", KEditTypeDec));
  il->setFixedHeight(il->sizeHint().height());
  hbox->addWidget(il,1); 

  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);
  label = new QLabel("Ison Delay [minutes]", gb);
  hbox->addWidget(label,5);
  delayText.append(entry="IsonDelay");
  intLine.insert(entry, il = new KIntegerLine(gb, "line", KEditTypeDec));
  il->setFixedHeight(il->sizeHint().height());
  hbox->addWidget(il,1); 

  vbox->addStretch(10);
  gb->setFixedHeight(4*gb->fontMetrics().height());
  vbox->activate();
}

void StartConfigPage::createRawBox()
{
  QString entry;
  QButtonGroup* bg;

  btnGroup.insert("ShowRawInpOut", bg=new QButtonGroup("Show Raw Inp/Out", this));
  grid->addWidget(bg, 1, 1);
  grid->setColStretch(1,5); 

  QVBoxLayout* vbox;
  
  vbox = new QVBoxLayout(bg, 10);
  vbox->addSpacing(bg->fontMetrics().height());

  QCheckBox* cb;
  rawText.append(entry=qstrdup("ShowRawInput"));
  checkBox.insert(entry, cb = new QCheckBox("Show Raw Input", bg));
  cb->setFixedHeight(cb->sizeHint().height());
  vbox->addWidget(cb);

  rawText.append(entry=qstrdup("ShowRawOutput"));
  checkBox.insert(entry, cb = new QCheckBox("Show Raw Output", bg));
  cb->setFixedHeight(cb->sizeHint().height());
  vbox->addWidget(cb);

  vbox->addSpacing(bg->fontMetrics().height());
  vbox->activate();
}


void StartConfigPage::createPushButton()
{
  QPushButton* btn;
  btn = new QPushButton(" Apply ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotApply()));
  grid->addWidget(btn, 1, 0, AlignLeft|AlignTop);
  btn->setFixedSize(100, btn->sizeHint().height());
}

void StartConfigPage::readConfig()
{
  QString check;
  QString entry;
  QString value;
  // Autoconfig
  for (entry=autoCheckText.first();entry;entry=autoCheckText.next()){
      value = ircapp->readEntry(entry, "No");
      if (value=="Yes")
	 checkBox[entry]->setChecked(1);
      ircapp->writeEntry(entry, value);
  }

  // Delay
  for (entry=delayText.first();entry;entry=delayText.next()){
     value = ircapp->readEntry(entry, "1");
     intLine[entry]->setText(value);
     ircapp->writeEntry(entry, value);
  }

  // Raw
  for (entry=rawText.first();entry;entry=rawText.next()){
      value = ircapp->readEntry(entry, "No");
      if (value=="Yes")
	 checkBox[entry]->setChecked(1);
      ircapp->writeEntry(entry, value);
  }
}

void StartConfigPage::slotApply()
{
#ifdef EDEBUG
  cout << "StartConfigPage::slotApply:"<<endl;
#endif
  QString entry;
  QString value;
  QCheckBox* cb;

  for (entry=autoCheckText.first();entry;entry=autoCheckText.next()){
      cb=checkBox[entry];
      if (!cb)
	 continue;
      if (cb->isChecked())
	 value="Yes";
      else
	 value="No";
      ircapp->writeEntry(entry, value);
  }

  for (entry=delayText.first();entry;entry=delayText.next()){
      value=intLine[entry]->text();
      ircapp->writeEntry(entry, value);
  }

  for (entry=rawText.first();entry;entry=rawText.next()){
      cb=checkBox[entry];
      if (!cb)
	 continue;
      if (cb->isChecked())
	 value="Yes";
      else
	 value="No";
      ircapp->writeEntry(entry, value);
  }

}

void StartConfigPage::slotCurrentPage(const char* page)
{
  if (!stricmp(page, name()))
     readConfig();
}
