#include <iostream.h>
#include <qstrlist.h>
#include <qwindefs.h>
#include "remoteNetscape.h"

QString RemoteNetscape::lockData="";
Atom    RemoteNetscape::XA_MOZILLA_VERSION  = 0;
Atom    RemoteNetscape::XA_MOZILLA_LOCK     = 0;
Atom    RemoteNetscape::XA_MOZILLA_COMMAND  = 0;
Atom    RemoteNetscape::XA_MOZILLA_RESPONSE = 0;
Window  RemoteNetscape::window = 0;
bool    RemoteNetscape::checked= 0;
char*   RemoteNetscape::expected_mozilla_version="1.1";

bool RemoteNetscape:: Init()
{
  Display* dpy=qt_xdisplay();
  if (!XA_MOZILLA_VERSION)
     XA_MOZILLA_VERSION = XInternAtom (dpy, MOZILLA_VERSION_PROP, false);
  if (!XA_MOZILLA_LOCK)
     XA_MOZILLA_LOCK = XInternAtom (dpy, MOZILLA_LOCK_PROP, false);
  if (!XA_MOZILLA_COMMAND)
     XA_MOZILLA_COMMAND = XInternAtom (dpy, MOZILLA_COMMAND_PROP, false);
  if (!XA_MOZILLA_RESPONSE)
     XA_MOZILLA_RESPONSE = XInternAtom (dpy, MOZILLA_RESPONSE_PROP, false);

  if (!(window=findWindow()))
     return 0;

  XSelectInput (dpy, window, (PropertyChangeMask|StructureNotifyMask));
  checked=1;
  return 1;
}

Window RemoteNetscape::findWindow()
{
  Display* dpy=qt_xdisplay();
  int i;
  Window root = RootWindowOfScreen(DefaultScreenOfDisplay (dpy));
  Window rootreturn, parent, *kids;
  unsigned int nkids;
  Window result   = 0;
  Window tenative = 0;
  unsigned char *tenative_version = 0;

  if (!XQueryTree (dpy, root, &rootreturn, &parent, &kids, &nkids))
     return 0;

  if (!(kids && nkids))
     return 0;

  for (i=nkids-1; i >= 0; i--){
      Atom type;
      int  format;
      unsigned long nitems, bytesafter;
      unsigned char *version = 0;
      Window w = XmuClientWindow (dpy, kids[i]);
      int status = XGetWindowProperty (dpy, w, XA_MOZILLA_VERSION,
                                       0, (65536 / sizeof (long)),
                                       False, XA_STRING,
                                       &type, &format, &nitems, &bytesafter,
                                       &version);
      if (!version)
         continue;
      if (strcmp ((char*) version, expected_mozilla_version) && !tenative){
          tenative = w;
          tenative_version = version;
          continue;
      }
      XFree (version);
      if (status == Success && type != None){
          result = w;
          break;
      }
  }

  if (result && tenative){
      XFree (tenative_version);
      return result;
  }
  else if (tenative){
      XFree (tenative_version);
      return tenative;
  }
  else if (result){
     return result;
  }
  else
     return 0;
}

void RemoteNetscape::obtainLock ()
{
  Display* dpy=qt_xdisplay();
  Bool locked = false;
  bool waited = false;

  if (lockData.isEmpty()){
      lockData.sprintf("pid%d@", getpid());
      if (gethostname (lockData.data() + lockData.length(), 100)){
          perror ("gethostname");
	  return;
      }
  }

  do{
      int result;
      Atom actual_type;
      int  actual_format;
      unsigned long nitems, bytes_after;
      unsigned char *data = 0;

      XGrabServer (dpy);

      result = XGetWindowProperty (dpy, window, XA_MOZILLA_LOCK,
                                   0, (65536 / sizeof (long)),
                                   false, /* don't delete */
                                   XA_STRING,
                                   &actual_type, &actual_format,
                                   &nitems, &bytes_after,
                                   &data);
      if (result != Success || actual_type == None){
	 // It's not now locked - lock it.
	 XChangeProperty (dpy, window, XA_MOZILLA_LOCK, XA_STRING, 8,
                           PropModeReplace, (unsigned char *) lockData.data(),
                           lockData.length());
          locked = true;
      }

      XUngrabServer (dpy); /* ################################# danger over */
      XSync (dpy, false);

      if (!locked){
          /* We tried to grab the lock this time, and failed because someone
             else is holding it already.  So, wait for a PropertyDelete event
             to come in, and try again. */

          waited = true;

          while (1){
              XEvent event;
              XNextEvent (dpy, &event);
              if (event.xany.type == DestroyNotify   &&
                  event.xdestroywindow.window == window){
		 return;
	      }
              else if (event.xany.type == PropertyNotify &&
                       event.xproperty.state == PropertyDelete &&
                       event.xproperty.window == window &&
                       event.xproperty.atom == XA_MOZILLA_LOCK) {
		 // Ok!  Someone deleted their lock, so now we can try again. 
		 break;
	      }
	  }
      }
      if (data)
         XFree (data);
  }
  while (!locked);
}


void RemoteNetscape::freeLock ()
{
  int  result;
  Atom actual_type;
  int  actual_format;
  unsigned long nitems, bytes_after;
  unsigned char *data = 0;

  Display* dpy=qt_xdisplay();
  result = XGetWindowProperty (dpy, window, XA_MOZILLA_LOCK,
                               0, (65536 / sizeof (long)),
                               true, /* atomic delete after */
                               XA_STRING,
                               &actual_type, &actual_format,
                               &nitems, &bytes_after,
                               &data);
  if (result != Success)
     return;
  else if (!data || !*data)
     return;
  else if (strcmp ((char *) data, lockData.data()))
    return;

  if (data)
     XFree (data);
}

int RemoteNetscape::command (const char *command, bool raise_p)
{
  int  result=0;
  bool done = False;
  char *new_command = 0;

  Display* dpy = qt_xdisplay();
  // The -noraise option is implemented by passing a "noraise" argument
  // to each command to which it should apply.

  if (! raise_p){
      char *close;
      new_command = (char *) malloc (strlen (command) + 20);
      strcpy (new_command, command);
      close = strrchr (new_command, ')');
      if (close)
        strcpy (close, ", noraise)");
      else
        strcat (new_command, "(noraise)");
      command = new_command;
  }


  XChangeProperty (dpy, window, XA_MOZILLA_COMMAND, XA_STRING, 8,
                   PropModeReplace, (unsigned char *) command,
                   strlen (command));

  while (!done){
      XEvent event;
      XNextEvent (dpy, &event);
      if (event.xany.type == DestroyNotify &&
          event.xdestroywindow.window == window){
          result = 6;
          goto DONE;
      }
      else if (event.xany.type == PropertyNotify &&
               event.xproperty.state == PropertyNewValue &&
               event.xproperty.window == window &&
               event.xproperty.atom == XA_MOZILLA_RESPONSE){
          Atom actual_type;
          int actual_format;
          unsigned long nitems, bytes_after;
          unsigned char *data = 0;

          result = XGetWindowProperty (dpy, window, XA_MOZILLA_RESPONSE,
                                       0, (65536 / sizeof (long)),
                                       True, /* atomic delete after */
                                       XA_STRING,
                                       &actual_type, &actual_format,
                                       &nitems, &bytes_after,
                                       &data);

          if (result != Success){
              result = 6;
              done = true;
	  }
          else if (!data || strlen((char *) data) < 5){
              result = 6;
              done = true;
	  }
          else if (*data == '1'){        // positive preliminary reply 
              done = false;
	  }
#if 1
          else if (!strncmp ((char *)data, "200", 3)){ // positive completion 
              result = 0;
              done = true;
	  }
#endif
          else if (*data == '2'){                // positive completion 
              result = 0;
              done = true;
	  }
          else if (*data == '3'){        // positive intermediate reply
              result = 3;
              done = true;
	  }
          else if (*data == '4' ||      // transient negative completion 
                   *data == '5'){       // permanent negative completion 
              result = (*data - '0');
              done = true;
	  }
          else{
              result = 6;
              done = true;
	  }
	  
          if (data)
             XFree (data);
      }
  }

 DONE:

  if (new_command)
     free (new_command);
  return result;
}

int RemoteNetscape::commands(QStrList cmdList)
{
  bool raise_p = true;
  int status = 0;
  if (!checked)
     checked=Init();
  if (!checked)
     return 0;

  obtainLock();

  QString cmd;
  for(cmd=cmdList.first();cmd=cmdList.current();cmd=cmdList.next()){
      if (!strcmp (cmd, "-raise"))
         raise_p = true;
      else if (!strcmp (cmd, "-noraise"))
         raise_p = false;
      else
         status = command (cmd, raise_p);

      if (status != 0)
        break;
  }

  // When status = 6, it means the window has been destroyed 
  // It is invalid to free the lock when window is destroyed.

  if ( status != 6 )
     freeLock ();

  return status;
}

int RemoteNetscape::commands(const char* txt)
{
  bool raise_p = true;
  int status = 0;
  if (!checked)
     checked=Init();
  if (!checked)
     return 0;

  obtainLock();

  QString cmd=txt;
  if (!strcmp (cmd, "-raise"))
     raise_p = true;
  else if (!strcmp (cmd, "-noraise"))
     raise_p = false;
  else
     status = command(cmd, raise_p);

  // When status = 6, it means the window has been destroyed 
  // It is invalid to free the lock when window is destroyed.

  if ( status != 6 )
     freeLock ();

  return status;
}

