#ifndef __ONPROXYPAGE_H__
#define __ONPROXYPAGE_H__

#include <qwidget.h>
#include <qbttngrp.h> 
#include <qgrpbox.h>
#include <qmlined.h>
#include <qlined.h>
#include <qlayout.h> 
#include <qradiobt.h>
#include <qdict.h>
#include <qstrlist.h>
#include <qlabel.h>
#include "kmsgbox.h"
#include "lineDialog.h"

class IrcClient;

class OnProxyPage : public QWidget
{
  Q_OBJECT
protected:
  IrcClient* client;
  QHBoxLayout* horLayout;
  QDict<QRadioButton>   radioBtn;
  QStrList              radioText;
public:
  OnProxyPage(IrcClient* Client, QWidget *parent = 0L, const char *name = 0L );
  ~OnProxyPage();
signals:
protected:
  void    Init();
  void    readConfig();
  void    createRadioButton();
  void    createPushButton();
public slots:
  void slotApply();
};

class SocksPage : public QWidget
{
  Q_OBJECT
protected:
  IrcClient*   client;
  KTabListBox* proxyBox;

  QVBoxLayout* verLayout;
  QHBoxLayout* tHorLayout;
  QHBoxLayout* bHorLayout;

public:
  SocksPage(IrcClient* Client, QWidget *parent = NULL, const char *name = NULL );
  ~SocksPage();
protected:
  void    readConfig();
  void    createButton();
  void    createProxyBox();
  // -1 -> not found
  int     checkItem(QString h, QString p);
protected slots:
  void slotAdd();
  void slotEdit();
  void slotDelete();
public slots:
  void slotApply();
  void addHost(const char* h, const char* p, const char* l=0L, const char* pa=0L);
  void delHost(const char* h, const char* p);
};

#endif
