#include <stdlib.h>
#include <iostream.h>
#include <qlined.h>
#include <qfiledlg.h> 
#include <qfileinf.h> 
#include <qpushbt.h>
#include <qlabel.h>
#include <qframe.h>
#include <qlayout.h>
#include "StringToken.h"
#include "ircDefine.h"
#include "ircClient.h"
#include "onProxyPage.h"
#include "ircApp.h"

void OnProxyPage::Init()
{
  radioBtn.setAutoDelete(false);
  radioText.setAutoDelete(true);
}

OnProxyPage::OnProxyPage(IrcClient* client, QWidget *parent, const char *name ) : 
  QWidget( parent, name )
{
  Init();
  this->client=client;
  
  horLayout = new QHBoxLayout(this, 10);
  createRadioButton();
  createPushButton();
  horLayout->addStretch(3);
  horLayout->activate();
  readConfig();
  show();
}

OnProxyPage::~OnProxyPage()
{
#ifdef EDEBUG
  cout << "Destruktor OnProxyPage" << endl;
#endif
}


void OnProxyPage::createRadioButton()
{
  QString entry;
  QButtonGroup* bg = new QButtonGroup("Proxy Setup", this);
  horLayout->addWidget(bg, 5, AlignLeft|AlignTop);

  QVBoxLayout* vbox = new QVBoxLayout(bg, 10);
  vbox->addSpacing(bg->fontMetrics().height());

  QRadioButton* rb;
  radioText.append(entry=qstrdup("PROXY_SOCKS"));
  radioBtn.insert(entry, rb = new QRadioButton("Use Socks", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  radioText.append(entry=qstrdup("PROXY_MALIOBORO"));
  radioBtn.insert(entry, rb = new QRadioButton("Use Malioboro", bg));
  rb->setEnabled(false);
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  radioText.append(entry=qstrdup("PROXY_DONTUSE"));
  radioBtn.insert(entry, rb = new QRadioButton("Don't use proxy", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);
  vbox->addSpacing(10);
  vbox->activate();
}

void OnProxyPage::createPushButton()
{
  horLayout->addSpacing(10);
  QPushButton* btn;
  btn = new QPushButton(" Apply ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotApply()));
  horLayout->addWidget(btn, 0, AlignLeft|AlignTop);
  btn->setFixedSize(80, 25);
}

void OnProxyPage::readConfig()
{
  QString entry;
  QString value;

  entry = "OnProxy";
  value = ircapp->readEntry(entry, "PROXY_DONTUSE");
  radioBtn[value]->setChecked(true);
  ircapp->writeEntry(entry, value);
}

void OnProxyPage::slotApply()
{
#ifdef EDEBUG
  cout << "OnProxyPage::slotApply:"<<endl;
#endif
  QString entry;
  QString value;
  QRadioButton* rb;

  entry="OnProxy";
  for (value=radioText.first();value;value=radioText.next()){
      rb=radioBtn[value];
      if (!rb)
	 continue;
      if (rb->isChecked())
	 ircapp->writeEntry(entry, value);
  }
}


// ----------------------------------------------------
// SocksPage
// ----------------------------------------------------

SocksPage::SocksPage(IrcClient* client, QWidget *parent, const char *name ) : 
  QWidget(parent, name)
{
#ifdef EDEBUG
  cout << "SocksPage Konstruktor"<<endl;
#endif
  this->client=client;

  verLayout  = new QVBoxLayout(this, 5);
  tHorLayout = new QHBoxLayout(5);
  verLayout->addLayout(tHorLayout,5);

  createProxyBox();

  bHorLayout = new QHBoxLayout(0);
  verLayout->addLayout(bHorLayout,1);
  createButton();
  verLayout->activate();

  readConfig();
  show();
#ifdef EDEBUG
  cout << "SocksPage Konstruktor ...Ok" << endl;
#endif
}

SocksPage::~SocksPage()
{
#ifdef EDEBUG
  cout << "Destruktor SocksPage" << endl;
#endif
}


void SocksPage::createProxyBox()
{
#ifdef EDEBUG
  cout << "SocksPage::createProxyBox" << endl;
#endif

  QFrame* proxyFrame = new QFrame(this);
  proxyFrame->setLineWidth(2);
  proxyFrame->setFrameStyle(QFrame::Panel|QFrame::Sunken);

  tHorLayout->addWidget(proxyFrame);

  QVBoxLayout* vbox = new QVBoxLayout(proxyFrame, 3);;

  proxyBox   = new KTabListBox(proxyFrame, "fileBox", 4);
  vbox->addWidget(proxyBox);
  proxyBox->setColumn(0, "Host");
  proxyBox->setColumn(1, "Port");
  proxyBox->setColumn(2, "Login");
  proxyBox->setColumn(3, "Passwd");
  proxyBox->setColumnWidth(0, 150);
  proxyBox->setColumnWidth(1,  75);
  proxyBox->setColumnWidth(2, 100);
  proxyBox->setColumnWidth(3, 100);
  
  proxyBox->setSeparator  (':');
  vbox->activate();
}

void SocksPage::createButton()
{
#ifdef EDEBUG
  cout << "SocksPage::createBotton" << endl;
#endif
  //bHorLayout->addStretch(10);

  QPushButton* btn;

  btn = new QPushButton(" Add ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotAdd()));
  bHorLayout->addWidget(btn);
  btn->setFixedSize(100, 25);
  btn = new QPushButton(" Edit ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotEdit()));
  bHorLayout->addWidget(btn);
  btn->setFixedSize(100, 25);

  btn = new QPushButton(" Delete ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotDelete()));
  bHorLayout->addWidget(btn);
  btn->setFixedSize(100, 25);

  bHorLayout->addSpacing(10);

  btn = new QPushButton(" Apply ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotApply()));
  bHorLayout->addWidget(btn);
  btn->setFixedSize(100, 25);
  //bHorLayout->addStretch(10);
}

void SocksPage::readConfig()
{
#ifdef EDEBUG
  cout << "SocksPage::readConfig" << endl;
#endif
  KConfig* config=ircapp->getConfig();
  config->setGroup(ircapp->entryGroup);
  proxyBox->clear();
  QStrList list;
  list.setAutoDelete(true);
  int n=config->readListEntry("SocksProxy", list, proxyBox->separator());
  if (n>0){
     proxyBox->appendStrList(&list);
  }
  QString s=config->readEntry("CurrentSocksProxy", "");
  if (!s.isEmpty()){
     QString sep=" ";
     sep += proxyBox->separator();
     StringToken st(s, sep);
     QString h=st.nextToken();
     QString p=st.nextToken();
     for (uint i=0;i<proxyBox->count();i++){
        QString ht=proxyBox->text(i, 0);
        QString pt=proxyBox->text(i, 1);
        if (!stricmp(h, ht) && !stricmp(p, pt)){
	   proxyBox->setCurrentItem(i);
	   return;
	}
     }
  }
}

int SocksPage::checkItem(QString h, QString p)
{
  for (uint i=0;i<proxyBox->count();i++){
     QString ht=proxyBox->text(i, 0);
     QString pt=proxyBox->text(i, 1);
     if (!stricmp(h, ht) && !stricmp(p, pt)){
       return i;
     }
  }
  return -1;
}


void SocksPage::slotAdd()
{
  LineDialog ldlg(this, "", TRUE, "Add Proxy");
  QStrList ll, le;
  ll.setAutoDelete(true);
  ll.append("Host :");
  ll.append("Port :");
  ll.append("Login :");
  ll.append("Passwd :");
  ldlg.setText(ll, le);
  if (ldlg.exec()){
     QString h = ldlg.getText(0);
     QString p = ldlg.getText(1);
     QString l = ldlg.getText(2);
     QString w = ldlg.getText(3);
     if (!h.isEmpty() && !p.isEmpty()){
       if (checkItem(h, p)>=0){
	   KMsgBox::message(this, "Add Dialog", "This proxy "+h+":"+p+ " is already exist", 
			    KMsgBox::INFORMATION, "OK");
	   return;
       }
	char c=proxyBox->separator();
        proxyBox->appendItem(h+c+p+c+l+c+w);
	proxyBox->setCurrentItem(-1);
     } 
  }
}

void SocksPage::addHost(const char* H, const char* P,
			const char* L, const char* Pa)
{
  QString h = H;
  QString p = P;
  QString l = L;
  QString w = Pa;
  if (!h.isEmpty() && !p.isEmpty()){
     if (checkItem(h, p)>=0){
        QString s(1024);
	s.sprintf("Proxy %s : %s exists already", H, P);
	client->slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
        return;
     }
     char c=proxyBox->separator();
     proxyBox->appendItem(h+c+p+c+l+c+w);
     proxyBox->setCurrentItem(-1);
     QString s(1024);
     s.sprintf("Add Proxy : %s %s %s %s", H, P, L, Pa);
     client->slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
  }
}

void SocksPage::slotEdit()
{
  int idx = proxyBox->currentItem();
  if (idx<0)
     return;
  LineDialog ldlg(this, "", TRUE, "Edit Proxy");
  QStrList ll, le;
  ll.setAutoDelete(true);
  le.setAutoDelete(true);
  ll.append("Host :");
  ll.append("Port :");
  ll.append("Login :");
  ll.append("Passwd :");
  le.append(proxyBox->text(idx, 0));
  le.append(proxyBox->text(idx, 1));
  le.append(proxyBox->text(idx, 2));
  le.append(proxyBox->text(idx, 3));
  ldlg.setText(ll, le);
  if (ldlg.exec()){
     QString h = ldlg.getText(0);
     QString p = ldlg.getText(1);
     QString l = ldlg.getText(2);
     if (l.isEmpty())
        l=" ";
     QString w = ldlg.getText(3);
     if (w.isEmpty())
        w=" ";
     if (!h.isEmpty() && !p.isEmpty()){
        char c=proxyBox->separator();
        proxyBox->changeItem(h+c+p+c+l+c+w, idx);
	proxyBox->setCurrentItem(idx);
     } 
  }
}

void SocksPage::slotDelete()
{
  int idx = proxyBox->currentItem();
  if (idx>=0){
     proxyBox->removeItem(idx);
     proxyBox->setCurrentItem(idx-1);
  }
  
}

void SocksPage::delHost(const char* H, const char* P)
{
  QString h = H;
  QString p = P;
  QString s(1024);
  int id;
  if (!h.isEmpty() && !p.isEmpty()){
     if ((id=checkItem(h, p))<0){
        s.sprintf("Proxy : %s %s not found", H, P);
	client->slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
        return;
     }
     proxyBox->removeItem(id);
     proxyBox->setCurrentItem(id);
     s.sprintf("Remove Proxy : %s %s", H, P);
     client->slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
  }
}

void SocksPage::slotApply()
{
  KConfig* config=ircapp->config;

  QStrList list;
  list.setAutoDelete(true);
  QString s;
  char c=proxyBox->separator();
  for (uint i=0;i<proxyBox->count();i++){
     s = proxyBox->text(i);
     list.append(s);
  }
  if (proxyBox->count()>0){
     config->writeEntry("SocksProxy", list, c);
     config->sync();
  }
  int idx = proxyBox->currentItem();
  if (idx>=0){
     QString s=proxyBox->text(idx);
     config->writeEntry("CurrentSocksProxy", s);
     config->sync();
  }
}

#include "onProxyPage.moc"

