#include <stdlib.h>
#include <iostream.h>
#include <qlined.h>
#include <qfiledlg.h> 
#include <qfileinf.h> 
#include <qtooltip.h> 
#include "fileReader.h"
#include <qpushbt.h>
#include <qlabel.h>
#include <qframe.h>
#include <qlayout.h>
#include "ircDefine.h"
#include "ircBell.h"
#include "onDCCChatPage.h"
#include "onDCCChatPage.moc"
#include "ircApp.h"

void OnDCCChatPage::Init()
{
  btnGroup.setAutoDelete(false);
  radioBtn.setAutoDelete(false);
  groupBox.setAutoDelete(false);
  intLine.setAutoDelete (false);

  configText.setAutoDelete(true);
  actionText.setAutoDelete(true);
}

OnDCCChatPage::OnDCCChatPage(IrcClient* client, QWidget *parent, const char *name ) : 
  QWidget( parent, name )
{
  Init();
  this->client=client;
  
  topLayout = new QVBoxLayout(this, 10);
  grid      = new QGridLayout(2, 2, 10);
  topLayout->addLayout(grid);

  createActionRadioBtn();
  createConfigBox();
  createPushButton();
  IrcBell* ib;
  QString  es="DCCChatBell";
  client->bell.insert(es, ib=new IrcBell(client, es, this));
  grid->addWidget(ib, 1, 1);
  topLayout->activate();
  readConfig();
  show();
}

OnDCCChatPage::~OnDCCChatPage()
{
#ifdef EDEBUG
  cout << "Destruktor OnDCCChatPage" << endl;
#endif
}


void OnDCCChatPage::createActionRadioBtn()
{
  QString entry;
  QButtonGroup* bg;

  btnGroup.insert("Action", bg=new QButtonGroup("Action", this));
  grid->addWidget(bg, 0, 0 );

  QVBoxLayout* vbox;
  
  vbox = new QVBoxLayout(bg, 10);
  vbox->addSpacing(bg->fontMetrics().height());

  QRadioButton* rb;
  actionText.append(entry=qstrdup("AutoAccept"));
  radioBtn.insert(entry, rb = new QRadioButton("Auto Accept", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  actionText.append(entry=qstrdup("Ignore"));
  radioBtn.insert(entry, rb = new QRadioButton("Ignore it", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  actionText.append(entry=qstrdup("Dialog"));
  radioBtn.insert(entry, rb = new QRadioButton("Dialog", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);
  vbox->addStretch(10);
  vbox->activate();
}

void OnDCCChatPage::createConfigBox()
{
  QString entry;
  QGroupBox* gb;

  groupBox.insert("Config", gb=new QGroupBox("Config", this));
  grid->addWidget(gb, 0, 1);

  QVBoxLayout* vbox;
  QHBoxLayout* hbox;
  
  vbox = new QVBoxLayout(gb, 5);
  vbox->addSpacing(gb->fontMetrics().height());

  QLabel* label;
  KIntegerLine* il;

  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);
  label = new QLabel("Max DCC Chat Client", gb);
  label->setFixedHeight(24);
  hbox->addWidget(label,5);
  configText.append(entry="DCCChatClientMax");
  intLine.insert(entry, il = new KIntegerLine(gb, "line", KEditTypeDec));
  il->setFixedHeight(24);
  hbox->addWidget(il,1);

  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);
  label = new QLabel("Max Dialog", gb);
  label->setFixedHeight(24);
  hbox->addWidget(label,5);
  configText.append(entry="DCCChatDlgMax");
  intLine.insert(entry, il = new KIntegerLine(gb, "line", KEditTypeDec));
  il->setFixedHeight(24);
  hbox->addWidget(il,1);

  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);
  label = new QLabel("Dialog Timeout [seconds]", gb);
  label->setFixedHeight(24);
  hbox->addWidget(label,5);
  configText.append(entry="DCCChatDlgTimeout");
  intLine.insert(entry, il = new KIntegerLine(gb, "line", KEditTypeDec));
  il->setFixedHeight(24);
  hbox->addWidget(il,1); 

  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);
  label = new QLabel("DCC Chat Timeout [seconds]", gb);
  label->setFixedHeight(24);
  hbox->addWidget(label,5);
  configText.append(entry="DCCChatTimeout");
  intLine.insert(entry, il = new KIntegerLine(gb, "line", KEditTypeDec));
  il->setFixedHeight(24);
  hbox->addWidget(il,1); 

  //gb->setFixedHeight(4*gb->fontMetrics().height());
  vbox->activate();
}



void OnDCCChatPage::createPushButton()
{
  QPushButton* btn;
  btn = new QPushButton(" Apply ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotApply()));
  grid->addWidget(btn, 1, 0, AlignLeft|AlignTop);
  btn->setFixedSize(100, btn->sizeHint().height());
}

void OnDCCChatPage::readConfig()
{
#ifdef EDEBUG
  cout << "OnDCCChatPage::readConfig"<<endl;
#endif
  QString entry;
  QString value;

  QDictIterator<QRadioButton> it(radioBtn);
  QRadioButton* rbtn;
  for (;(rbtn=it.current())!=0L;++it)
     rbtn->setChecked(false);
 
  entry = "OnDCCChat";
  value = ircapp->readEntry(entry, "AutoAccept");
  radioBtn[value]->setChecked(true);
  ircapp->writeEntry(entry, value);

  // max ircclient
  entry = "DCCChatClientMax";
  value = ircapp->readEntry(entry, "5");
  intLine[entry]->setText(value);
  ircapp->writeEntry(entry, value);

  // max window
  entry = "DCCChatDlgMax";
  value = ircapp->readEntry(entry, "5");
  intLine[entry]->setText(value);
  ircapp->writeEntry(entry, value);

  // timeout
  entry = "DCCChatDlgTimeout";
  value = ircapp->readEntry(entry, "30");
  intLine[entry]->setText(value);
  ircapp->writeEntry(entry, value);

  entry = "DCCChatTimeout";
  value = ircapp->readEntry(entry, "120");
  intLine[entry]->setText(value);
  ircapp->writeEntry(entry, value);
}

void OnDCCChatPage::slotApply()
{
#ifdef EDEBUG
  cout << "OnDCCChatPage::slotApply:"<<endl;
#endif
  QString entry;
  QString value;
  QRadioButton* rb;

  entry = "OnDCCChat";
  for (value=actionText.first();value;value=actionText.next()){
      rb=radioBtn[value];
      if (!rb)
	 continue;
      if (rb->isChecked())
	 ircapp->writeEntry(entry, value);
  }

  entry = "DCCChatClientMax";
  value = intLine[entry]->text();
  ircapp->writeEntry(entry, value);

  entry = "DCCChatDlgMax";
  value = intLine[entry]->text();
  ircapp->writeEntry(entry, value);

  // timeout
  entry = "DCCChatDlgTimeout";
  value = intLine[entry]->text();
  ircapp->writeEntry(entry, value);

  entry = "DCCChatTimeout";
  value = intLine[entry]->text();
  ircapp->writeEntry(entry, value);

  client->bell["DCCChatBell"]->slotApply();
}








