#ifndef __ONCTCPSOUNDPAGE_H__
#define __ONCTCPSOUNDPAGE_H__

#include <qwidget.h>
#include <qbttngrp.h> 
#include <qgrpbox.h>
#include <qlayout.h> 
#include <qdict.h>
#include <qstrlist.h>
#include <qlabel.h>
#include <qradiobt.h>
#include "fileListBox.h"
#include "ircClient.h"
#include <kconfig.h>

class OnCTCPSoundPage : public QWidget
{
  Q_OBJECT
protected:
  IrcClient* client;
  QHBoxLayout* horLayout;
  QVBoxLayout* lVerLayout;
  QVBoxLayout* rVerLayout;

  QDict<QButtonGroup> btnGroup;
  QDict<QRadioButton> radioBtn;
  QStrList            actionText;
  QStrList            onPlayText;
  FileDirBox*         dirBox;
public:
  OnCTCPSoundPage(IrcClient* Client, QWidget *parent = NULL, const char *name = NULL );
  ~OnCTCPSoundPage();
protected:
  void    Init();
  void    readConfig();
  void    createActionRadioBtn();
  void    createOnPlayRadioBtn();
  void    createButton();
protected slots:
  void slotApply();
  void slotCurrentPage(const char* page){
      if (!stricmp(page, name()))
	 readConfig();
  } 
};

#endif
