#include <stdlib.h>
#include <iostream.h>
#include <qpushbt.h>
#include <qlabel.h>
#include <qlayout.h>
#include "ircDefine.h"
#include "onCTCPSoundPage.h"
#include "onCTCPSoundPage.moc"
#include "ircApp.h"

void OnCTCPSoundPage::Init()
{
  btnGroup.setAutoDelete(false);
  radioBtn.setAutoDelete(false);

  onPlayText.setAutoDelete(true);
  actionText.setAutoDelete(true);
}

OnCTCPSoundPage::OnCTCPSoundPage(IrcClient* client, QWidget *parent, const char *name ) : 
  QWidget( parent, name )
{
  Init();
  this->client=client;
  
  horLayout  = new QHBoxLayout(this, 10);
  lVerLayout = new QVBoxLayout(0);
  horLayout->addLayout(lVerLayout);
  rVerLayout = new QVBoxLayout(0);
  horLayout->addLayout(rVerLayout);

  createActionRadioBtn();
  createOnPlayRadioBtn();
  createButton();

  horLayout->activate();
  readConfig();
  show();
}

OnCTCPSoundPage::~OnCTCPSoundPage()
{
#ifdef EDEBUG
  cout << "Destruktor OnCTCPSoundPage" << endl;
#endif
}


void OnCTCPSoundPage::createActionRadioBtn()
{
  QString entry;
  QButtonGroup* bg;

  btnGroup.insert("Action", bg=new QButtonGroup("Action", this));
  lVerLayout->addWidget(bg);

  QVBoxLayout* vbox;
  
  vbox = new QVBoxLayout(bg, 10);
  vbox->addSpacing(bg->fontMetrics().height());

  QRadioButton* rb;
  actionText.append(entry=qstrdup("AutoAccept"));
  radioBtn.insert(entry, rb = new QRadioButton("Auto Accept", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  actionText.append(entry=qstrdup("Ignore"));
  radioBtn.insert(entry, rb = new QRadioButton("Ignore it", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  actionText.append(entry=qstrdup("Dialog"));
  radioBtn.insert(entry, rb = new QRadioButton("Dialog", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);
  vbox->addSpacing(bg->fontMetrics().height());
  vbox->activate();
}

void OnCTCPSoundPage::createOnPlayRadioBtn()
{
  QString entry;
  QButtonGroup* bg;

  btnGroup.insert("OnPlaying", bg=new QButtonGroup("On Playing", this));
  rVerLayout->addWidget(bg);

  QVBoxLayout* vbox;
  
  vbox = new QVBoxLayout(bg, 10);
  vbox->addSpacing(bg->fontMetrics().height());

  QRadioButton* rb;
  onPlayText.append(entry=qstrdup("Always"));
  radioBtn.insert(entry, rb = new QRadioButton("Always play", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  onPlayText.append(entry=qstrdup("Wait"));
  radioBtn.insert(entry, rb = new QRadioButton("Wait...play after", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  onPlayText.append(entry=qstrdup("Dontplay"));
  radioBtn.insert(entry, rb = new QRadioButton("Don't play", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);
  vbox->addSpacing(bg->fontMetrics().height());
  vbox->activate();
}

void OnCTCPSoundPage::createButton()
{
  QHBoxLayout* hbox;
  QLabel*      label;
  QPushButton* btn;

  lVerLayout->addSpacing(10);

  hbox = new QHBoxLayout(10);
  lVerLayout->addLayout(hbox);

  label = new QLabel("CTCP Sound DIR :" , this);
  hbox->addWidget(label);
  label->setFixedHeight(25);

  dirBox = new FileDirBox(this);
  hbox->addWidget(dirBox);
  dirBox->setFixedHeight(25);

  lVerLayout->addSpacing(10);

  btn = new QPushButton(" Apply ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotApply()));
  lVerLayout->addWidget(btn, 0, AlignLeft);
  btn->setFixedSize(100, 25);
  lVerLayout->addStretch(10);
}

void OnCTCPSoundPage::readConfig()
{
#ifdef EDEBUG
  cout << "OnCTCPSoundPage::readConfig"<<endl;
#endif
  QString entry;
  QString value;

  QDictIterator<QRadioButton> it(radioBtn);
  QRadioButton* rbtn;
  for (;(rbtn=it.current())!=0L;++it)
     rbtn->setChecked(false);
  
  entry = "OnCTCPSound";
  value = ircapp->readEntry(entry, "AutoAccept");
  radioBtn[value]->setChecked(true);
  ircapp->writeEntry(entry, value);

  entry = "OnCTCPSoundOnPlay";
  value = ircapp->readEntry(entry, "Dontplay");
  radioBtn[value]->setChecked(true);
  ircapp->writeEntry(entry, value);

  QString dir=ircapp->readEntry("CTCPSoundDir", ircapp->home);
  dirBox->setPath(dir);
}

void OnCTCPSoundPage::slotApply()
{
#ifdef EDEBUG
  cout << "OnCTCPSoundPage::slotApply:"<<endl;
#endif
  QString entry;
  QString value;
  QRadioButton* rb;

  entry = "OnCTCPSound";
  for (value=actionText.first();value;value=actionText.next()){
      rb=radioBtn[value];
      if (!rb)
	 continue;
      if (rb->isChecked())
	 ircapp->writeEntry(entry, value);
  }

  entry = "OnCTCPSoundOnPlay";
  for (value=onPlayText.first();value;value=onPlayText.next()){
      rb=radioBtn[value];
      if (!rb)
	 continue;
      if (rb->isChecked())
	 ircapp->writeEntry(entry, value);
  }

  QString dir=dirBox->currentText();
  ircapp->writeEntry("CTCPSoundDir", dir);
}










