#ifndef __IRCUSER_H__
#define __IRCUSER_H__ 

#include <qlist.h>
#include <qstring.h>
#include "ircCore.h"

class IrcUser : public IrcCore
{
protected:
  QString mNick;
  QString mUser;
  QString mHost;
  QString mInfo;
  QString mServer;
  long lastActive;
  int  activeCount;
public:
  IrcUser(const char* nick, const char* user, const char* host);
  IrcUser(const char* name);   // ~nick!user@host
  QString toName ();
  QString nick(){return mNick;}
  QString user(){return mUser;}
  QString host(){return mHost;}
  QString info(){return mInfo;}
  QString server(){return mServer;}
  bool checkFlood(int inSecond=1, int maxLine=3);
  void setNick(const char* s){
    mNick = s;
  }
  void setUser(const char* s){
    mUser = s;
  }
  void setHost(const char* s){
    mHost = s;
  }
  void setInfo(const char* s){
    mInfo = s;
  }
  void setServer(const char* s){
    mServer = s;
  }
};

class FriendList;

class FriendUser
{
  friend class FriendList;
protected:
  QString mIdent;
  QString mChannel;
  QString mPasswd;
  QString mEmail;
  QString mComment;
  int     mLevel;
protected:
  bool matchChannel(const char* channel);
public:
  FriendUser(const char* ident, int level, const char* channel="*");
  ~FriendUser();
   void addChannel(const char* channel);
  QString getIdent(){
     return mIdent;
  }
  int getLevel(){
     return mLevel;
  }
  QString getChannel(){
     return mChannel;
  }
};

class IrcClient;

class FriendList
{
protected:
  IrcClient* client;
  QList<FriendUser> mList;
  bool  mUpdate;
protected:
  void delUserIn(const char* list, const char* ident, bool wildcard=false);
public:
  FriendList(IrcClient* client);
  virtual ~FriendList();
  FriendUser* getUser(const char* ident, bool wildcard=false);
  FriendUser* addUser(const char* ident, int level, const char* channel="*");
  void delUser  (const char* ident, bool wildcard=false);
  // -1: not found, 0: level < userlevel, 1: level >= userlevel
  // userlevel will be saved in return, if return not 0L
  int matchUser(const char* ident,      int level,  bool wildcard=TRUE, 
		const char* channel=0L, int* ret=0L);
  FriendUser* first(){
     return mList.first();
  }
  FriendUser* next(){
     return mList.next();
  }
  FriendUser* current(){
     return mList.current();
  }
  void setUpdate(bool state){
     mUpdate=state;
  }
  bool getUpdate(){
     return mUpdate;
  }
  QList<FriendUser>& getUserList(){
     return mList;
  }
};

#endif


