#include <iostream.h>
#include "StringToken.h"
#include "ircListBox.h"
#include "ircListBox.moc"

#include <iostream.h>
#include <qlayout.h>

IrcListBox::IrcListBox(QWidget* parent, const char* Name):
  QListBox(parent, Name)
{
  list.setAutoDelete (TRUE);
  setMultiSelection  (FALSE);
}

IrcListBox::~IrcListBox()
{
#ifdef EDEBUG
  cout << "Destruktor IrcListBox" << endl;
#endif
}

void IrcListBox::mousePressEvent(QMouseEvent* e)
{
  if (e->button()==RightButton){
     QPoint pos=mapToGlobal(e->pos());
     emit signMouseRightPress((const QPoint&)pos);
     return;
  }
  if (e->button()==LeftButton){
     if (isMultiSelection()){
       if (e->state()&ControlButton){
	  QListBox::mousePressEvent(e);
       }
       else{
	  clearSelection();
	  QListBox::mousePressEvent(e);
       }
     }
     else{
        QListBox::mousePressEvent(e);
     }
  }

}

QList<char>* IrcListBox::getSelected()
{
  list.clear();
  for (uint i=0;i<count();i++){
    if (isSelected(i)){
       StringToken t(text(i));
       QString n=t.nextToken(" +@");
       list.append(qstrdup(n));
    }
  }
  return &list;
}






