#ifndef __IRCLINE_H__
#define __IRCLINE_H__

#include <qlined.h>
#include <qstrlist.h>
#include <qdict.h>
#include <qkeycode.h>
#include "colorOpt.h"
#include "ringList.h"

class IrcLine : public QLineEdit
{
  Q_OBJECT
protected:
  bool    autoClean;
  QColor  textColor;
  QString fontName;
  int     fontSize;
  int     curHistory;   // Pos von current
  int     aktHistory;   // Pos von aktuell
  RingList<char>* history;
  QString         inpTxt;
  IrcColorDlg* ircColorDlg;
protected:
  void keyPressEvent(QKeyEvent* e);
  void mousePressEvent(QMouseEvent* );
  virtual void focusOutEvent (QFocusEvent* );
public:
  IrcLine(QWidget* parent=NULL, const char* name=NULL, int buffer=5, bool autoClean=FALSE);
  ~IrcLine();
public slots:
  void slotTextReturn();
signals:
  void signReturn(const char*  text);
  void signMouseRightPress(const QPoint&);
};

#endif
