#ifndef  __IRCCORE_H__
#define  __IRCCORE_H__

#include <qlist.h>
#include <qstrlist.h>
#include <qdict.h>
#include <qobject.h>
#include <qtimer.h>

class IrcCore : public QObject
{
  Q_OBJECT
protected:
  int    idTimer;
  ulong  secWalker;     
  ulong  cusInterval;
  ulong  minutes;
protected:
  virtual void timerEvent(QTimerEvent* e);
signals:
  void signSecTimeout(IrcCore* ic);
  void signMinTimeout(IrcCore* ic);
  void signCusTimeout(IrcCore* ic);
public:
  IrcCore (QObject* Parent=0, const char* Name=0, ulong CusInterval=60, bool Start=0);
  virtual ~IrcCore();
  void setCusInterval(ulong);
  void start();
  void stop ();
  ulong getMinutes();
  bool  isActive();

protected slots:
  virtual void slotTimeout();
};

#endif





