#ifndef __IRCALIAS_H__
#define __IRCALIAS_H__

#include <qstring.h>
#include <qdict.h>
#include <qobject.h>

class IrcAlias : public QObject
{
  Q_OBJECT
protected:
  QString entry;
  QString path;
  QDict<char>* alias;
signals:
  void signUpdateData();
public:
  IrcAlias();
  IrcAlias(const char* Entry, const char* Path="kEirc.alias");
  ~IrcAlias();
  void    add  (const char* Cmd, const char* Value);
  void    add  (const char* Txt);   
  QString eval (const char* Alias);
  int     load (const char* File=0);
  int     save (const char* File=0);
  void    clear();
  QDict<char>* getList();
  QString getEntry();
  QString getPath ();
  void    setEntry(const char* Entry);
};

#endif

