#include <stdlib.h>
#include <iostream.h>
#include <qtstream.h> 
#include <qfile.h> 
#include <qlist.h>
#include "StringToken.h"
#include "fileReader.h"
#include "ircApp.h"

FileReader::FileReader(QStrList* list, const char* Entry, const char* File)
{
  dict = 0;
  this->list = list;
  path = ircapp->readPathEntry(Entry, File);
  entry= Entry;
}

FileReader::FileReader(QDict<char>* dict, const char* Entry, const char* File)
{
  list = 0;
  this->dict = dict;
  path = ircapp->readPathEntry(Entry, File);
  entry= Entry;
}

FileReader::~FileReader()
{

}

int FileReader::load(const char* File, const char* delim)
{
  QString tmp=path;
  if (File)
     tmp=File;
  QFile f(tmp);
  if (!f.open(IO_ReadOnly))
      return 0;

  path = tmp;
  QTextStream ts(&f); 
  QString s;
  if (list)
     list->clear();
  if (dict)
     dict->clear();
  while (!ts.eof()){
    s = ts.readLine();  
    s = s.stripWhiteSpace();
    if (s.isEmpty() || s[0]=='#')
       continue;
    if (list)
       list->append(s);
    if (dict){
       StringToken t(s, delim);
       QString key=t.nextToken();
       dict->insert(key, qstrdup(t.toEnd()));
    }
  }
  return 1;
}

int FileReader::save(const char* File, const char* delim)
{
  QString tmp=path;
  if (File)
     tmp=File;
  QFile f(tmp);
  if (!f.open(IO_WriteOnly))
     return 0;
  path = tmp;
  QTextStream ts(&f); 
  QString item;
  if (list){
     for (item=list->first();item;item=list->next())
         ts << item << endl;
  }
  if (dict){
     QDictIterator<char> it(*dict);
     for (it.current();it.current();++it)
         ts << it.currentKey() << delim << it.current() <<endl;
  } 
  return 1;
}

QString FileReader::getPath()
{
  return path;
}




