#include "StringToken.h"
#include "dccFilePage.h"
#include "dccFileTab.h"
#include "ircDefine.h"
#include <qregexp.h>

#include <iostream.h>
#include <qlayout.h>
#include "ircApp.h"

DCCFilePage::DCCFilePage(IrcClient* Client, QWidget* parent, const char* Name) :
             OutputPage(Client, parent, Name)
{
#ifdef EDEBUG
  cout << "DCCFilePage Konstruktor:"<<Name<<endl;
#endif
  dccClient  = client->dccFile->find(Name);
  if (!dccClient){
     cout << "DCC Object: " << Name <<" cannot be found" << endl;
     return;
  }
  connect(dccClient, 
	  SIGNAL(signWriteMsg(int, const char*, bool)), 
	  SLOT  (slotWriteMsg(int, const char*, bool)));
  connect(dccClient, 
	  SIGNAL(signValue(int, ulong, ulong)), 
	  this, 
	  SLOT  (slotValue(int, ulong, ulong)));
  connect(dccClient, 
	  SIGNAL(signServe()), 
	  this, 
	  SLOT  (slotServe()));
  connect(dccClient, 
	  SIGNAL(signConnect()), 
	  this, 
	  SLOT  (slotConnect()));
  connect(dccClient, 
	  SIGNAL(signConnected()), 
	  this, 
	  SLOT  (slotConnected()));
  connect(dccClient, 
	  SIGNAL(signDisconnected()), 
	  this, 
	  SLOT  (slotDisconnected()));
  connect(dccClient,
	   SIGNAL(signMinTimeout(IrcCore*)),
	   this,
	   SLOT  (slotLiveStatus(IrcCore*)));

  createProgress();
  createToolbar(); 
  createPopup();

  label = new QLabel(inpCmd);
  QString s(1024);
  s.sprintf("Speed : %7s Bytes/s, Time-Remaining : %5s seconds", "", "");
  label->setText(s);
}

DCCFilePage::~DCCFilePage()
{
#ifdef EDEBUG
  cout << "Destruktor DCCFilePage" << endl;
#endif;
}

void DCCFilePage::createPopup()
{
  IrcPopup* popup;
  if (!(popup = client->popup.find("DCCFile")))
     popup = client->popup.find("Default");

  if (popup){
     connect(ircHtml()->htmlWidget(),
	     SIGNAL(popupMenu (const char*, const QPoint&)),
	     this,
	     SLOT  (slotDCCPopup (const char*, const QPoint&))); 

     connect(popup,
	     SIGNAL(signPopup(const char*)),
	     this,
	     SLOT  (slotDCCPopupAction(const char*)));
  }
}


void DCCFilePage::slotDCCPopup(const char*, const QPoint& pos)
{
#ifdef EDEBUG
  cout <<"DCCFilePage::slotDCCPopup:"+QString(dccClient->name())<<endl;
#endif
  IrcPopup* popup = client->popup.find("DCCFile");
  if (!popup)
     return;
  QPopupMenu* pu=popup->find("Main");
  if (pu){
    pu->popup(pos);
  }
}

void DCCFilePage::slotDCCPopupAction(const char* Action)
{
  if ( IsSelected()==true && isActiveWindow()==true)
     dccClient->slotInputParse(Action);

  return;
}

void DCCFilePage::slotValue(int v, ulong speed, ulong remain)
{
  progress->setValue(v);
  QString s,r,txt;
  float fspeed, fremain;
  if (speed>=1024){
     fspeed=(float)((float)speed/1024.);
     s="KBytes/s";
  }
  else{
     fspeed=(float)speed;
     s="Bytes/s";
  }
  if (remain>=60000){
     fremain=(float)((float)remain/60000.);
     r="minutes";
  }
  else if (remain>=1000){
     fremain=(float)((float)remain/1000.);
     r="seconds";
  }
  else{
    fremain=(float)remain;
    r="millliseconds";
  }

  txt.sprintf("Speed : %-8.2f %-10s,     Time-Remaining : %-6.2f %s", 
	      fspeed, s.data(), fremain, r.data());
  label->setText(txt);
}

void DCCFilePage::Init()
{
}

void DCCFilePage::createProgress()
{
  progress = new KProgress(0, 100, 0, KProgress::Vertical, panWidget);
  panner->setSeparatorPos(80);

  progress->setBarStyle(KProgress::Solid);
  progress->setBarColor(QColor(blue));
  progress->show();
}
  
void DCCFilePage::createToolbar()
{
}

void DCCFilePage::slotExit(MDIWindow*)
{
  client->delDCCFile(dccClient->name(), false);
}

void DCCFilePage::slotServe()
{
  InetAddress inAddr=dccClient->server.getLocalInetAddress();
  int port          =dccClient->server.getLocalPort();
  QString ps;
  ps.setNum(port);
  QString s="Wait connection on "+inAddr.getHostAddress()+":"+ps;
  dccClient->slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
  ircHtml()->setCursor(waitCursor); 
}


void DCCFilePage::slotConnect()
{
  QString s="Try connect to host "+dccClient->host->Host()+" on port "+dccClient->host->Port();
  dccClient->slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
  s = "Please wait...";
  dccClient->slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
  ircHtml()->setCursor(waitCursor);
}

void DCCFilePage::slotConnected()
{
  QString s = "Connected to port "+dccClient->host->Port()+" of host "+dccClient->host->Host();
  dccClient->slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
  ircHtml()->setCursor(arrowCursor);
}

void DCCFilePage::slotDisconnected()
{
  QString s;
  if (dccClient->host)
    s = "Disconnected from host "+dccClient->host->Host()+" on port "+dccClient->host->Port();
  else
    s = "Disconnected...";
  dccClient->slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
  ircHtml()->setCursor(arrowCursor);
}

void DCCFilePage::slotLiveStatus(IrcCore*)
{
}

void DCCFilePage::resizeEvent(QResizeEvent* e)
{
  OutputPage::resizeEvent(e);
  label->setGeometry(0, 0,
		     inpCmd->width(), inpCmd->height());
  
  progress->setGeometry(0,
			0,
			panWidget->width(),
			panWidget->height());
			
}


DCCFile* DCCFilePage::getClient()
{
  return dccClient;
}

void DCCFilePage::slotWriteMsg(int type, const char* txt, bool parse)
{
  htmlMsg->slotWrite(type, txt, parse);
  if (!IsSelected())
    emit signNewMsg();
}

#include "dccFilePage.moc"
