#include <iostream.h>
#include <time.h>
#include "StringToken.h"
#include "ircClient.h"
#include "dccFile.h"
#include "ircDefine.h"
#include "ircApp.h"
#include <X11/Xlib.h>

void DCCFile::Init()
{
  size   = 0;
  curSize= 0;
}

DCCFile::DCCFile(const char* User, const char* file, const char* ip, const char* port, const char* size,
		 QObject* Parent,  const char* Name):
  DCCClient(User, Parent, Name)
{
  Init();
  type = DCC_INCOMING;
  ulong uip = ntohl(QString(ip).toULong());
  InetAddress inAddr(uip);
  host = new IrcServer(inAddr.getHostAddress(), QString(port).toInt());
  QString dir = ircapp->readEntry("DCCFileDir", ircapp->home);
  this->file.setName(dir+"/"+QString(file));
  this->size = QString(size).toUInt();
  connect(host,
	  SIGNAL(signSecTimeout(IrcCore*)),
	  SLOT  (slotConnect   (IrcCore*)));
  setName(QString(file)+":"+QString(User));
  host->start();
}

DCCFile::DCCFile(const char* User, const char* file, QObject* Parent,  const char* Name):
  DCCClient(User, Parent, Name)
{
  Init();
  type  = DCC_OUTGOING;
  block = ircapp->readNumEntry("DCCSendBlock", 1024);

  this->file.setName(file);
  setName(QString(file)+":"+QString(User));
  connect(this,
	  SIGNAL(signCusTimeout(IrcCore*)),
	  SLOT  (slotServe(IrcCore*)));
  setCusInterval(1);
  start();
}

DCCFile::~DCCFile()
{
#ifdef EDEBUG
  cout << "Destruktor DCCFile" << endl;
#endif
}

QString DCCFile::cmdSubstitution(const char* Txt)
{
#ifdef EDEBUG
  cout << "DCCFile::cmdSub" << Txt<<endl;
#endif
  QDict<char> list;
  list.setAutoDelete(true);
  list.insert("$file",    qstrdup(file.name()));
  list.insert("$to",      qstrdup(user->nick()));
  
  return ClientCore::cmdSubstitution(list, Txt);
}

void DCCFile::slotServe(IrcCore*)
{
#ifdef EDEBUG
  cout << "DCCFile::slotServe:"<<name() << endl;
#endif
  stop();
  disconnect(this,
	     SIGNAL(signCusTimeout(IrcCore*)),
	     this,
	     SLOT  (slotServe(IrcCore*)));

  slotWriteMsg(TYPE_INFO|TYPE_IMG, "Please wait...");
  QString to=user->nick();
  QString host=client->getSocket().getLocalInetAddress().getHostAddress();
  if (server.Open(host)<1){
     slotDisconnected();
     return;
  }
  emit signServe();
  QString as, ps;
  ulong up = htonl(server.getLocalInetAddress().getAddress());
  as.setNum(up);
  ps.setNum(server.getLocalPort());

  QFileInfo fi(file);
  size = fi.size();
  QString ss;
  ss.setNum(size);

  QString s="";
  s += to+" DCC SEND "+fi.fileName()+" "+as+" "+ps+" "+ss;
  client->getSocket().sendCtcp(s);  
  connect(&server,
	  SIGNAL(signAccept(ClientSocket*)),
	  SLOT  (slotAccept(ClientSocket*)));

  int timeout=ircapp->readNumEntry("DCCFileTimeout", 120);
  setCusInterval(timeout);
  connect(this,
	  SIGNAL(signCusTimeout(IrcCore*)),
	  SLOT  (slotCusTimeout(IrcCore*)));
  start();
}

void DCCFile::slotMsgParse(int sd)
{
  if (sd<1)
     return;
  sn->setEnabled(false);
  switch (type){
  case DCC_INCOMING:
    if (curSize==0){
       QString s;
       int r=file.open(IO_Raw|IO_WriteOnly);
       if (!r){
	  s="Cannot open "+QString(file.name());
	  emit signWriteMsg(TYPE_ERROR|TYPE_IMG, s);
	  slotDisconnected();
	  return;
       }
       s="Starting file transfer from "+user->toName()+", save on "+QString(file.name());
       emit signWriteMsg(TYPE_INFO|TYPE_IMG, s);
       timer = (ulong)time(0L);
    }
    dccIncoming();
    break;
  case DCC_OUTGOING:
    uint bytesrecv;
    if (::read(socket->getSocket(), &bytesrecv, sizeof(int))<(int)sizeof(int)){
       slotDisconnected();
       return;
    }
    uint recv=ntohl(bytesrecv);
    if (recv!=curSize){
       return;
    }
    QString s(1024);
    ulong current=(ulong)time(0L);
    ulong elapsed = current-timer;

    ulong speed =0;
    ulong remain=0;
    if (elapsed < 1)
	 elapsed=1;
    speed  =  curSize/elapsed;                            //bytes/seconds
    remain = (size-curSize)*1000/(speed?speed:1);              //milliseconds

    if (curSize==size)
       transferCompleted(speed, elapsed);
    else
      emit signValue(curSize*100/size, speed, remain);

    dccOutgoing();
    break;
  }

  if (sn)
        sn->setEnabled(true);
}

void DCCFile::dccIncoming()
{
  QString d(4096);
  QString s(1024);

  ulong current=(ulong)time(0L);
  ulong elapsed = current-timer;

  ulong speed =0;
  ulong remain=0;
  if (elapsed < 1)
     elapsed=1;
  int bytesread = ::read(socket->getSocket(), d.data(), 4096);
  if (bytesread>0)
     curSize += bytesread;
  speed  =  curSize/elapsed;                        //bytes/seconds
  remain = (size-curSize)*1000/(speed?speed:1);    //milliseconds

  switch(bytesread){
  case 0:
    if (curSize==size)
       transferCompleted(speed, elapsed);
  case -1:
    if (curSize!=size){
       s="Transfer broken";
       slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
    }
    slotDisconnected();
    break;
  default:
    file.writeBlock(d, bytesread);
    uint tmp=htonl(curSize);
    ::write(socket->getSocket(), &tmp, sizeof(int));
    emit signValue(curSize*100/size, speed, remain);
  }
}

void DCCFile::dccOutgoing()
{
  QString d(block);
  QString s;
  switch(int bytesread = file.readBlock(d.data(), block)){
  case  0:
  case -1:
    if (curSize!=size){
       s="Transfer broken";
       slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
    }
    slotDisconnected();
    break;
  default:
    ::write(socket->getSocket(), d.data(), bytesread);
    curSize += bytesread;
  }
}

void DCCFile::slotDisconnected()
{
  DCCClient::slotDisconnected();
  file.close();
  QString value;
  value = ircapp->readEntry("OnFinishedBeep", "No");
  if (!stricmp(value, "Yes"))
     XBell(ircapp->getDisplay(), 50);
  value = ircapp->readEntry("OnFinishedCloseWindow", "No");
  if (!stricmp(value, "Yes"))
     client->delDCCFile(name(), true);
}

void DCCFile::slotConnected()
{
  DCCClient::slotConnected();
  if (type==DCC_OUTGOING){
     QString s;
     if (!file.open(IO_Raw|IO_ReadOnly)){
        s="Cannot open "+QString(file.name());
	emit signWriteMsg(TYPE_ERROR|TYPE_IMG, s);
        slotDisconnected();
	return;
     }
     s="Starting file transfer to "+user->nick()+", from "+QString(file.name());
     emit signWriteMsg(TYPE_INFO|TYPE_IMG, s);
     timer = (ulong)time(0L);
     dccOutgoing();
  }
}


void DCCFile::slotInputParse(const char* Txt)
{
#ifdef EDEBUG
  cout << "DCCFile::slotInputParse:"<<Txt<<endl;
#endif
  QString inp = client->alias->eval(Txt);
  inp = cmdSubstitution(inp);
  if (inp.isEmpty())
     return;
  emit signCommand(name(), inp);
}

void DCCFile::transferCompleted(ulong speed, ulong elapsed)
{
  QString r, s;
  float   felapsed;
  emit signValue(100, speed, 0);
  elapsed *= 1000;
  if (elapsed>=60000){
     felapsed=(float)((float)elapsed/60000.);
     r="minutes";
  }
  else if (elapsed>=1000){
     felapsed=(float)((float)elapsed/1000.);
     r="seconds";
  }
  else{
    felapsed=(float)elapsed;
    r="millliseconds";
  }
  s.sprintf("Transfer completed, file size %u bytes, time needed %-5.2f %s ", 
	    size, felapsed, r.data());
  slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
}

#include "dccFile.moc"
