#include <iostream.h>
#include "StringToken.h"
#include "dccChatPage.h"
#include "ircView.h"
#include "dccChatTab.h"
#include "dccChatTab.moc"
#include "colorOpt.h"
#include "fontOpt.h"
#include "optPrefDialog.h"

#include <iostream.h>
#include <qlayout.h>

DCCChatTab::DCCChatTab(IrcClient* Client, QWidget* parent, const char* Name):
  PageTab(Client, parent, Name)
{
  connect(client, 
	  SIGNAL(signAddDCCChat(const char*)),
	  this,
	  SLOT  (slotAddDCCChat(const char*)));

  show();
}

DCCChatTab::~DCCChatTab()
{
#ifdef EDEBUG
  cout << "Destruktor DCCChatTab" << endl;
#endif
}

void DCCChatTab::slotAddDCCChat(const char* Name)
{
#ifdef EDEBUG
  cout << "DCCChatTab::slotAddDCCChat:" << Name<<endl;
#endif
  DCCChatPage* dcp;
  QString s=Name;
  treeList->insertItem(s, 0, treeList->currentItem());

  pageWidget->hide();

  QString  value;
  value = ircapp->readEntry("DCCChatWindowDetach", "No");
  if (value.find( "No", 0, false ) == 0){
     dcp=new DCCChatPage(client, pageWidget, Name);
     dcp->vbox = new QVBoxLayout(pageWidget,0);
     dcp->vbox->addWidget(dcp);
     dcp->vbox->activate();
  }
  else{
     dcp=new DCCChatPage(client, 0L, Name);
     dcp->setCaption(Name);
     dcp->show();
  }
  page->insert(Name, dcp);

  pageWidget->show();

  OptPrefDialog* dlg=client->optPrefDlg;
  
  connect(dcp->getClient(), 
	  SIGNAL(signDelClient(const char*)),
	  this,
	  SLOT  (slotDelPage  (const char*)));
  connect(this,
	  SIGNAL(signCurrentPage(const char*)),
	  dcp,
	  SLOT  (slotCurrentPage(const char*)));
  connect(dcp,
	  SIGNAL(signDetach(bool, const char*)),
	  this,
	  SLOT  (slotDetach(bool, const char*)));

  QWidget* w=topLevelWidget();
  if (!w->isVisible())
     w->show();

  
  KTreeListItem* item;
  for (int i=0;i<treeList->count();i++){
     item = treeList->itemAt(i);
     if (!stricmp(Name, item->getText())){
        slotSetPage(i);
	return;
     }
  }
}


void DCCChatTab::slotDetach(bool detach, const char* name)
{
  ircapp->writeEntry( "DCCChatWindowDetach",   detach ? "Yes" : "No" );
  PageTab::slotDetach(detach, name);
}








