#ifndef __DCCCHATPAGE_H__
#define __DCCCHATPAGE_H__

#include "dccChat.h"
#include "ircPopup.h"
#include "outputPage.h"

class DCCChatPage : public OutputPage
{
  Q_OBJECT
protected:
  DCCChat*    dccClient;
  
protected:
  void Init();
  void createPopup();
  void createMenu();
  void createToolbar();
public slots:
  void slotServe  ();
  void slotConnect();
  void slotConnected();
  void slotDisconnected();

  void slotDCCPopup      (const char*, const QPoint&);
  void slotDCCPopupAction(const char*);
  
  virtual void slotExit(MDIWindow*);
  void slotWriteMsg(int type, const char* txt, bool parse=true);
public:
  DCCChatPage(IrcClient* Client, QWidget* parent, const char* Name=NULL);
  ~DCCChatPage();
  DCCChat* getClient();
};

#endif 



