#include <iostream.h>
#include "StringToken.h"
#include "fileReader.h"
#include "clientConfig.h"
#include "ircApp.h"

ReadTab ClientConfig::readTab[]={
    {"NICK",          ClientConfig::readNick   },
    {"CURRENTNICK",   ClientConfig::readCurrentNick   },
    {"USER",          ClientConfig::readUser   },
    {"CURRENTUSER",   ClientConfig::readCurrentUser   },
    {"IRCNAME",       ClientConfig::readIrcname   },
    {"CURRENTIRCNAME",ClientConfig::readCurrentIrcname   },
    {"SERVER",        ClientConfig::readServer   },
    {"CURRENTSERVER", ClientConfig::readCurrentServer   },
    { NULL,	      NULL              }
};

ClientConfig::ClientConfig()
{
  nick.setAutoDelete   (true);
  user.setAutoDelete   (true);
  ircname.setAutoDelete(true);
  server   = new QDict<IrcServer>(20, false, true);
  itServer = NULL;
  entry = "ClientConfig";
  path  = ircapp->readPathEntry(entry, "kEirc.cfg");
  loadConfig();
}

ClientConfig::~ClientConfig()
{
}

int ClientConfig::loadConfig(const char* File)
{
  QStrIList list;
  FileReader fr(&list, entry, path);
  if (!fr.load(File))
     return 0;
  path = fr.getPath();

  nick.clear();
  user.clear();
  ircname.clear();
  server->clear();
  curNick="";
  curUser="";
  curIrcname="";
  curServer =NULL;
  if (itServer){
     delete itServer;
     itServer = NULL;
  }
  for (list.first();list.current();list.next())
     parseConfig(list.current());

  if (nick.isEmpty())
     nick.inSort(curNick="lesehan");
  if (user.isEmpty())
     user.inSort(curUser="keirc");
  if (ircname.isEmpty())
     ircname.inSort(curIrcname="kEirc client using kde");
  if (server->isEmpty())
     server->insert("localhost:6667", new IrcServer("localhost"));
  
  if (curNick.isEmpty())
     curNick=nick.first();
  if (curUser.isEmpty())
     curUser=user.first();
  if (curIrcname.isEmpty())
     curIrcname=ircname.first();
  itServer = new QDictIterator<IrcServer>(*server);
  if (!curServer)
     curServer=itServer->current();

  return 1;
}

int ClientConfig::parseConfig(const char* txt)
{
#ifdef EDEBUG
  cout << "ClientConfig::parseConfig:"<<txt<<endl;
#endif
  if (!txt)
     return 0;
  StringToken token(txt, " ");
  QString cmd;
  cmd = token.nextToken();
  for (int i=0;readTab[i].name!=NULL;i++){
      if (!stricmp(cmd,readTab[i].name)){
	 QString t=token.toEnd();
	 return (this->*(readTab[i].func))(t);
      }
  }
  return 0;
}


void ClientConfig::readNick(const char* Line)
{
  StringToken token(Line);
  QString s;
  while((s=token.nextToken()) != NULL){
    if (nick.find(s) < 0)
       nick.inSort(qstrdup(s));
  }
}

void ClientConfig::readCurrentNick(const char* Line)
{
  StringToken token(Line);
  QString s;
  int     id;
  if((s=token.nextToken()) != NULL){
    if ((id=nick.find(s)) < 0){
       nick.inSort(s);
    }
    curNick = s;
  }
}

void ClientConfig::readUser(const char* Line)
{
  StringToken token(Line);
  QString s;
  if((s=token.toEnd()) != NULL)
    if (user.find(s) < 0)
       user.inSort(s);
}

void ClientConfig::readCurrentUser(const char* Line)
{
  StringToken token(Line);
  QString s;
  int     id;
  if((s=token.toEnd()) != NULL){
    if ((id=user.find(s)) < 0){
       user.inSort(s);
    }
    curUser=s;
  }
}

void ClientConfig::readIrcname(const char* Line)
{
  StringToken token(Line);
  QString s;
  if((s=token.toEnd()) != NULL)
    if (ircname.find(s) < 0)
       ircname.inSort(s);
}

void ClientConfig::readCurrentIrcname(const char* Line)
{
  StringToken token(Line);
  QString s;
  int     id;
  if((s=token.toEnd()) != NULL){
    if ((id=ircname.find(s)) < 0){
       ircname.inSort(s);
    }
    curIrcname=s;
  }
}

// server:port:passwd:info
void ClientConfig::readServer(const char* Line)
{
  StringToken token(Line," :");
  QString se,po,pa,in;
  if (!(se=token.nextToken()))
     return;
  if (!(po=token.toToken(":")))
     po="6667";
  if (!(pa=token.toToken(":")))
     pa="";
  if ((in=token.toEnd()) == NULL)
     in="";
  if (server->find(se+":"+po)!=NULL)
     return;
  server->insert(se+":"+po, new IrcServer(se, po.toInt(), pa, in));
}

void ClientConfig::readCurrentServer(const char* Line)
{
  StringToken token(Line," :");
  QString se,po,pa,in;
  if (!(se=token.nextToken()))
     return;
  if (!(po=token.toToken(":")))
     po="6667";
  if (!(pa=token.toToken(":")))
     pa="";
  if ((in=token.toEnd()) == NULL)
     in="";

  if ((curServer=server->find(se+":"+po)) != NULL)
     return;

  IrcServer* is;
  server->insert(se+":"+po, (is=new IrcServer(se, po.toInt(), pa, in)));
  curServer=is;
}

QString ClientConfig::currentNick()
{
  return curNick;
}

IrcServer* ClientConfig::currentServer()
{
  return curServer;
}

int ClientConfig::saveConfig(const char* File)
{
  QString tmp=path;
  if (File)
     tmp=File;
  QFile f(tmp);
  if (!f.open(IO_WriteOnly))
     return 0;
  path = tmp;
  ircapp->writeEntry(entry, path);
  QTextStream ts(&f);
  ts.device()->at(0);
  // currentnick
  ts << "currentnick \t"<< currentNick()<<endl;
  // currentuser
  ts << "currentuser \t"<< curUser<<endl;
  // currentircname
  ts << "currentircname \t"<< curIrcname<<endl;
  // currentserver
  QString ss=curServer->Host()  +":"+
             curServer->Port()  +":"+
             curServer->Passwd()+":"+
             curServer->Info();
  ts << "currentserver "<< ss <<endl;
  ts << endl;

  QString is;
  // nick list
  for (is=nick.first();is;is=nick.next())
      ts << "nick " << is << endl; 

  // user list
  for (is=user.first();is;is=user.next())
      ts << "user " << is << endl; 

  // ircname list
  for (is=ircname.first();is;is=ircname.next())
      ts << "ircname " << is << endl; 

  // server list
  QDictIterator<IrcServer> it(*server);
  IrcServer* cs;
  for (cs=it.current();(cs=it.current())!=0L;++it){
      is=cs->Host()  +":"+
         cs->Port()  +":"+
         cs->Passwd()+":"+
         cs->Info();
      ts << "server " << is << endl;
  }
  return 1;
}
  
