#ifndef __STRING_TOKEN_H__
#define __STRING_TOKEN_H__

#include "qstring.h"

class StringToken 
{
private:
	int     currentPos;
	int     maxPos;
	QString str;      // input String
	QString delimit;  // delim. String
private:
	void Init();
	void skipDelimit();
public:
	StringToken (QString str,   const char* delim=" \n\t\r");
	StringToken (const char* str,const char* delim=" \n\t\r");
	~StringToken();
	bool hasMoreTokens(const char* delim=NULL);
	QString nextToken (const char* delim=NULL);
	QString toToken(const char* token=" ");
	QString toEnd(const char* delim=NULL);
	int countTokens(const char* delim=NULL);
	QString nextToken (const char* delim, int* len);
	QString nextDigit (const char* delim, int* len);
	QString nextInt   (const char* delim, int* len);
};

#endif

