#include <iostream.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>
#include "Socket.h"
#include "Socket.moc"

void Socket::Init()
{
  sd       = -1;
  peerPort = -1;
  localPort= -1;
}

Socket::Socket()
{
  Init();
}


InetAddress Socket::getInetAddress()
{
  return inAddr;
}

InetAddress Socket::getLocalInetAddress()
{
  return localInAddr;
}

int Socket::readData(QString& data, int length)
{
   int  s;
   if (!data.resize(length+1))
      return -1;
   int wlength=0;
   do{
     if ((s=read(sd,&data[wlength],length-wlength))<1){
        close(sd);
	sd=-1;
	emit signError();
        return s;
     }
     wlength+=s;
   }
   while(wlength<length );
   return wlength;
}

int Socket::readLine(QString& data)
{
#ifdef EDEBUG
   cout << "Socket::readLine()"<<endl;
#endif
   int  length=data.size();
   int  i=0;
   int  s;
   do{
     if ((s=read(sd,&data[i],1))<1){
        close(sd);
	sd=-1;
	emit signError();
        return s;
     }
     if (data[i]=='\r')
        data[i]='\0';
     i++;
   }
   while(i<length && data[i-1]!='\n');
   data[i-1]='\0';
   return i;
}

int Socket::readStr(QString& data)
{
   int  length=data.size();
   int  i=0;
   int  s;
   do{
     if ((s=read(sd,&data[i],1))<1){
        close(sd);
	sd=-1;
	emit signError();
        return s;
     }
     i++;
   }
   while(i<length && data[i-1]!='\0');
   data[i-1]='\0';
   return i;
}

int Socket::writeLine(const char* Txt)
{
  if (!Txt)
     return 1;
  int s;
  QString data = Txt;
  data.insert(data.length(),'\n');
  s = write(sd, data, data.length());
  if (s<1)
     emit signError();
  else
     emit signText(Txt);
  return s;
}

int Socket::getSocket()
{
  return sd;
}

int Socket::getLocalPort()
{
  return localPort;
}

int Socket::getPeerPort()
{
  return peerPort;
}








