#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>
#include "ClientSocket.h"
#include "ServerSocket.h"
#include "ServerSocket.moc"

ServerSocket::ServerSocket(int port) : Socket()
{
  sn = NULL;
  localPort = port;
}

ServerSocket::~ServerSocket()
{
  Close();
}

int ServerSocket::Open(const char* Host, int port)
{
   struct  sockaddr_in sockAddrIn;
   if (!localInAddr.forHost(Host))
     return -1;
   if (port>=0)
      localPort=port;
   if (localPort < 0)
      return -1;

   bzero((char *) &sockAddrIn, sizeof(sockAddrIn));
   sockAddrIn.sin_family = localInAddr.getFamily();
   sockAddrIn.sin_port   = htons(localPort);
   if (stricmp(Host, "localhost"))
      sockAddrIn.sin_addr.s_addr = localInAddr.getAddress();
   else
      sockAddrIn.sin_addr.s_addr = INADDR_ANY;

   if ((sd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
      return -1;
   if (sd == 0)
       sd = ::dup(sd);
   if ((bind(sd, (struct sockaddr *) &sockAddrIn, sizeof(sockAddrIn)) < 0) ||
       (listen(sd, 1000) < 0) ) {
      Close();
      return -1;
   }
   // Port noch mal zuordnen, wenn Port = 0, dann wird neue Portnummer zugewiesen
   int size=sizeof(sockAddrIn);
   getsockname(sd, (struct sockaddr*)&sockAddrIn, &size );
   localPort = ntohs(sockAddrIn.sin_port);
   sn=new QSocketNotifier(sd, QSocketNotifier::Read, this);
   QObject::connect(sn, 
		    SIGNAL(activated   (int)), 
		    this, 
		    SLOT  (slotAccept(int)));
   return sd;
}

void ServerSocket::Close()
{
  delete sn;
  sn = NULL;
  if (sd!=-1){
     ::close(sd);
     sd=-1;
  }
  localPort=-1;
}

void ServerSocket::slotAccept(int)
{
  sockaddr_in sockAddrIn;
  int size = sizeof(sockAddrIn);
  int as = accept(sd, (struct sockaddr*)&sockAddrIn, &size);
  if (as < 0)
     return;

  ClientSocket* cs= new ClientSocket(as);
  emit signAccept(cs);
}





