#include <iostream.h>
#include "StringToken.h"
#include "ircClient.h"
#include <qlayout.h>
#include <qtooltip.h> 
#include "isonPage.h"
#include "whoisDialog.h"
#include "ircApp.h"

WhoisDialog::WhoisDialog(IrcClient* client, QWidget* parent, const char* Name):
  QDialog(parent, Name, false)
{
  mClient   = client;
  mUserList = new QDict<IrcUser>(10, FALSE, TRUE);
  mUserList->setAutoDelete(true);

  mPanner  = new KNewPanner (this,"Panner", KNewPanner::Vertical, KNewPanner::Absolute);
  mPanner->setSeparatorPos(95);

  mPageWidget = new QWidget  (mPanner,"pageWidget");
  mTreeList   = new KTreeList(mPanner,"treeList");
  mTreeList->raise();
  mTreeList->setTreeDrawing(TRUE);
  mTreeList->setExpandButtonDrawing(TRUE);
  mTreeList->setScrollBar(TRUE);

  mPanner->activate(mTreeList, mPageWidget);

  connect(mTreeList,  
	  SIGNAL(highlighted(int)),
	  this,      
	  SLOT  (slotSetPage(int))); 

  QVBoxLayout* vbox=new QVBoxLayout(mPageWidget);
  mHtml = new IrcHtml(mPageWidget, "WhoisDialog");
  vbox->addWidget(mHtml, 10);

  vbox->addSpacing(10);
  QHBoxLayout* hbox=new QHBoxLayout;
  vbox->addLayout(hbox);
  hbox->addSpacing(10);
  QPushButton* btn;
  btn = new QPushButton("Add Friend", mPageWidget);
  hbox->addWidget(btn);
  btn->setFixedSize(75, 24);
  connect(btn, SIGNAL(clicked()), SLOT(slotAddFriend()));

  mEditFriend = new QLineEdit(mPageWidget);
  hbox->addWidget(mEditFriend);
  mEditFriend->setFixedSize(75, 24);
  QToolTip::add(mEditFriend, " Friendlevel and channel to add friendlist");
  
  hbox->addSpacing(5);
  btn = new QPushButton("Add Ison", mPageWidget);
  hbox->addWidget(btn);
  btn->setFixedSize(75, 24);
  connect(btn, SIGNAL(clicked()), SLOT(slotAddIson()));

  hbox->addStretch(10);

  vbox->addSpacing(2);
  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);
  hbox->addSpacing(10);

  btn = new QPushButton("Add Ban", mPageWidget);
  hbox->addWidget(btn);
  btn->setFixedSize(75, 24);
  connect(btn, SIGNAL(clicked()), SLOT(slotAddBan()));

  mEditBan = new QLineEdit(mPageWidget);
  hbox->addWidget(mEditBan);
  mEditBan->setFixedSize(75, 24);
  QToolTip::add(mEditBan, " Banlevel and channel to add banlist ");
  hbox->addStretch(10);

  vbox->addSpacing(2);
  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);
  hbox->addSpacing(10);

  btn = new QPushButton("Add Ignore", mPageWidget);
  hbox->addWidget(btn);
  btn->setFixedSize(75, 24);
  connect(btn, SIGNAL(clicked()), SLOT(slotAddIgnore()));

  mEditIgnore = new QLineEdit(mPageWidget);
  hbox->addWidget(mEditIgnore);
  mEditIgnore->setFixedSize(75, 24);
  QToolTip::add(mEditIgnore, " Flag and Time in seconds to add ignorelist ");
  hbox->addStretch(10);
  
  vbox->addSpacing(2);
  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);
  hbox->addSpacing(10);

  btn = new QPushButton("Delete", mPageWidget);
  hbox->addWidget(btn);
  btn->setFixedSize(75, 24);
  connect(btn, SIGNAL(clicked()), SLOT(slotDelete()));

  btn = new QPushButton("Clear", mPageWidget);
  hbox->addWidget(btn);
  btn->setFixedSize(75, 24);
  connect(btn, SIGNAL(clicked()), SLOT(slotClear()));

  hbox->addSpacing(5);
  btn = new QPushButton("Ok", mPageWidget);
  hbox->addWidget(btn);
  btn->setFixedSize(75, 24);
  connect(btn, SIGNAL(clicked()), SLOT(slotOk()));

  hbox->addStretch(10);

  vbox->addSpacing(5);
  vbox->activate();

  setMinimumSize(500, 300);
  readConfig();
  setCaption("Whois Dialog");
}

WhoisDialog::~WhoisDialog()
{
  delete mUserList;
}

void WhoisDialog::resizeEvent(QResizeEvent*)
{
  mPanner->setGeometry(0, 0,
		       width(), height());
}

void WhoisDialog::readConfig()
{
  QString val;
  val = ircapp->readEntry("AddFriendArgument", "100 *");
  mEditFriend->setText(val);
  val = ircapp->readEntry("AddBanArgument",    "100 *");
  mEditBan->setText(val);
  val = ircapp->readEntry("AddIgnoreArgument", "pcnftis  120");
  mEditIgnore->setText(val);
}

IrcUser* WhoisDialog::getIrcUser(int idx)
{
  if (idx==-1)
     idx = mTreeList->currentItem();
  if (idx<0)
     return 0L;
  KTreeListItem* item = mTreeList->itemAt(idx);
  if (item==0L)
     return 0L;

  QString s = item->getText();
  return mUserList->find(s);
}

int WhoisDialog::getIdx(const char* nick)
{
  KTreeListItem* item;
  for (uint i=0;i<mTreeList->count();i++){
     item = mTreeList->itemAt(i);
     if (!stricmp(nick, item->getText())){
	return i;
     }
  } 
  return -1;
}

void WhoisDialog::slotSetPage(int idx)
{
#ifdef EDEBUG
  cout << "WhoisDialog::slotSetPage:"<<idx<<endl;
#endif
  
  IrcUser* iu=getIrcUser(idx);
  if (iu==0L)
     return;
  mHtml->slotSetFlag(FLAG_CLEAR, 0);
  QString s;
  s = iu->nick()+" is "+iu->user()+"@"+iu->host();
  mHtml->slotWrite(TYPE_INFO|TYPE_IMG, s, true);
  s = "ircname "+iu->info();
  mHtml->slotWrite(TYPE_INFO|TYPE_IMG, s, true);
  if (!iu->server().isEmpty()){
     s = "Connecting server : "+iu->server();
     mHtml->slotWrite(TYPE_INFO|TYPE_IMG, s, true);
  }
}

void WhoisDialog::slotAddIgnore()
{
  IrcUser* iu=getIrcUser();
  if (iu==0L)
     return;

  StringToken st(mEditIgnore->text());
  QString l=st.nextToken();
  QString c=st.nextToken();
  if (l.isEmpty())
     l="pcnftis";
  if (c.isEmpty())
     c="120";

  QString k="*!*"+iu->user()+"@"+iu->host();
  mClient->ignList->addUser(k, l, c.toInt());
}

void WhoisDialog::slotAddFriend()
{
  IrcUser* iu=getIrcUser();
  if (iu==0L)
     return;

  StringToken st(mEditFriend->text());
  QString l=st.nextToken();
  QString c=st.nextToken();
  if (l.isEmpty())
     l="100";
  if (c.isEmpty())
     c="*";

  QString k="*!*"+iu->user()+"@"+iu->host();
  mClient->friendList->addUser(k, l.toInt(), c);
}

void WhoisDialog::slotAddBan()
{
  IrcUser* iu=getIrcUser();
  if (iu==0L)
     return;

  StringToken st(mEditBan->text());
  QString l=st.nextToken();
  QString c=st.nextToken();
  if (l.isEmpty())
     l="100";
  if (c.isEmpty())
     c="*";

  QString k=mClient->makeBan(iu->nick());
  mClient->banList->addUser(k, l.toInt(), c);
}

void WhoisDialog::slotAddIson()
{
  IrcUser* iu=getIrcUser();
  if (iu==0L)
     return;
  IsonPage* iop = (IsonPage*)mClient->optPrefDlg->getPage("Ison");
  if (iop==0L){
     QString s="Can not find Ison page";
     mClient->slotWriteMsg(TYPE_ERROR|TYPE_IMG, s);
     return;
  }
  iop->addUser(iu->nick());
}

void WhoisDialog::slotDelete()
{
  int idx     = mTreeList->currentItem();
  if (idx<0)
     return;
  IrcUser* iu = getIrcUser(idx);
  if (iu==0L)
     return;
  mTreeList->removeItem(idx);
  mUserList->remove(iu->nick());

  idx = mTreeList->currentItem();
  if (idx>=0)
     slotSetPage(idx);
}


void WhoisDialog::slotClear()
{
  mTreeList->clear();
  mUserList->clear();
}

void WhoisDialog::slotOk()
{
  accept();
}

void WhoisDialog::show()
{
  QPoint p=pos();
  move(p);
  if (isVisible())
     raise();
  else
     QDialog::show();
}

void WhoisDialog::addIrcUser(IrcUser* iu)
{
  IrcUser* ciu=mUserList->find(iu->nick());
  if (ciu==0L){
     mUserList->insert    (iu->nick(), iu);
     mTreeList->insertItem(iu->nick(), 0, -1);
     mTreeList->setCurrentItem(mTreeList->count()-1);
  }
  else{
     int idx=getIdx(iu->nick());
     if (idx>=0)
        mTreeList->setCurrentItem(idx);
     ciu->setUser(iu->user());
     ciu->setHost(iu->host());
     ciu->setInfo(iu->info());
     delete iu;
  }
  if (!iu->server().isEmpty())
     show();
}

void WhoisDialog::setServer(const char* nick, const char* server)
{
  IrcUser* iu = mUserList->find(nick);
  if (iu==0L)
     return;
  iu->setServer(server);
  int idx=getIdx(iu->nick());
  if (idx>=0){
     mTreeList->setCurrentItem(idx);
     slotSetPage(idx);
  }
  if (!isVisible())
     show();
}

#include "whoisDialog.moc"
