/***************************************************************************
                          parser.cpp  -  description                              
                             -------------------                                         
    begin                : Tue Aug 10 1999                                           
    copyright            : (C) 1999 by Guenter Schwann                         
    email                : vogel@ibk.dyn.priv.at                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <qfile.h>
#include <qtextstream.h>
#include <qstring.h>
#include <qfileinfo.h>
#include <qstrlist.h>

#include "parser.h"

Parser::Parser()
{
 defaults(1);
 acserv=0;
}

Parser::~Parser()
{
}


void Parser::ReadConfig( QString filen )
{
 QFile f(filen);
 if ( f.open(IO_ReadOnly) ) // file opened successfully
 {
  acserv=0;
  QString s;
  QTextStream t( &f );        // use a text stream
  while ( !t.eof() ) // until end of file...
  {
   s = t.readLine();       // line of text excluding '\n'
   pars(s);
  }
 f.close();
 }
}

void Parser::WriteConfig()
{
}


void Parser::SearchCFile()
{
 QFileInfo *finfo;

 finfo = new QFileInfo("/etc/leafnode/config");
 if (finfo->exists()) cfilename="/etc/leafnode/config";
 delete( finfo );
 finfo = new QFileInfo("/var/spool/news/config");
 if (finfo->exists()) cfilename="/var/spool/news/config";
 delete( finfo );

}

QString Parser::DelSpace(QString qs)
{
 int i;
 i=qs.find(' ');
 while ( i!=-1 )
 {
  qs.remove(i, 1);
  i=qs.find(' ');
 }
 return qs;
}

void Parser::defaults(int i)
{
 if (i=1) cfilename="";
 expire=14;
 for (i=0;i<10;i++)
 {
  serv[i].setName("");
  serv[i].setUser("");
  serv[i].setPasswd("");
  serv[i].setPort(119);
  serv[i].setTimeout(10);
  serv[i].setNodesc(false);
 }

 max_fetch=0;
 initial_fetch=0;
 delay_body=0;
 max_cross=0;
 max_age=0;
 max_lines=0;
 min_lines=0;
 max_bytes=0;
 timeout_short=0;
 timeout_long=0;
 timeout_active=0;
 create_links=0;

}

int Parser::pars(QString s)
{
 int i;
 QString s1, s2;

//delete all comments and whitespaces
 i=s.find('#');
 if (i!=-1) s1=s.left(i);
 else s1=s;
 s2=DelSpace(s1);

 if (s2.contains("server=")>0)
 {
  serv[acserv].setName(s2.right(s2.length()-7));
  return 1;
 }
 if (s2.contains("supplement=")>0)
 {
  acserv++;
  serv[acserv].setName(s2.right(s2.length()-11));
  return 1;
 }
 if (s2.contains("expire=")>0)
 {
  s2=s2.right(s2.length()-7);
  expire=s2.toInt();
  return 1;
 }

//attention! maybe 2 servers!
 if (s2.contains("username=")>0)
 {
  serv[acserv].setUser(s2.right(s2.length()-9));
  return 1;
 }
 if (s2.contains("password=")>0)
 {
  serv[acserv].setPasswd(s2.right(s2.length()-9));
  return 1;
 }
 if (s2.contains("port=")>0)
 {
  s2=s2.right(s2.length()-5);
  serv[acserv].setPort(s2.toInt());
  return 1;
 }
 if (s2.contains("timeout=")>0)
 {
  s2=s2.right(s2.length()-8);
  serv[acserv].setTimeout(s2.toInt());
  return 1;
 }
 if (s2.contains("nodesc=")>0)
 {
  s2=s2.right(s2.length()-7);
  serv[acserv].setNodesc(s2.toInt());
  return 1;
 }

//generall options
 if (s2.contains("maxfetch=")>0)
 {
  s2=s2.right(s2.length()-9);
  max_fetch=s2.toInt();
  return 1;
 }
 if (s2.contains("initialfetch=")>0)
 {
  s2=s2.right(s2.length()-13);
  initial_fetch=s2.toInt();
  return 1;
 }
 if (s2.contains("maxcrosspost=")>0)
 {
  s2=s2.right(s2.length()-13);
  max_cross=s2.toInt();
  return 1;
 }
 if (s2.contains("maxage=")>0)
 {
  s2=s2.right(s2.length()-7);
  max_age=s2.toInt();
  return 1;
 }
 if (s2.contains("maxlines=")>0)
 {
  s2=s2.right(s2.length()-9);
  max_lines=s2.toInt();
  return 1;
 }
 if (s2.contains("minlines=")>0)
 {
  s2=s2.right(s2.length()-9);
  min_lines=s2.toInt();
  return 1;
 }
 if (s2.contains("maxbytes=")>0)
 {
  s2=s2.right(s2.length()-9);
  max_bytes=s2.toInt();
  return 1;
 }
 if (s2.contains("timeout_short=")>0)
 {
  s2=s2.right(s2.length()-14);
  timeout_short=s2.toInt();
  return 1;
 }
 if (s2.contains("timeout_long=")>0)
 {
  s2=s2.right(s2.length()-13);
  timeout_long=s2.toInt();
  return 1;
 }
 if (s2.contains("timeout_active=")>0)
 {
  s2=s2.right(s2.length()-15);
  timeout_active=s2.toInt();
  return 1;
 }
 if (s2.contains("create_all_links=")>0)
 {
  s2=s2.right(s2.length()-17);
  create_links=s2.toInt();
  return 1;
 }
 if (s2.contains("groupexpire")>0)
 {
  i=s2.find("=");
  groupex.append(s2.mid(11,i-11));
  extime.append(s2.right(s2.length()-i-1));
  return 1;
 }
 if (s2.contains("hostname=")>0)
 {
  hostn=s2.right(s2.length()-9);
  return 1;
 }
 if (s2.length()>1)
 {
  utags.append(s2);
  return 2;
 }
 return 0;
}


QString Parser::CFileName()
{
 return cfilename;
}

void Parser::setCFileName(QString cfile)
{
 cfilename=cfile;
}

int Parser::ExpireTime()
{
 return expire;
}

server Parser::getServer(int i)
{
 return serv[i];
}

int Parser::MaxFetch()
{
 return max_fetch;
}

int Parser::InitialFetch()
{
 return initial_fetch;
}

int Parser::DelayBody()
{
 return delay_body;
}

int Parser::MaxCrossPost()
{
 return max_cross;
}

int Parser::MaxAge()
{
 return max_age;
}

int Parser::MaxLines()
{
 return max_lines;
}

int Parser::MinLines()
{
 return min_lines;
}

int Parser::MaxBytes()
{
 return max_bytes;
}

int Parser::TimeoutShort()
{
 return timeout_short;
}

int Parser::TimeoutLong()
{
 return timeout_long;
}

int Parser::TimeoutActive()
{
 return timeout_active;
}

int Parser::CreateLinks()
{
 return create_links;
}

QStrList Parser::ExpireGroups()
{
 return groupex;
}

QStrList Parser::ExpireTimes()
{
 return extime;
}

QString Parser::Hostname()
{
 return hostn;
}


QStrList Parser::UTags()
{
 return utags;
}


