/************************************************************
        Copyright (c) 1998 Karl Backstrm

        This code is under GPL - see COPYING.
************************************************************/

#ifndef __SCOPEDIALOG_H__
#define __SCOPEDIALOG_H__

#include "dhcp.h"
#include <qdialog.h>
#include <qpushbt.h>
#include <qlined.h>
#include <qlistbox.h>
#include <qstring.h>
#include <qstrlist.h>
#include <qgroupbox.h>
#include <qradiobutton.h>
#include <kspinbox.h>
#include <qbuttongroup.h>
#include <qlabel.h>

class scopeDialog : public QDialog
{
    Q_OBJECT
public:
    scopeDialog(scopeAddresses *sa, QWidget* parent, const char* name);
    virtual ~scopeDialog();
protected slots:
    void Help_Click();
    void OK_Click();
    void Cancel_Click();
    void Add_Click();
    void Remove_Click();
    void Advanced_Click();

    void Subnet_change1(const char *);
    void Subnet_change2(const char *);
    void Subnet_change3(const char *);
    void Subnet_change4(const char *);
    void Ex_Start_IP_change1(const char *);
    void Ex_Start_IP_change2(const char *);
    void Ex_Start_IP_change3(const char *);
    void Ex_Start_IP_change4(const char *);
    void Ex_End_IP_change1(const char *);
    void Ex_End_IP_change2(const char *);
    void Ex_End_IP_change3(const char *);
    void Ex_End_IP_change4(const char *);
private:
    scopeAddresses *sac;
protected:
     void init();
     void update();
     QString getIP(int a,const char *text);
     QString putIP(QString a, QString b, QString c, QString d);

     int tmpint;
     
     QString caption;
     // IP Address Pool
    int widthSize, buttonSize, domainSize;
    QGroupBox *IP_poolBox, *LeasesBox, *MaxLeasesBox;
    QLabel *Subnet_Label;
    QLineEdit *Subnet_Edit1, *Subnet_Edit2, *Subnet_Edit3, *Subnet_Edit4;
    QLabel *Mask_Label;
    QLineEdit *Mask_Edit1, *Mask_Edit2, *Mask_Edit3, *Mask_Edit4;
    QLabel *Routers_Label;
    QLineEdit *Routers_Edit;
    QLabel *DomainName_Label;
    QLineEdit *DomainName_Edit;
    QLabel *NameServers_Label;
    QLineEdit *NameServers_Edit;
    QLabel *NetbiosNameServers_Label;
    QLineEdit *NetbiosNameServers_Edit;


    QLabel *Range_Label;
    QLabel *Ex_Start_IP_Label;
    QLineEdit *Ex_Start_IP_Edit1, *Ex_Start_IP_Edit2, *Ex_Start_IP_Edit3, *Ex_Start_IP_Edit4;
    QLabel *Ex_End_IP_Label;
    QLineEdit *Ex_End_IP_Edit1, *Ex_End_IP_Edit2, *Ex_End_IP_Edit3, *Ex_End_IP_Edit4;
    QPushButton *AddButton, *RemoveButton;
    QListBox *excludeBox;
    QLabel *exclude_Label;

    // Lease Duration
    int radioSize;
    QRadioButton *Default_Radio, *Unlimited_Radio, *Limited_Radio;
    QButtonGroup *bg;
    KNumericSpinBox *daySpinBox, *hourSpinBox, *minSpinBox;
    QLabel *dayLabel, *hourLabel, *minLabel;

    //Max Lease Duration
    QRadioButton *Default_Radio2, *Unlimited_Radio2, *Limited_Radio2;
    QButtonGroup *bg2;
    KNumericSpinBox *daySpinBox2, *hourSpinBox2, *minSpinBox2;
    QLabel *dayLabel2, *hourLabel2, *minLabel2;

    QPushButton *Ok_Button, *Cancel_Button, *Advanced_Button, *Help_Button;
};

#endif
