/************************************************************
        Copyright (c) 1998-1999 Karl Backstrm

        This code is under GPL - see COPYING.
************************************************************/

#include "dhcp.h"

void DhcpWidget::init()
{
  parseconf();
  displaySettings();
}

void DhcpWidget::readStat()
{
}

void DhcpWidget::parseconf()
{
  char tmp[70000];
  QString st,st1,st2, st3;
  scopeAddresses *sa;
  scopeList = new QList<scopeAddresses>();
  int s1, s2, s3, times;

  QFile configFile( "/etc/dhcpd.conf" );
  QString configData, currentRow;
  QList< QString > parameterList;
  QString *parameterListItemToRemove;
  int i, i2;

      parameterList.setAutoDelete( TRUE );      
      configFile.open( IO_ReadOnly );
      configFile.readBlock( tmp, configFile.size() );
      configFile.close();
      configData = tmp;
      while ( configData.find( '\t' ) != -1 ) //replace all tabs with whitespace.
	{
	  i = configData.find( '\t' );
	  configData.replace( i, 1, " " );
	}

      while ( configData.find( '#' ) != -1 ) // Remove these #
	{
	  i = configData.find( '#' );
	  i2 = configData.find( '\n', i);
	  configData.remove(i, (i2-i));
	}
      
      while ( configData.find( ';' ) != -1 ) // Remove this ;
	{
	  i = configData.find( ';' );
	  configData.remove(i, 1);
	}

      while ( configData.find( '\"' ) != -1 ) // Remove this "
	{
	  i = configData.find( '\"' );
	  configData.remove(i, 1);
	}

      if(configData.find("}") > -1 )
	{
	  s1 = configData.find("}");
	  s2 = configData.find("{");
	  if(configData.find("{",(s2+1)) != -1)
	    {
	      s2 = configData.find("{",(s2+1));
	      if(s2>s1) {}
	      else
		{
		  times = 1;
		  while(times != 0 && s1 != -1) //||
		    {
		      s3 = s1;
		      s1 = configData.find("}",(s3+1));
		      s2 = configData.find("{",(s3+1));
		      if(s2>s1) --times;
		    }
		}
	      if(0 >= s1)
		s1 = configData.length() - 2;
	    }
	  
	  currentRow = ( const char * ) configData.left((s1+1));
	  configData = ( const char * ) configData.right( configData.length() - (s1+2));
	  currentRow = currentRow.simplifyWhiteSpace();
	}
      else 
	{
	  currentRow = 0;
	}
      
      for( i = 0; currentRow.find( " " ) != - 1; i++ )
	{
	  parameterList.append( new QString( ( const char * ) currentRow.left( currentRow.find( " " ) ) ) );
	  currentRow = ( const char * ) currentRow.right( currentRow.length() - currentRow.find( " " ) - 1 );
	}
      parameterList.append( new QString( ( const char * ) currentRow ) ); 

      while ( currentRow.isEmpty() != true )
	{
	  if ( strcmp( ( const char * ) *parameterList.first(), "server-identifier" ) == 0 )
	    { 
	      parameterList.removeFirst();
	      parameterList.removeFirst();
	    }
	  if ( strcmp( ( const char * ) *parameterList.first(), "deny" ) == 0 )
	    { 
	      parameterList.removeFirst();
	      parameterList.removeFirst();
	    }
	  else if ( strcmp( ( const char * ) *parameterList.first(), "allow" ) == 0 )
	    {
	      parameterList.removeFirst();
	      parameterList.removeFirst();
	    }

	  if ( strcmp( ( const char * ) *parameterList.first(), "subnet" ) == 0 )
	    {
	      QString *tmp1 = parameterList.next();
	      QString *tmp = parameterList.next();
	      tmp = parameterList.next();
	      sa = new scopeAddresses((const char*)*tmp1, (const char*)*tmp );
	      scopeList->append(sa);
	      
	      tmp = parameterList.next();
	      while ( tmp != 0 )
		{
		  if (strcmp( ( const char * ) *tmp, "{" ) == 0 )
		    {
		    }
		  else if ( strcmp( ( const char * ) *tmp, "option" ) == 0 )
		    {
		      tmp = parameterList.next();
		      if ( strcmp( ( const char * ) *tmp, "domain-name" ) == 0 )
			{
			  tmp = parameterList.next();
			  sa->domainName = (const char*)*tmp;
			}
		      else if ( strcmp( ( const char * ) *tmp, "domain-name-servers" ) == 0 )
			{
			  tmp = parameterList.next();
			  sa->nameServers = (const char*)*tmp;
			  while(tmp->find(QRegExp("\\,$")) > 0) 
			    {
			      tmp = parameterList.next();
			      sa->nameServers.append((const char*)*tmp);
			    }
			}
		      else if ( strcmp( ( const char * ) *tmp, "routers" ) == 0 )
			{
			  tmp = parameterList.next();
			  sa->routers = ( const char * ) *tmp;
			  while(tmp->find(QRegExp("\\,$")) > 0) 
			    {
			      tmp = parameterList.next();
			      sa->routers.append((const char*)*tmp);
			    }
			}
		      else if ( strcmp( ( const char * ) *tmp, "netbios-name-servers" ) == 0 )
			{
			  tmp = parameterList.next();
			  sa->netbiosNameServers = ( const char * ) *tmp;
			  while(tmp->find(QRegExp("\\,$")) > 0) 
			    {
			      tmp = parameterList.next();
			      sa->netbiosNameServers.append((const char*)*tmp);
			    }
			}
		      else if ( strcmp( ( const char * ) *tmp, "netbios-dd-server" ) == 0 )
			{
			  tmp = parameterList.next();
			  sa->netbiosDDServer = ( const char * ) *tmp;
			  while(tmp->find(QRegExp("\\,$")) > 0) 
			    {
			      tmp = parameterList.next();
			      sa->netbiosDDServer.append((const char*)*tmp);
			    }
			}
		      else if ( strcmp( ( const char * ) *tmp, "netbios-node-type" ) == 0 )
			{
			  tmp = parameterList.next();
			  sa->netbiosNodeType = tmp->toInt();
			}
		      else if ( strcmp( ( const char * ) *tmp, "subnet-mask" ) == 0 )
			{
			  tmp = parameterList.next();
			  //sa->netbiosDDServer = ( const char * ) *tmp;
			}
		      else if ( strcmp( ( const char * ) *tmp, "broadcast-address" ) == 0 )
			{
			  tmp = parameterList.next();
			  sa->broadcastAddress = ( const char * ) *tmp;
			}
		      else if ( strcmp( ( const char * ) *tmp, "time-offset" ) == 0 )
			{
			  tmp = parameterList.next();
			  sa->timeOffset = tmp->toInt();
			}
		      else if ( strcmp( ( const char * ) *tmp, "ip-forwarding" ) == 0 )
			{
			  tmp = parameterList.next();
			  sa->ipForward = yes_no(( const char * ) *tmp);
			}
		      else if ( strcmp( ( const char * ) *tmp, "nis-domain" ) == 0 )
			{
			  tmp = parameterList.next();
			  sa->nisDomain = ( const char * ) *tmp;
			}
		      else if ( strcmp( ( const char * ) *tmp, "nis-servers" ) == 0 )
			{
			  tmp = parameterList.next();
			  sa->nisServers = ( const char * ) *tmp;
			  while(tmp->find(QRegExp("\\,$")) > 0) 
			    {
			      tmp = parameterList.next();
			      sa->nameServers.append((const char*)*tmp);
			    }
			}
		      else if ( strcmp( ( const char * ) *tmp, "x-display-manager" ) == 0 )
			{
			  tmp = parameterList.next();
			  sa->displayManager = ( const char * ) *tmp;
			  while(tmp->find(QRegExp("\\,$")) > 0) 
			    {
			      tmp = parameterList.next();
			      sa->displayManager.append((const char*)*tmp);
			    }
			}
		      else if ( strcmp( ( const char * ) *tmp, "font-servers" ) == 0 )
			{
			  tmp = parameterList.next();
			  sa->fontServers = ( const char * ) *tmp;
			  while(tmp->find(QRegExp("\\,$")) > 0) 
			    {
			      tmp = parameterList.next();
			      sa->fontServers.append((const char*)*tmp);
			    }
			}
		      else if ( strcmp( ( const char * ) *tmp, "ntp-servers" ) == 0 )
			{
			  tmp = parameterList.next();
			  sa->ntpServers = ( const char * ) *tmp;
			  while(tmp->find(QRegExp("\\,$")) > 0) 
			    {
			      tmp = parameterList.next();
			      sa->ntpServers.append((const char*)*tmp);
			    }
			}
		      else if ( strcmp( ( const char * ) *tmp, "swap-server" ) == 0 )
			{
			  tmp = parameterList.next();
			  sa->swapServer = ( const char * ) *tmp;
			}
		      else if ( strcmp( ( const char * ) *tmp, "impress-servers" ) == 0 )
			{
			  tmp = parameterList.next();
			  sa->impressServers = ( const char * ) *tmp;
			  while(tmp->find(QRegExp("\\,$")) > 0) 
			    {
			      tmp = parameterList.next();
			      sa->impressServers.append((const char*)*tmp);
			    }
			}
		      else if ( strcmp( ( const char * ) *tmp, "resource-location-servers" ) == 0 )
			{
			  tmp = parameterList.next();
			  sa->resourceLocationServers = ( const char * ) *tmp;
			  while(tmp->find(QRegExp("\\,$")) > 0) 
			    {
			      tmp = parameterList.next();
			      sa->resourceLocationServers.append((const char*)*tmp);
			    }
			}
		      else if ( strcmp( ( const char * ) *tmp, "lpr-servers" ) == 0 )
			{
			  tmp = parameterList.next();
			  sa->lprServers = ( const char * ) *tmp;
			  while(tmp->find(QRegExp("\\,$")) > 0) 
			    {
			      tmp = parameterList.next();
			      sa->lprServers.append((const char*)*tmp);
			    }
			}
		      else if ( strcmp( ( const char * ) *tmp, "cookie-servers" ) == 0 )
			{
			  tmp = parameterList.next();
			  sa->cookieServers = ( const char * ) *tmp;
			  while(tmp->find(QRegExp("\\,$")) > 0) 
			    {
			      tmp = parameterList.next();
			      sa->cookieServers.append((const char*)*tmp);
			    }
			}
		      else if ( strcmp( ( const char * ) *tmp, "log-servers" ) == 0 )
			{
			  tmp = parameterList.next();
			  sa->logServers = ( const char * ) *tmp;
			  while(tmp->find(QRegExp("\\,$")) > 0) 
			    {
			      tmp = parameterList.next();
			      sa->logServers.append((const char*)*tmp);
			    }
			}
		      else if ( strcmp( ( const char * ) *tmp, "ien116-name-servers" ) == 0 )
			{
			  tmp = parameterList.next();
			  sa->ien116nameServers = ( const char * ) *tmp;
			  while(tmp->find(QRegExp("\\,$")) > 0) 
			    {
			      tmp = parameterList.next();
			      sa->ien116nameServers.append((const char*)*tmp);
			    }
			}
		      else if ( strcmp( ( const char * ) *tmp, "time-servers" ) == 0 )
			{
			  tmp = parameterList.next();
			  sa->timeServers = ( const char * ) *tmp;
			  while(tmp->find(QRegExp("\\,$")) > 0) 
			    {
			      tmp = parameterList.next();
			      sa->timeServers.append((const char*)*tmp);
			    }
			}
		    }
		  else if ( strcmp( ( const char * ) *tmp, "range" ) == 0 )
		    {
		      tmp = parameterList.next();
		      tmp1 = parameterList.next();
		      tmp->append("-");
		      tmp->append((const char*) *tmp1);
		      sa->include->append(( const char * ) *tmp);
		    }
		  else if ( strcmp( ( const char * ) *tmp, "default-lease-time" ) == 0 )
		    {
		      tmp = parameterList.next();
		      sa->leaseDurations = tmp->toInt();
		    }
		  else if ( strcmp( ( const char * ) *tmp, "max-lease-time" ) == 0 )
		    {
		      tmp = parameterList.next();
		      sa->maxLeaseDurations = tmp->toInt();
		    }
		  else if (strcmp( ( const char * ) *tmp, "}" ) == 0 )
		    {
		    }
		  else
		    {
		      debug("Can't understand this (yet):");
		      debug(( const char * ) *tmp);
		    }
		  tmp = parameterList.next();
		}
	    }
	  else if ( strcmp( ( const char * ) *parameterList.first(), "group" ) == 0 )
	    {
	    }
	  for ( parameterListItemToRemove = parameterList.first(); //Clear the list.
		parameterListItemToRemove != 0;
		parameterListItemToRemove = parameterList.first() )
	    {
	      parameterList.remove( parameterListItemToRemove );
	    }
	  if(configData.find("}") > -1 )
	    {
	      s1 = configData.find("}");
	      s2 = configData.find("{");
	      if(configData.find("{",(s2+1)) != -1)
		{
		  s2 = configData.find("{",(s2+1));
		  if(s2>s1) {}
		  else
		    {
		      times = 1;
		      while(times != 0 && s1 != -1) //||
			{
			  s3 = s1;
			  s1 = configData.find("}",(s3+1));
			  s2 = configData.find("{",(s3+1));
			  if(s2>s1) --times;
			}
		    }
		  if(0 >= s1)
		  s1 = configData.length() - 2;
		}
		
	      currentRow = ( const char * ) configData.left((s1+1));
	      configData = ( const char * ) configData.right( configData.length() - (s1+2));
	      currentRow = currentRow.simplifyWhiteSpace();
	    }
	  else 
	    {
	      currentRow = 0;
	    }
	  for( i = 0; currentRow.find( " " ) != - 1; i++ )
	    {
	      parameterList.append( new QString( ( const char * ) currentRow.left( currentRow.find( " " ) ) ) );
	      currentRow = ( const char * ) currentRow.right( currentRow.length() - currentRow.find( " " ) - 1 );
	    }
	  parameterList.append( new QString( ( const char * ) currentRow ) );
	}
      //exit(0);
}

void DhcpWidget::parselog()
{
}


void DhcpWidget::displaySettings()
{
  scopeAddresses *sa;
  scopes->clear();
  for (sa=scopeList->first();sa!=0;sa=scopeList->next()) {
    scopes->insertItem(sa->subnet);
    
  } 
}

bool DhcpWidget::yes_no(const char *text)
{
  if ( strcmp( text, "yes" ) == 0 )
    return(true);
  else if ( strcmp( text, "true" ) == 0 )
    return(true);
  else if ( strcmp( text, "1" ) == 0 )
     return(true);
  else if ( strcmp( text, "on" ) == 0 )
    return(true);
  else
     return(false);
}




