/* $Id: kgetoptdlg.cpp,v 1.1.1.1 1999/02/10 18:16:34 koss Exp $
   $Log: kgetoptdlg.cpp,v $
   Revision 1.1.1.1  1999/02/10 18:16:34  koss
   Imported sources

   Revision 1.4  1999/02/07 17:14:40  matt
   updated for new setting dialogs


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <qlayout.h>

#include <kapp.h>
#include <klocale.h>

#include "preferences.h"

#include "dlgConnection.h"
#include "dlgProxy.h"
#include "dlgAutomation.h"
#include "dlgLimits.h"
#include "dlgAdvanced.h"
#include "dlgDirectories.h"
#include "dlgSystem.h"


PreferencesDlg::PreferencesDlg(QWidget *parent, const char *name, WFlags f)
  : QTabDialog(parent, name, true, f)
{
  // my name is
  setCaption(i18n("Caitoo Preferences"));

  // add tabs
  conDlg = new DlgConnection(this);
  addTab(conDlg, i18n("Connection"));
  prxDlg = new DlgProxy(this);
  addTab(prxDlg, i18n("Proxy"));
  autDlg = new DlgAutomation(this);
  addTab(autDlg, i18n("Automation"));
  limDlg = new DlgLimits(this);
  addTab(limDlg, i18n("Limits"));
  advDlg = new DlgAdvanced(this);
  addTab(advDlg, i18n("Advanced"));
  dirDlg = new DlgDirectories(this);
  addTab(dirDlg, i18n("Directories"));
  sysDlg = new DlgSystem(this);
  addTab(sysDlg, i18n("System"));
  kdebug( KDEBUG_INFO, 5001, "System");

  // buttons
  setOkButton( i18n("OK") );
  setCancelButton( i18n("Cancel") );
  setDefaultButton( i18n("Help") );

  connect(this, SIGNAL(defaultButtonPressed()), SLOT(helpShow()));
}


PreferencesDlg::~PreferencesDlg()
{
}


void PreferencesDlg::helpShow()
{
  kapp->invokeHTMLHelp(0, 0);
}

///////////////////

// forward data to DlgConnection
void PreferencesDlg::setConnectionData(QStrList *strList)
{
  conDlg->setData(strList);
}


QStrList PreferencesDlg::dataConnection() const
{
  return(conDlg->getData());
}

///////////////////

// set data in DlgProxy
void PreferencesDlg::setProxyData()
{
  prxDlg->setData();
}


void PreferencesDlg::dataProxy()
{
  prxDlg->getData();
}

///////////////////

// forward data to DlgAutomation
void PreferencesDlg::setAutomationData(QStrList *strList)
{
  autDlg->setData(strList);
}

QStrList PreferencesDlg::dataAutomation() const
{
  return(autDlg->getData());
}

///////////////////

// forward data to DlgLimits
void PreferencesDlg::setLimitsData(QStrList *strList)
{
  limDlg->setData(strList);
}

QStrList PreferencesDlg::dataLimits() const
{
  return(limDlg->getData());
}

///////////////////

// forward data to DlgAdvanced
void PreferencesDlg::setAdvancedData(QStrList *strList)
{
  advDlg->setData(strList);
}

QStrList PreferencesDlg::dataAdvanced() const
{
  return(advDlg->getData());
}

///////////////////

// forward data to DlgDirectories
void PreferencesDlg::setDirectoriesData(QStrList *strList)
{
  dirDlg->setData(strList);
}

QStrList PreferencesDlg::dataDirectories() const
{
  return (dirDlg->getData());
}

///////////////////

// forward data to DlgSystem
void PreferencesDlg::setSystemData(QStrList *strList)
{
  sysDlg->setData(strList);
}

QStrList PreferencesDlg::dataSystem() const
{
  return(sysDlg->getData());
}

void PreferencesDlg::setFontData(QFont font)
{
  sysDlg->setFontData(font);
}

QFont PreferencesDlg::dataFont() const
{
  return(sysDlg->getFontData());
}

///////////////////
