/* $Id$
   $Log$

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef _DROPTARGET_H
#define _DROPTARGET_H

#include <qwidget.h>
#include <qbitmap.h>
#include <qpopupmenu.h>

#include <drag.h>

class DropTarget : public QWidget
{
  Q_OBJECT

public:
  DropTarget();
  ~DropTarget();

  void setAnim( int i1, int i2, int i3, int i4, bool online );

  void writeSettings();

protected:
  virtual void resizeEvent( QResizeEvent * );

private slots:

  void toggleSticky();

  void mousePressEvent(QMouseEvent *e);
  void slotDropEvent( KDNDDropZone * );
  void slotRestore();

private:
  QPopupMenu *popupMenu;

  bool b_sticky;

  int pop_sticky;

  int size[4];

  QPixmap *handpix1;
  QPixmap *handpix2;
  QPixmap *handpix3;

  QBitmap mask;
};

#endif // _DROPTARGET_H
