/* $Id: dlgDirectories.cpp,v 1.4 1999/05/01 09:20:44 koss Exp $
   $Log: dlgDirectories.cpp,v $
   Revision 1.4  1999/05/01 09:20:44  koss
   added test for multiple extensions. Acceptable is only one extension
   and one directpry per line

   Revision 1.3  1999/04/18 08:11:09  kulow
   CVS_SILENT fixing some header files (mainly adding klocale.h)

   Revision 1.2  1999/04/17 11:17:00  koss
   should now work ok

   Revision 1.1  1999/04/08 17:12:20  koss
   new dialog for default directories


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <qlayout.h>
#include <qdir.h>

#include <kapp.h>
#include <kfiledialog.h>
#include <kmsgbox.h>

#include "dlgDirectories.h"
#include <klocale.h>

extern QString getStringFromInt( int x );
extern int getIntFromString( QString s );

DlgDirectories::DlgDirectories(QWidget *parent, const char *name, WFlags f)
  : QWidget(parent, name, f)
{

  QVBoxLayout *topLayout = new QVBoxLayout( this, 10, 5 );
  topLayout->addSpacing( 5 );

  gb_directories = new QGroupBox(this, "gb_directories");
  gb_directories->setTitle(i18n("Directories Options"));
  topLayout->addWidget( gb_directories, 5 );

  QGridLayout *directoriesLayout = new QGridLayout( gb_directories, 7, 7, 20, 5 );

  directoriesLayout->addRowSpacing(0,5);
  directoriesLayout->addRowSpacing(6,5);

  directoriesLayout->addColSpacing(0,5);
  directoriesLayout->addColSpacing(6,5);

  directoriesLayout->setRowStretch(0,3);
  directoriesLayout->setRowStretch(1,15);
  directoriesLayout->setRowStretch(2,15);
  directoriesLayout->setRowStretch(3,5);
  directoriesLayout->setRowStretch(4,5);
  directoriesLayout->setRowStretch(5,5);
  directoriesLayout->setRowStretch(6,3);
    
  directoriesLayout->setColStretch(0,3);
  directoriesLayout->setColStretch(1,5);
  directoriesLayout->setColStretch(2,5);
  directoriesLayout->setColStretch(3,5);
  directoriesLayout->setColStretch(4,5);
  directoriesLayout->setColStretch(5,5);
  directoriesLayout->setColStretch(6,3);

  // table of entries
  kt_entries = new KTabListBox( gb_directories, "", 2);

//   kt_entries->setFixedSize( 385, 150 );
  kt_entries->setColumn( 0, i18n("Extension"), 100 );
  kt_entries->setColumn( 1, i18n( "Default Directory" ), 281 );
  connect( kt_entries, SIGNAL(highlighted( int, int )), SLOT(selectEntry( int )) );

  directoriesLayout->addMultiCellWidget( kt_entries, 1, 3, 1, 4 );

  QPixmap pixmap;
  pixmap.load( kapp->kde_toolbardir() + "/up.xpm" ); 
  pb_up = new QPushButton( gb_directories );
  pb_up->setFixedSize( pb_up->sizeHint() );
  pb_up->setPixmap( pixmap );
  connect( pb_up, SIGNAL( clicked() ), SLOT( upEntry() ) );
  directoriesLayout->addWidget( pb_up, 2, 5 );

  pixmap.load( kapp->kde_toolbardir() + "/down.xpm" ); 
  pb_down = new QPushButton( gb_directories );
  pb_down->setFixedSize( pb_down->sizeHint() );
  pb_down->setPixmap( pixmap );
  connect( pb_down, SIGNAL( clicked() ), SLOT( downEntry() ) );
  directoriesLayout->addWidget( pb_down, 3, 5 );

  // edit entries
  le_ext = new QLineEdit( gb_directories );
  le_ext->setFixedHeight( le_ext->sizeHint().height() );
  directoriesLayout->addMultiCellWidget( le_ext, 4, 4, 1, 2 );

  le_dir = new QLineEdit( gb_directories );
  le_dir->setFixedHeight( le_dir->sizeHint().height() );
  directoriesLayout->addMultiCellWidget( le_dir, 4, 4, 3, 4 );

  // edit buttons
  pb_add = new QPushButton( i18n("Add"), gb_directories );
  pb_add->setFixedSize( pb_add->sizeHint() );
  directoriesLayout->addWidget( pb_add, 5, 1 );
  connect( pb_add, SIGNAL(clicked()), SLOT(addEntry()) );

  pb_delete = new QPushButton( i18n("Delete"), gb_directories );
  pb_delete->setFixedSize( pb_delete->sizeHint() );
  directoriesLayout->addWidget( pb_delete, 5, 2 );
  connect( pb_delete, SIGNAL(clicked()), SLOT(deleteEntry()) );

  pb_change = new QPushButton( i18n("Change"), gb_directories );
  pb_change->setFixedSize( pb_change->sizeHint() );
  directoriesLayout->addWidget( pb_change, 5, 3 );
  connect( pb_change, SIGNAL(clicked()), SLOT(changeEntry()) );

  pb_browse = new QPushButton( i18n("Browse"), gb_directories );
  pb_browse->setFixedSize( pb_browse->sizeHint() );
  directoriesLayout->addWidget( pb_browse, 5, 4 );
  connect( pb_browse, SIGNAL(clicked()), SLOT(browse()) );

  //
  topLayout->addSpacing( 5 );

}


DlgDirectories::~DlgDirectories()
{
}


void DlgDirectories::selectEntry( int index )
{

  int id = kt_entries->currentItem();

  if ( id < 0 || ! kt_entries->isMarked( id ) )
    return;

  kt_entries->unmarkAll();
  kt_entries->markItem( id );

  le_ext->setText( kt_entries->text( id, 0 ) );
  le_dir->setText( kt_entries->text( id, 1 ) );
}


void DlgDirectories::addEntry()
{
  QString row = le_ext->text();
  row += "\n";
  row += le_dir->text();

  if ( row.contains( "," ) ) {
    KMsgBox::message( this, i18n( "Caitoo Error" ), i18n("Each row consist of one extension type and one directory"));
    return;
  }

  if ( row != "\n" )
    kt_entries->insertItem( row, 0 );

}


void DlgDirectories::deleteEntry() {

  int id = kt_entries->currentItem();

  if ( id < 0 || ! kt_entries->isMarked( id ) )
    return;

  kt_entries->removeItem( id );
}


void DlgDirectories::changeEntry() {

  int id = kt_entries->currentItem();

  if ( id < 0 || ! kt_entries->isMarked( id ) )
    return;

  QString row = le_ext->text();
  row += "\n";
  row += le_dir->text();

  if ( row.contains( "," ) ) {
    KMsgBox::message( this, i18n( "Caitoo Error" ), i18n("Each row consist of one extension type and one directory"));
    return;
  }

  if ( row != "\n" )
    kt_entries->changeItem( row, id );
}


void DlgDirectories::upEntry() {

  int id = kt_entries->currentItem();

  if ( id < 1 || ! kt_entries->isMarked( id ) )
    return;

  QString txt = kt_entries->text( id );

  kt_entries->removeItem( id );
  kt_entries->insertItem( txt, id - 1 );
  kt_entries->setCurrentItem( id - 1 );
}


void DlgDirectories::downEntry() {

  uint id = kt_entries->currentItem();

  if ( id < 0 || ( id == kt_entries->count() - 1) || ! kt_entries->isMarked( id ) )
    return;

  QString txt = kt_entries->text( id );

  kt_entries->removeItem( id );
  kt_entries->insertItem( txt, id + 1 );
  kt_entries->setCurrentItem( id + 1 );
}


void DlgDirectories::browse() {

  le_dir->setText( KFileDialog::getDirectory( QDir::currentDirPath() ) );
}


void DlgDirectories::setData(QStrList *strList)
{

  uint j = strList->count() / 2;
  for ( uint i = 0; i < j; i++ ) {
    QString row = strList->first();
    row += "\n";
    row += strList->next();
    strList->removeFirst();
    strList->removeFirst();

    kt_entries->insertItem( row );
  }
}


static QStrList strList(true);

QStrList DlgDirectories::getData() const
{
  strList.clear();
  
  for ( uint i = 0; i < kt_entries->count(); i++ ) {
    strList.append( kt_entries->text( i, 0 ) );
    strList.append( kt_entries->text( i, 1 ) );
  }

  return strList;
}
