/* $Id: dlgConnection.cpp,v 1.2 1999/02/19 15:40:29 koss Exp $
   $Log: dlgConnection.cpp,v $
   Revision 1.2  1999/02/19 15:40:29  koss
   disabled unsupported features

   Revision 1.1.1.1  1999/02/10 18:16:34  koss
   Imported sources

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <qlayout.h>

#include <kapp.h>
#include <kio_manager.h>

#include "dlgConnection.h"


extern QString getStringFromBool( bool x );
extern QString getStringFromInt( int x );
extern bool getBoolFromString( QString s );
extern int getIntFromString( QString s );

DlgConnection::DlgConnection(QWidget *parent, const char *name, WFlags f)
  : QWidget(parent, name, f)
{

  QVBoxLayout *topLayout = new QVBoxLayout( this, 10, 5 );
  topLayout->addSpacing( 5 );

  // reconnect settings
  gb_reconnect = new QGroupBox(this, "gb_reconnect");
  gb_reconnect->setTitle(i18n("Reconnecting Options"));
  topLayout->addWidget( gb_reconnect, 15 );

  QGridLayout *reconnectLayout = new QGridLayout(gb_reconnect, 8, 6, 15);

  reconnectLayout->addRowSpacing(0,10);
  reconnectLayout->addRowSpacing(4,5);
  reconnectLayout->addRowSpacing(7,10);

  reconnectLayout->addColSpacing(0,5);
  reconnectLayout->addColSpacing(5,5);

  reconnectLayout->setRowStretch(0,5);
  reconnectLayout->setRowStretch(1,5);
  reconnectLayout->setRowStretch(2,5);
  reconnectLayout->setRowStretch(3,5);
  reconnectLayout->setRowStretch(4,5);
  reconnectLayout->setRowStretch(5,5);
  reconnectLayout->setRowStretch(6,5);
  reconnectLayout->setRowStretch(7,5);

  reconnectLayout->setColStretch(0,2);
  reconnectLayout->setColStretch(1,5);
  reconnectLayout->setColStretch(2,10);
  reconnectLayout->setColStretch(3,5);
  reconnectLayout->setColStretch(4,5);
  reconnectLayout->setColStretch(5,2);

  cb_onerror = new QCheckBox(i18n("On login or timeout error"), gb_reconnect );
  cb_onerror->setMinimumSize( cb_onerror->sizeHint() );
  reconnectLayout->addMultiCellWidget( cb_onerror, 1, 1, 1, 3 );

  lb_after = new QLabel(i18n("reconnect after"), gb_reconnect);
  reconnectLayout->addWidget( lb_after, 2, 2 );

  le_after = new KIntegerLine(gb_reconnect);
  le_after->setFixedHeight( le_after->sizeHint().height() );
  reconnectLayout->addWidget( le_after, 2, 3 );

  lb_minutes1 = new QLabel(i18n("minutes"), gb_reconnect);
  reconnectLayout->addWidget( lb_minutes1, 2, 4 );

  lb_retries = new QLabel(i18n("number of retries"), gb_reconnect);
  reconnectLayout->addWidget( lb_retries, 3, 2 );

  le_retries = new KIntegerLine(gb_reconnect);
  le_retries->setFixedHeight( le_retries->sizeHint().height() );
  reconnectLayout->addWidget( le_retries, 3, 3 );
  
  connect( cb_onerror, SIGNAL(toggled(bool)),le_after, SLOT(setEnabled(bool)) );
  connect( cb_onerror, SIGNAL(toggled(bool)),le_retries, SLOT(setEnabled(bool)) );

  cb_onbroken = new QCheckBox(i18n("On broken connection"), gb_reconnect );
  cb_onbroken->setMinimumSize( cb_onbroken->sizeHint() );
  reconnectLayout->addMultiCellWidget( cb_onbroken, 5, 5, 1, 3 );

  cb_autoresume = new QCheckBox(i18n("Automatically resume if possible"), gb_reconnect );
  cb_autoresume->setMinimumSize( cb_autoresume->sizeHint() );
  reconnectLayout->addMultiCellWidget( cb_autoresume, 6, 6, 1, 3 );

  reconnectLayout->activate();

  // type settings
  gb_type = new QGroupBox(this, "gb_type");
  gb_type->setTitle(i18n("Type of connection"));
  topLayout->addWidget( gb_type, 15 );

  QGridLayout *typeLayout = new QGridLayout(gb_type, 4, 6, 10);

  typeLayout->addRowSpacing(0,10);
  typeLayout->addRowSpacing(2,10);

  typeLayout->addColSpacing(0,5);
  typeLayout->addColSpacing(3,5);
  typeLayout->addColSpacing(5,5);

  typeLayout->setRowStretch(0,5);
  typeLayout->setRowStretch(1,5);
  typeLayout->setRowStretch(2,5);

  typeLayout->setColStretch(0,2);
  typeLayout->setColStretch(1,5);
  typeLayout->setColStretch(2,5);
  typeLayout->setColStretch(3,5);
  typeLayout->setColStretch(4,5);

  cmb_type = new QComboBox( gb_type );

  cmb_type->insertItem( i18n("Permanent") );
  cmb_type->insertItem( i18n("Ethernet") );
  cmb_type->insertItem( i18n("PLIP") );
  cmb_type->insertItem( i18n("SLIP") );
  cmb_type->insertItem( i18n("PPP") );
  cmb_type->insertItem( i18n("ISDN") );
  cmb_type->setFixedSize( cmb_type->sizeHint() );
  typeLayout->addWidget( cmb_type, 1, 1 );

  le_linknum = new KIntegerLine(gb_type);
  le_linknum->setFixedHeight( le_linknum->sizeHint().height() );
  typeLayout->addWidget( le_linknum, 1, 2 );

  cb_offlinemode = new QCheckBox(i18n("Offline mode"), gb_type );
  cb_offlinemode->setMinimumSize( cb_offlinemode->sizeHint() );
  typeLayout->addWidget( cb_offlinemode, 1, 4 );

  connect( cmb_type, SIGNAL(activated(int)), this, SLOT(comboActivated(int)) );

  //
  topLayout->addSpacing( 5 );
  topLayout->activate();

}


DlgConnection::~DlgConnection()
{
}


void DlgConnection::comboActivated( int Index ) {

  if ( Index == 0 )
    le_linknum->setEnabled( false );
  else
    le_linknum->setEnabled( true );

}


void DlgConnection::setData(QStrList *strList)
{
  bool tmp = getBoolFromString( strList->first() );
  le_after->setEnabled( tmp );
  le_retries->setEnabled( tmp );
  cb_onerror->setChecked( tmp );
  
  le_after->setValue( getIntFromString( strList->next() ) );
  le_retries->setValue( getIntFromString( strList->next() ) );

  cb_onbroken->setChecked( getBoolFromString( strList->next() ) );

  cb_autoresume->setChecked( ProtocolManager::self()->getAutoResume() );

  cmb_type->setCurrentItem( getIntFromString( strList->next() ) );

  if ( cmb_type->currentItem() == 0 ) {
    le_linknum->setValue( 0 );
    le_linknum->setEnabled( false );
  }
  else
    le_linknum->setValue( getIntFromString( strList->next() ) );

  cb_offlinemode->setChecked( getBoolFromString( strList->next() ) );

}


static QStrList strList(true);


QStrList DlgConnection::getData() const
{
  strList.clear();
  QString tmp;
  
  strList.append( getStringFromBool( cb_onerror->isChecked() ) );
  
  strList.append( getStringFromInt( le_after->value() ) );
  strList.append( getStringFromInt( le_retries->value() ) );

  strList.append( getStringFromBool( cb_onbroken->isChecked() ) );
  ProtocolManager::self()->setAutoResume(  cb_autoresume->isChecked() );

  strList.append( getStringFromInt( cmb_type->currentItem() ) );

  if ( cmb_type->currentItem() != 0 )
    strList.append( getStringFromInt( le_linknum->value() ) );

  strList.append( getStringFromBool( cb_offlinemode->isChecked() ) );

  return strList;
}

