#ifndef videoclip_h
#define videoclip_h

#include <stdlib.h>
#include <v4lxif.h>

#define AUDIO_NONE      0
#define AUDIO_PCM       1
#define AUDIO_ALAW      2
#define AUDIO_MULAW     4

#define POST_NOTHING     0
#define POST_RGB_SWAP    1
#define POST_UNPACK422   2
#define POST_UNPACK411   3
#define POST_RAW         4

/* ------------------------------------------------------------------------- */

struct GRAB_FORMAT {
  char *ext;
  char *name;
  int  bt848;
  int  mul,div;
  int  post;
  int  can_sound;
  int  can_singlefile;      // write all data to one file
  int  can_multiplefile;    // write each image to one file
};

static struct GRAB_FORMAT avi_formats[] = {
  /* video */
  { ".avi","15 bit palette",        VIDEO_PALETTE_RGB555,      2, 1,  POST_NOTHING,   1,1,0 },
  { ".avi","24 bit palette",        VIDEO_PALETTE_RGB24,       3, 1,  POST_RGB_SWAP,  1,1,0 },
  { ".avi","32 bit palette",        VIDEO_PALETTE_RGB32,       4, 1,  POST_RGB_SWAP,  1,1,0 },
  { NULL,   NULL, 3,                         0, 0,  0              }
};
static struct GRAB_FORMAT file_formats[] = {
  /* file formats */
  { ".ppm",  "ppm files (24 bit)",  VIDEO_PALETTE_RGB24,       3, 1,  POST_RGB_SWAP,  0,0,1 },
  { ".pgm",  "pgm files (8 bit)",   VIDEO_PALETTE_GREY,        1, 1,  POST_NOTHING,   0,0,1 },
#ifdef HAVE_LIBJPEG
  { ".jpeg", "jpeg files (24 bit)", VIDEO_PALETTE_RGB24,       3, 1,  POST_RGB_SWAP,  0,0,1 },
  { NULL,   NULL,    3,                         0, 0,  0              }
#else
  { NULL,   NULL,    2,                         0, 0,  0              }
#endif
};
static struct GRAB_FORMAT raw_formats[] = {
  /* raw data */
  { ".rgb",  "24 bit palette ",     VIDEO_PALETTE_RGB24,       3, 1,  POST_RGB_SWAP,  0,1,1 },
  { ".gray", "grey palette",        VIDEO_PALETTE_GREY,        1, 1,  POST_NOTHING,   0,1,1 },
  { ".411",  "YUV411",              VIDEO_PALETTE_YUV422,      3, 2,  POST_UNPACK411, 0,1,1 },
  { ".422",  "YUV422",              VIDEO_PALETTE_YUV422,      2, 1,  POST_UNPACK422, 0,1,1 },
  { ".raw",  "raw data",            VIDEO_PALETTE_RAW,         1, 1,  POST_NOTHING,   0,1,1 },
  { NULL,   NULL, 4,                         0, 0,  0              },
};


/* ------------------------------------------------------------------------- */
/* movie output interface                                                    */

struct MOVIE_PARAMS {
  int video_clip;             // avi, file, raw 
  char filename[500];
  char extension[20];         
  // video
  int video_format;           // VIDEO_PALETTE_*
  int width, height;          // size of clip
  int fps;                    //frames per second 
  int quality;                // for copressed images, 0..100%
  // audio
  int audio_format;           // AUDIO_*
  int channels;               //0 = no sound, 1 = mono, 2 = stereo 
  int bits;                   // 8/16 
  int rate;                   // sample rate in kHz (11025 etc) 
};


/* ------------------------------------------------------------------------- */

class videoClip
{
public:
  videoClip() { name=(char*)malloc(255); ext=(char*)malloc(255); }
  virtual ~videoClip() { free(name); free(ext); }

  virtual int open(char *filename, struct MOVIE_PARAMS *par) = 0;
  virtual int writeframe(char * data) = 0;
  virtual int close() = 0;

  virtual int nframes() = 0;
  struct MOVIE_PARAMS *parameter() { return &params; }
    
protected:
  // file handle 
  int fd;
  char file[256];
  
  struct MOVIE_PARAMS params;
  
  // audio stuff 
  bool have_audio;

  int frames;

  char  *name;                /* format */
  char  *ext;                 /* extention */
  int   video_formats;        /* what we can handle */
  int   audio_formats;
};


#endif
