#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <ctype.h>

#include "ppmvideoclip.h"
#include "colorspace.h"

// ---- bttv stuff -----
#include <asm/types.h>        /* some warnings with glibc */ 

#ifdef HAVE_CONFIG_H
#include <config.h>  // config.h by configure
#endif

#ifdef USE_KERNEL_VIDEODEV
#include <linux/videodev.h>
#else
#include <videodev.h>
#endif

static char graberror[256];
#define GRAB_PERROR(action,file) \
  {sprintf(graberror,"%s: %s: %s",action,file,strerror(errno));fprintf(stderr,graberror);return -1;}

#define TRAP(txt) fprintf(stderr,"%s:%d:%s\n",__FILE__,__LINE__,txt);exit(1);

/* ----------------------------------------------------------------------- */
ppmVideoClip::ppmVideoClip():videoClip()
{
  strcpy(name,"stream files");
  video_formats=VIDEO_PALETTE_GREY | VIDEO_PALETTE_RGB24;
  audio_formats=AUDIO_NONE;
}

int ppmVideoClip::open(char *filename, struct MOVIE_PARAMS *par)
{
  frames=0;

  strcpy(ext,file_formats[par->video_format].ext);
  strcpy(name,filename);strcat(name,"00000");
  if (strstr(name,ext) == NULL) strcat(name,ext);
  strcpy(par->extension,ext);

  memcpy(&params,par,sizeof(params));

  frame_bytes  = params.width * params.height * 
    file_formats[par->video_format].mul / file_formats[par->video_format].div;

  screen_bytes = file_formats[par->video_format].mul;

  framebuf = (unsigned char *)malloc(frame_bytes);

  return 0;
}

int ppmVideoClip::writeframe(char * data)
{
  if ( params.video_format == 1 ) {
    
    // write pgm file

    if ( NULL == (fp = fopen(name,"w"))) 
      GRAB_PERROR("open",name);
    patch_up(name);
    
    fprintf(fp,"P5\n%d %d\n255\n",params.width,params.height);
    fwrite(data,params.width/* *screen_bytes*/,params.height,fp);
    fclose(fp);
    
  } else if ( params.video_format == 0 ) {
    
    // write ppm file

    if ( NULL == (fp = fopen(name,"w"))) 
      GRAB_PERROR("open",name);
    patch_up(name);
    
    fprintf(fp,"P6\n%d %d\n255\n",params.width,params.height);
    rgb24_to_bgr24(framebuf,(unsigned char *)data,params.width,params.height);
    fwrite(framebuf,params.width*screen_bytes,params.height,fp);
    fclose(fp);
    
  } 
#ifdef HAVE_LIBJPEG
  else if ( params.video_format == 2 ) {

    rgb24_to_bgr24(framebuf,(unsigned char *)data,params.width,params.height);

    if ( NULL == (fp = fopen(name,"w"))) 
      GRAB_PERROR("open",name);
    patch_up(name);

    // write jpeg file
    cinfo.err = jpeg_std_error(&jerr);
    jpeg_create_compress(&cinfo);
    jpeg_stdio_dest(&cinfo, fp);
    cinfo.image_width = params.width;
    cinfo.image_height = params.height;
    cinfo.input_components = 3;
    cinfo.in_color_space = JCS_RGB;
    jpeg_set_defaults(&cinfo);
    jpeg_set_quality(&cinfo, 75, TRUE);
    jpeg_start_compress(&cinfo, TRUE);

    for (i = 0, line = framebuf; i < params.height; i++, line += params.width*3)
	jpeg_write_scanlines(&cinfo, &line, 1);
    
    jpeg_finish_compress(&(cinfo));
    jpeg_destroy_compress(&(cinfo));

    fclose(fp);
#endif
  }
  
  frames++;
  return 0;
}

int ppmVideoClip::close()
{
  free(framebuf);
  return 0;
}

/* file name count up */
void ppmVideoClip::patch_up(char *name)
{
  char *ptr;
  
  for (ptr = name+strlen(name); ptr >= name; ptr--)
    if (isdigit(*ptr))
      break;
  if (ptr < name)
    return;
  while (*ptr == '9' && ptr >= name)
    *(ptr--) = '0';
  if (ptr < name)
    return;
  if (isdigit(*ptr))
    (*ptr)++;
}

/* ----------------------------------------------------------------------- */
