/*
    This file is part of ktvision, a front end to frame grabber cards 
	for the KDE-Project
    
    Copyright (C) 1998 Oliver Burtchen <oliver.burtchen@rz.hu-berlin.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/


#include "kv4lapp.h"

//#ifdef DEBUG_V4LWIN
//#include "eventtype.h"
//#endif


Qv4lWin::Qv4lWin( QWidget *parent, const char *name, WFlags f )
	: QWidget( parent, name, f )
{
	vBuf = new video_buffer;
	vWin = new video_window;
	vTun = new video_tuner;
	vCap = new video_capability;
	vClip = new video_clip[100];
	vPic = new video_picture;
	
	win = new v4l_window;

	chanL = new QStrList(true);
	chanL->setAutoDelete(true);
		
	win->initStat = allVideoUninit;
	win->parent=0L;
	win->timerId=0;
	win->timerFlag=true;
	win->timer2Id=0;
	win->timer2Flag=true;
	win->clipSpace=0;
	win->clipSpaceOld=-1;
	one=1;
	zero=0;

	qv4lApp->installWidget(this);		
}

Qv4lWin::~Qv4lWin()
{
	setCapture(false);
	delete win;
	delete vClip;
	delete vCap;
	delete vTun;
	delete vWin;
	delete vBuf;
	delete vPic;
}


int
Qv4lWin::initialize( const char * devName)
{
	if (!isTopLevel())
		topLevelWidget()->installEventFilter(this);
		installEventFilter(this);

	win->initStat = (allVideoUninit | 
					allCapture | captureStatus ) & ~fullyClipped ;

	if (!devName){
#ifdef DEBUG_V4LWIN
		debug("device %s",devName);
#endif
		return win->initStat;}

	win->devName = new QString(devName);

/* ##########################################
Open device
*/
	if ((win->fbttv=open((const char *)*win->devName, O_RDWR)) < 0)
		return win->initStat;
	win->initStat &= ~getVideoDevice;
#ifdef DEBUG_V4LWIN
	debug ("fbttv %d", win->fbttv);
#endif
/* ##########################################
Get video-capabilities
*/
	if(ioctl(win->fbttv,VIDIOCGCAP,vCap))
		return win->initStat;
	win->initStat &= ~getVideoCapabilities;

	setMinimumSize(QSize(vCap->minwidth, vCap->minheight));
	setMaximumSize(QSize(vCap->maxwidth, vCap->maxheight));
	
#ifdef DEBUG_V4LWIN
	static char *device_cap[] = {
		"capture", "tuner", "teletext", "overlay", "chromakey", "clipping",
		"frameram", "scales", "monochrome", NULL};

	debug("\t name: %s",vCap->name);
	for (int i = 0; device_cap[i] != NULL; i++)
		if (vCap->type & (1 << i))
			debug("\t %s",device_cap[i]);
#endif

/* ##########################################
Get video-channels
*/

#ifdef DEBUG_V4LWIN
  debug("screen: channels: %d",vCap->channels);
#endif 
  	vChan = (struct video_channel*)malloc(sizeof(struct video_channel)
			* vCap->channels);
	memset(vChan,0,sizeof(struct video_channel) * vCap->channels);

	for (int i = 0; i < vCap->channels; i++) {
		vChan[i].channel = i;
		if (ioctl(win->fbttv,VIDIOCGCHAN,&vChan[i]))
			return win->initStat;

		chanL->append(vChan[i].name);
		
#ifdef DEBUG_V4LWIN
		debug("\t %s: %d %s%s %s%s",
		    vChan[i].name,
		    vChan[i].tuners,
		    (vChan[i].flags & VIDEO_VC_TUNER)   ? "tuner "  : "",
		    (vChan[i].flags & VIDEO_VC_AUDIO)   ? "audio "  : "",
		    (vChan[i].type & VIDEO_TYPE_TV)     ? "tv "     : "",
		    (vChan[i].type & VIDEO_TYPE_CAMERA) ? "camera " : "");
#endif
	}
	win->initStat &= ~getVideoChannels;


/* ##########################################
Get Window
*/
	if(ioctl(win->fbttv, VIDIOCGWIN, vWin))
		return win->initStat;
	win->initStat &= ~getVideoWindow;

/* ##########################################
Get Buffer
*/
	if(ioctl(win->fbttv, VIDIOCGFBUF, vBuf))
		return win->initStat;
	win->initStat &= ~getVideoBuffer;


/* ******************************************
This is not dynamic, get tuner 0
*/
/* ##########################################
Get Tuner
*/
	vTun->tuner=0;
	if(ioctl(win->fbttv, VIDIOCGTUNER, vTun))
		return win->initStat;
	win->initStat &= ~getTuner;


#ifdef DEBUG_V4LWIN
	debug ("tuner %d, name %s, range %lu-%lu, flag %u, 
		mode %u", vTun->tuner, vTun->name, vTun->rangelow, 
		vTun->rangehigh, vTun->flags, vTun->mode);


// 	__u32 flags;
// #define VIDEO_TUNER_PAL		1
// #define VIDEO_TUNER_NTSC	2
// #define VIDEO_TUNER_SECAM	4
// #define VIDEO_TUNER_LOW		8	/* Uses KHz not MHz */
// #define VIDEO_TUNER_STEREO_ON	128	/* Tuner is seeing stereo */
// 	__u16 mode;			/* PAL/NTSC/SECAM/OTHER */
// #define VIDEO_MODE_PAL		0
// #define VIDEO_MODE_NTSC		1
// #define VIDEO_MODE_SECAM	2
// #define VIDEO_MODE_AUTO		3
// 	__u16 signal;			/* Signal strength 16bit scale */

#endif

/* ##########################################
Ok, all getVideoInit done
*/
	win->initStat &= ~allGetVideoUninit;


/* ##########################################
Set some defaults
*/
	vWin->width=QWidget::width();
	vWin->height=QWidget::height();

	if (!isTopLevel()){
		vWin->x=mapToGlobal(pos()).x();
		vWin->y=mapToGlobal(pos()).y();}
	else {
		vWin->x=x();
		vWin->y=y();}
	
	vWin->clipcount=0;
	vWin->clips=0;
	vWin->flags=0;
	vWin->chromakey=0;
	

	vBuf->width=qv4lApp->desktop()->width();
	vBuf->height=qv4lApp->desktop()->height();
	vBuf->base=0;

	win->display = qt_xdisplay();
	win->screenNum = qt_xscreen();
	win->screen = ScreenOfDisplay(win->display, win->screenNum);
	win->oldX=0;
	win->oldY=0;
	win->oldWidth=0;
	win->oldHeight=0;
	QColor c;
	win->numBitPlanes = c.numBitPlanes();
	win->bpp = win->numBitPlanes / 8;
	
	vPic->brightness = 0x8000;
	vPic->colour = 0x8000;
	vPic->hue = 0x8000;
	vPic->contrast = 0x8000;
//	vPic->depth = 16;
//	vPic->palette = VIDEO_PALETTE_HI240;
	
	win->rwidth=vBuf->width;

	int base; 
	if (XF86DGAQueryVersion( win->display, &win->major, &win->minor))
		XF86DGAGetVideoLL( win->display, DefaultScreen(win->display),
		&base, &win->rwidth, &win->bank, &win->ram);

	if (base) vBuf->base = (void *) base;

#ifdef DEBUG_V4LWIN
	debug("Base 0x%x", (int)vBuf->base);
#endif
 
	if (win->rwidth < 960)
		if (win->rwidth > 640)
			win->rwidth=960;


// Should we verify the visual here ?

	vBuf->depth=win->numBitPlanes;
	vBuf->bytesperline = vBuf->width * win->bpp;

#ifdef DEBUG_V4LWIN
debug("Base 0x%x", (int)vBuf->base);
#endif

/* ##########################################
Set Capture off as default
*/
	ioctl(win->fbttv, VIDIOCCAPTURE, &zero);
	win->initStat |= capture;
	win->initStat |= captureStatus;

/* ##########################################
Set Buffer
*/
	if(ioctl(win->fbttv, VIDIOCSFBUF, vBuf))
		return win->initStat;
	win->initStat &= ~setVideoBuffer;

/* ##########################################
Set Window
*/
	if(ioctl(win->fbttv, VIDIOCSWIN, vWin))
		return win->initStat;
	win->initStat &= ~setVideoWindow;

/* ##########################################
Set video-Picture
*/
	setVPic();
	
/* ##########################################
Ok, all setVideoInit done for now 
*/
	win->initStat &= ~allSetVideoUninit;


/* ##########################################
Get Window state
*/

	{
	XWindowAttributes attrib;
	XSetWindowAttributes attribSet;

	XGetWindowAttributes( win->display, winId(), &attrib);

	if (attrib.map_state == IsUnmapped)
		win->initStat |= allCapture;

	if (attrib.map_state == IsUnviewable){
		win->initStat |= allCapture;
		win->initStat &= ~mapped;}

	if (attrib.map_state == IsViewable){
		win->initStat |= allCapture;
		win->initStat &= (~mapped & ~unObscured);}
#ifdef DEBUG_V4LWIN
if (!attrib.all_event_masks) debug("None");
else
	for (int i=0; i<25;i++) 
		if (attrib.all_event_masks & (1L<<i)) debug("%d %s", i,eventmasks_names[i]);

debug ("Win %d - your_event_mask :", winId());
if (!attrib.your_event_mask) debug("None");
else
	for (int i=0; i<25;i++) 
		if (attrib.your_event_mask & (1L<<i)) debug("%d %s", i,eventmasks_names[i]);

debug ("Win %d - do_not_propagate_mask :", winId());
if (!attrib.do_not_propagate_mask) debug("None");
else
	for (int i=0; i<25;i++) 
		if (attrib.do_not_propagate_mask & (1L<<i)) debug("%d %s", i,eventmasks_names[i]);

debug ("event_Mask_of_screen");
if (!EventMaskOfScreen(win->screen)) debug("None");
else
	for (int i=0; i<25;i++) 
		if (EventMaskOfScreen(win->screen) & (1L<<i)) debug("%d %s", i,eventmasks_names[i]);

#endif
/* ##########################################
Tell the XServer we are intereted in Visibility-change-events
*/

	attribSet.event_mask = attrib.all_event_masks | VisibilityChangeMask;

	XChangeWindowAttributes( win->display, winId(), CWEventMask, &attribSet);
	}

/* ##########################################
Set old-style operation-End Flag
*/

	win->initStat &= ~captureFlag;

/* ##########################################
Ok, we are running, return 00000000
*/

	move(pos()); // sometimes the first move gets lost, reparent ?????
	return (0);

}


void Qv4lWin::setCapture( bool f)
{
	if (win->initStat & allVideoUninit)
		return;

	if (f)	{win->initStat &= ~capture;
		setCaptureIntern();}

	if (!f) {win->initStat |= capture;
		setCaptureIntern();}
}

void Qv4lWin::setCaptureIntern()
{
	if (win->initStat & allVideoUninit)
		return;

//set capture on
	if ((win->initStat & captureStatus) 
			&& !(win->initStat & (allCapture | fullyClipped))){	
		win->clipSpaceOld=-1;
		getClip();
		ioctl(win->fbttv, VIDIOCCAPTURE, &one);
		win->initStat &= ~captureStatus;
		return;}

// set capture off
	if (!(win->initStat & captureStatus)
			 && (win->initStat & (allCapture | fullyClipped))){	
		ioctl(win->fbttv, VIDIOCCAPTURE, &zero);
		win->initStat |= captureStatus;
		refreshScreen(1);
		QRect r;
		QPaintEvent * e = new QPaintEvent(r);
		qApp->postEvent(this, (QEvent*)e);
		qApp->processOneEvent();}
}


QRect Qv4lWin::getWinPosition()
{
	Window child;
	XWindowAttributes attribVideo;
	Window parent, root, *children;
	uint nchildren;
	
	XQueryTree(qt_xdisplay(), winId(), &root, &parent, &children, &nchildren);
	if(nchildren) XFree((Window *)children);

	XGetWindowAttributes( qt_xdisplay(), winId(), &attribVideo);

	XTranslateCoordinates( qt_xdisplay(), parent, root,
			attribVideo.x, attribVideo.y, 
			&attribVideo.x, &attribVideo.y, &child );


	
/* ##########################################
Adjust position and size to avoid flicker
*/	
 	if(win->bpp == 2)
 	 	if(attribVideo.x & 1){
			attribVideo.x++;
			attribVideo.width--;}
 	else if(win->bpp == 3)
	 	if(attribVideo.x & 3){
			attribVideo.x+= 4-(attribVideo.x & 3);
			attribVideo.width-= 4-(attribVideo.x & 3);}

	if(attribVideo.y & 1){
		attribVideo.y++;
		attribVideo.height--;}

	if(attribVideo.width & 3){
		attribVideo.width-=attribVideo.width & 3;}

	if(attribVideo.height & 1){
		attribVideo.height-=attribVideo.height & 3;}

	return QRect(attribVideo.x, attribVideo.y, 
				attribVideo.width, attribVideo.height);
}


void Qv4lWin::refreshScreen(int f)
{
#ifdef DEBUG_V4LWIN
	debug("screen: refresh");
#endif

	int depth;
	XSetWindowAttributes attribSet;
	XWindowAttributes attribVideo;
	unsigned long mask;
	Window rwin = 0L ,rootW;
  
	win->screenNum = qt_xscreen();
	rootW= qt_xrootwin();

	depth=win->numBitPlanes;

/* ##########################################
Tell the XServer we are not intereted in Visibility-Change-Events
and Expose-Events for now, so we get no infinite loop
*/

	XGetWindowAttributes( win->display, winId(), &attribVideo);
	attribSet.event_mask = attribVideo.your_event_mask 
							& ~(VisibilityChangeMask | ExposureMask);

	XSelectInput( win->display, winId(), attribSet.event_mask);
	

/* ##########################################
Make a Window above the video-window to clear space
*/

    
	attribSet.override_redirect = True;
	attribSet.backing_store = NotUseful;
	attribSet.save_under = False;
	attribSet.background_pixel=BlackPixel(win->display,win->screenNum);
	mask = (CWBackPixel | CWSaveUnder | CWBackingStore|
		CWOverrideRedirect );

	switch (f) {
	case 0:
		rwin = XCreateWindow(win->display,rootW,0, 0, 
			   vBuf->width,vBuf->height, 0,
			   CopyFromParent, InputOutput, CopyFromParent,
			   mask, &attribSet);
    		break;

	case 1:
		rwin = XCreateWindow(win->display,rootW,
			   vWin->x-40, vWin->y-40, 
			   vWin->width+80,vWin->height+80,
			   0,CopyFromParent, InputOutput, CopyFromParent,
			   mask, &attribSet);
		break;

	case 2:
		rwin = XCreateWindow(win->display,rootW,
			   win->oldX-40, win->oldY-40, 
			   win->oldWidth+80,win->oldHeight+80,
			   0,CopyFromParent, InputOutput, CopyFromParent,
			   mask, &attribSet);
		break;}

	XMapWindow(win->display, rwin);
    	XUnmapWindow(win->display, rwin);
    	XDestroyWindow(win->display, rwin);

/* ##########################################
Tell the XServer we are intereted in Visibility-Change-Events
and Expose-Events again
*/
	attribSet.event_mask = attribVideo.your_event_mask 
							| VisibilityChangeMask | ExposureMask ;

//	XChangeWindowAttributes( win->display, winId(), CWEventMask, &attribSet);
	XSelectInput( win->display, winId(), attribSet.event_mask);


}


void Qv4lWin::addClip(uint x,uint y,uint x2,uint y2)
{
	vClip[win->clipNum].x=x;
	vClip[win->clipNum].y=y;
	vClip[win->clipNum].width=x2-x;
	vClip[win->clipNum].height=y2-y;
	win->clipNum++;
	win->clipSpace += x+y+(x2-x)*(y2-y);
} 


bool Qv4lWin::getClip()
{
//Do not call setCaptureIntern from here, infinite loop;

	win->clipSpace=0;
	win->clipNum=0;

	int x,y,x2,y2,videoX,videoY;
	int offsetX=0;
	int offsetY=0;
	uint videoW,videoH;
	XWindowAttributes attrib;
	Window parent,parent2, rroot, *children, sWin;
	Window videoWin=(Window)winId();
	Window root=DefaultRootWindow(win->display);
	uint nchildren, i;

//get rid of videoX,Y,H,W	
	videoX=vWin->x; videoY=vWin->y;
	videoH=vWin->height; videoW=vWin->width;

/* ##########################################
Check for video-Window partially-outside screen
*/
#ifdef DEBUG_V4LWIN
debug("vBuf %d:%d", vBuf->width, vBuf->height);
debug("vWin %d:%d %d:%d %d:%d", vWin->x, vWin->y, vWin->width, vWin->height, vWin->x+vWin->width, vWin->height+vWin->y);
#endif

	if (videoX<0)
		addClip(0, 0, (uint)(-videoX), videoH-1);

	if (videoY<0)
		addClip(0, 0, videoW-1, (uint)(-videoY));

	if ((videoX+(int)videoW) > vBuf->width)
		addClip(vBuf->width-videoX, 0, videoW-1, videoH-1);

	if ((videoY+(int)videoH) > vBuf->height)
		addClip( 0, vBuf->height-videoY, videoW-1, videoH-1);


/* ##########################################
Check for windows, where this is an anchor
*/

 	XQueryTree(win->display, videoWin, &rroot, &parent, &children, &nchildren);
 	for (int n=nchildren; n;n--){
 		XGetWindowAttributes(win->display, children[n-1], &attrib);
		if (!(attrib.map_state ))  continue;
		x=attrib.x; y=attrib.y;
		x2=x+attrib.width+2*attrib.border_width-1;
		y2=y+attrib.height+2*attrib.border_width-1;

		if ((x2 < 0) || (x >= (int)vWin->width)
				|| (y2 < 0) || (y >= (int)vWin->height))
			continue;

		if (x<0) x=0;
		if (y<0) y=0;
		if (x2>=(int)vWin->width) x2=vWin->width-1;
		if (y2>=(int)vWin->height) y2=vWin->height-1;
		addClip(x, y, x2, y2);
 	}
 	if(nchildren) XFree((Window *)children);

	if ( nchildren && !win->timerId)
		if(isTopLevel())
			win->timerId = startTimer(200);
		else 
			win->timerId = topLevelWidget()->startTimer(200);
	else 
		if (!nchildren && win->timerId 
				&& (win->visibility != VisibilityPartiallyObscured))
		{
			killTimer(win->timerId);
			win->timerId=0;
		}

	
/* ##########################################
Get TopLevelWindow (WindowManagerWindow)
Get offsetX, this is the real global position of the parent the window
*/

	sWin=videoWin;
	parent2=parent;
	while (parent!=root) {
		sWin=parent;
		XQueryTree(win->display, sWin, &rroot, &parent, &children, &nchildren);
		XGetWindowAttributes(win->display, sWin, &attrib);
		offsetX += attrib.x;
		offsetY += attrib.y;
		if (nchildren)
			XFree((Window *) children);
	}



/* ##########################################
Check for video-Window outside parent
*/
	XGetWindowAttributes(win->display, parent2, &attrib);
	x= offsetX;
	y= offsetY;

	if (videoX<x)
		addClip(0, 0, (uint)(x-videoX), videoH-1);

	if (videoY<y)
		addClip(0, 0, videoW-1, (uint)(y-videoY));

	if ((videoX+videoW) > (uint)(x+attrib.width))
		addClip(x + attrib.width - videoX , 0, 
			videoW-1, videoH-1);

	if ((videoY+videoH) > (uint)(y+attrib.height))
		addClip(0, y + attrib.height - videoY , 
			videoW-1, videoH-1);


/* ##########################################
Go to Window-Manager Window in root tree
*/

	XQueryTree(win->display, root, &rroot, &parent2, &children, &nchildren);
	for (i=0; i<nchildren;i++) 
		if (children[i]==sWin) break;

/* ##########################################
Check for Windows upper in stacking order
*/
	i++;
	for (; i<nchildren; i++) {
   		XGetWindowAttributes(win->display, children[i], &attrib);
		if (!(attrib.map_state ))  continue;
    
		x=attrib.x-vWin->x; y=attrib.y-vWin->y;
		x2=x+attrib.width+2*attrib.border_width-1;
		y2=y+attrib.height+2*attrib.border_width-1;

		if ((x2 < 0) || (x >= (int)videoW) || (y2 < 0) || (y >= (int)videoH))
			continue;

		if (x<0) x=0;
		if (y<0) y=0;
		if (x2>=(int)videoW) x2=videoW-1;
		if (y2>=(int)videoH) y2=videoH-1;
		addClip(x, y, x2, y2);
	}
	XFree((char *) children);


	if (win->clipSpace == win->clipSpaceOld)
		return false;
	else
		win->clipSpaceOld = win->clipSpace;

	vWin->clips=vClip;
	vWin->clipcount=win->clipNum;

//	ioctl(win->fbttv, VIDIOCCAPTURE, &zero);

	ioctl(win->fbttv, VIDIOCSWIN, vWin);
//	if (!(win->initStat & captureStatus))
//		ioctl(win->fbttv, VIDIOCCAPTURE, &one);

	if (win->initStat & fullyClipped)
		win->initStat &= ~fullyClipped;

	return true;
}


bool Qv4lWin::x11ExtraEventFilter( XEvent * e)
{
#ifdef DEBUG_V4LWIN
	static int nr;
	nr++;
	int state;
	int type = e->type;
	if (type == VisibilityNotify) state = e->xvisibility.state;
	else state = 0;
	debug("X %d:%d :%s %d", nr, type, xevent_names[type], state);
#endif

	switch (e->type){
	case UnmapNotify:
		win->initStat |= mapped;
		setCaptureIntern();
		return false;
		break;

	case MapNotify:
		win->initStat &= ~mapped;
		setCaptureIntern();
		return false;
		break;

	case Expose:
		if (e->xany.window == winId())
		{
#ifdef DEBUG_V4LWIN
		debug("winid 0x%lx", e->xany.window);
#endif
			if(win->initStat & (allVideoUninit | allCapture))
				return(false);
			win->clipSpaceOld=-1;
			getClip();
			return false;
		}
		break;
				
	case VisibilityNotify:
		if(win->initStat & allVideoUninit )
			return(true);
		win->visibility = e->xvisibility.state;
		emit visibilityChanged();

		if (win->visibility == VisibilityFullyObscured)
		{
			win->initStat |= unObscured;
			setCaptureIntern();
			refreshScreen(1);
			return (true);
		} else
			win->initStat &= ~unObscured;

		if (win->visibility == VisibilityPartiallyObscured && !win->timerId)
			if(isTopLevel())
			{
				win->timerId = startTimer(200);
			}
			else {
				win->timerId = topLevelWidget()->startTimer(200);
			}
		else
			if (win->timerId 
				&& (win->visibility != VisibilityPartiallyObscured))
			{
				killTimer(win->timerId);
				win->timerId=0;
			}

		if(win->initStat & allCapture)
			return(true);
		win->clipSpaceOld=-1;
		getClip();
		refreshScreen(1);
		setCaptureIntern();

		return false;
		break;

	case ConfigureNotify: 
		QRect p = getWinPosition();
#ifdef DEBUG_V4LWIN
debug("ConfigureNotify");
#endif
		win->oldX=vWin->x;
		win->oldY=vWin->y;
		win->oldWidth= vWin->width;
		win->oldHeight= vWin->height;
		vWin->x=p.x();
		vWin->y=p.y();
		vWin->width=p.width();
		vWin->height=p.height();
		if(win->initStat & (allVideoUninit | allCapture))
			return(false);
		win->clipSpaceOld=-1;
		getClip();
		refreshScreen(2);
		return(false);
		break;
	}
	return false;
}

#ifdef DEBUG_V4LWIN
void Qv4lWin::showEvents()
{
	XWindowAttributes attrib;

	XGetWindowAttributes( win->display, winId(), &attrib);

debug ("Win %d - all_event_masks :", winId());
	if (!attrib.all_event_masks)
		debug("None");
	else
		for (int i=0; i<25;i++) 
			if (attrib.all_event_masks & (1L<<i))
				debug("%d %s", i,eventmasks_names[i]);

	debug ("Win %d - your_event_mask :", winId());
	if (!attrib.your_event_mask)
		debug("None");
	else
		for (int i=0; i<25;i++)
			if (attrib.your_event_mask & (1L<<i))
				debug("%d %s", i,eventmasks_names[i]);


	debug ("Win %d - do_not_propagate_mask :", winId());
	if (!attrib.do_not_propagate_mask)
		debug("None");
	else
		for (int i=0; i<25;i++)
			if (attrib.do_not_propagate_mask & (1L<<i))
				debug("%d %s", i,eventmasks_names[i]);

	debug ("event_Mask_of_screen");
	if (!EventMaskOfScreen(win->screen))
		debug("None");
	else
		for (int i=0; i<25;i++) 
			if (EventMaskOfScreen(win->screen) & (1L<<i))
				debug("%d %s", i,eventmasks_names[i]);

}
#endif

bool Qv4lWin::eventFilter( QObject * , QEvent * e)
{
	if (e->type()==Event_Timer)
		if (win->timerId == ((QTimerEvent*)e)->timerId() 
				&& win->timerFlag && !(win->initStat & allCapture))
		{
			win->timerFlag = false;
			if(getClip()) refreshScreen(1);
			win->timerFlag=true;
			return(true);
		}
	return false;
}


QStrList * Qv4lWin::inputList()
{
	return new QStrList(*chanL);
}	

QStrList * Qv4lWin::formatList(int i)
{
	QStrList * tmp = new QStrList(true);
	video_tuner tun;
	if (i > (-1) && i < vCap->channels)
		if (vChan[i].flags & VIDEO_VC_TUNER )
		{
			tun.tuner=i;
			ioctl(win->fbttv, VIDIOCGTUNER, &tun);
			(tun.flags & VIDEO_TUNER_PAL) ? tmp->append("PAL")
					 : tmp->append("PAL  (N/A)");
			(tun.flags & VIDEO_TUNER_NTSC) ? tmp->append("NTSC")
					 : tmp->append("NTSC  (N/A)");
			(tun.flags & VIDEO_TUNER_SECAM) ? tmp->append("SECAM")
					 : tmp->append("SECAM  (N/A)");
		}
		else tmp->append("N/A");	
	return tmp;
}	
			
void Qv4lWin::setInput(int i)
{

	static int i2=0xff;
	if (i2 != i){
		ioctl(win->fbttv,VIDIOCSCHAN, &i);
		i2 = i;
	}
}

void Qv4lWin::setFormat(int i)
{
	if (vTun->mode != i){
			vTun->mode=i;
	ioctl(win->fbttv, VIDIOCSTUNER, vTun);}
}

void Qv4lWin::setFreq(unsigned long f)
{
	static unsigned long f2 = 0;
	if (f2 != f){
		ioctl(win->fbttv, VIDIOCSFREQ, &f);
		f2 = f;
	}
}


void Qv4lWin::setBright(long int i)
{
	if (i && i< 0x10000 && i!=vPic->brightness)
		vPic->brightness = i;
		setVPic();
}
			
void Qv4lWin::setHue(long int i)
{
	if (i && i< 0x10000 && i!=vPic->hue)
		vPic->hue = i;
		setVPic();
}

void Qv4lWin::setColor(long int i)
{
	if (i && i<0x10000 && i!=vPic->colour)
		vPic->colour = i;
		setVPic();
}
			
void Qv4lWin::setContrast(long int i)
{
	if (i && i<0x10000 && i!=vPic->contrast)
		vPic->contrast = i;
		setVPic();
}

void Qv4lWin::setVPic()
{
 	ioctl(win->fbttv, VIDIOCSPICT, vPic);
	
}

// 	__u16	brightness;
// 	__u16	hue;
// 	__u16	colour;
// 	__u16	contrast;
// 	__u16	whiteness;	/* Black and white only */
// 	__u16	depth;		/* Capture depth */
// 	__u16   palette;	/* Palette in use */
// #define VIDEO_PALETTE_GREY	1	/* Linear greyscale */
// #define VIDEO_PALETTE_HI240	2	/* High 240 cube (BT848) */
// #define VIDEO_PALETTE_RGB565	3	/* 565 16 bit RGB */
// #define VIDEO_PALETTE_RGB24	4	/* 24bit RGB */
// #define VIDEO_PALETTE_RGB32	5	/* 32bit RGB */	
// #define VIDEO_PALETTE_RGB555	6	/* 555 15bit RGB */
// #define VIDEO_PALETTE_YUV422	7	/* YUV422 capture */


/*
				if (vBuf->depth == 24){
					vWin->x=p.x() & ~3;
					vWin->y=p.y() & ~3;}
				else if (vBuf->depth == 16){
					vWin->x=p.x() & ~1;
					vWin->y=p.y() & ~1;}
*/


#include "qv4lwin.moc"
