/*
    This file is part of ktvision, a front end to frame grabber cards 
	for the KDE-Project
    
    Copyright (C) 1998 Oliver Burtchen <oliver.burtchen@rz.hu-berlin.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
#include "PictureDlg.h"
#include "tvwidget.h"
#define Inherited PictureDlgData

PictureDlg::PictureDlg
(
	QWidget* parent,
	const char* name,
	QStrList * actionText
)
	:
	Inherited( parent, name )
{

	brightLP->setText(actionText->at(BrightAction));
	hueLP->setText(actionText->at(HueAction));
	contrastLP->setText(actionText->at(ContrastAction));
	colorLP->setText(actionText->at(ColorAction));
	
	brightS = brightSP;
	hueS = hueSP;
	colorS = hueSP;
	contrastS = contrastSP;	
}


PictureDlg::~PictureDlg()
{
}

void PictureDlg::setValue(int f, int i)
{
	switch (f){
		case BrightAction:
			brightSP->setValue(i);
			break;
		case HueAction:
			hueSP->setValue(i);
			break;
		case ContrastAction:
			contrastSP->setValue(i);
			break;
		case ColorAction:
			colorSP->setValue(i);
			break;
	}					
}
#include "PictureDlg.moc"
#include "PictureDlgData.moc"
