#ifndef SONGWIDGET_H_INCLUDED
#define SONGWIDGET_H_INCLUDED

#include <qframe.h>
#include <qscrollbar.h>
#include <qpushbutton.h>
#include "constants.h"
#include "songbar.h"
#include "bscalebar.h"
#include "bbpmselect.h"
#include "bpositionbar.h"

class SongWidget : public QFrame {
Q_OBJECT
private:
    BPositionBar *positionbar;
    BScaleBar *scalebar;
    SongBar *bar[ MAX_CHANNELS ];
    QFrame *barframe;
    QScrollBar *rightscroll;
    QScrollBar *bottomscroll;
    QPushButton *zoomin;
    QPushButton *zoomout;
    QFrame *leftfiller;
    BBPMSelect *bpmselect;
    int hascursor;
    int topbar;
private slots:
    void barCursorUp( int channel, int pos );
    void barCursorDown( int channel, int pos );
    void barGiveCursor( int channel, int pos );
    void rightScrollBarMove( int newpos );
    void zoomInPattern();
    void zoomOutPattern();
public:
    SongWidget( QWidget *parent );
    void saveSong( int fd );
    void loadSong( int fd );
    void resizeEvent( QResizeEvent *rev );
    void repaintStuff();
};

#endif
